/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/mgr/commands/EditCommand
 */
define(['baja!', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/wb/mgr/BatchComponentEditor', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/model/source/ArrayComponentSource'], function (baja, _, Command, feDialogs, BatchComponentEditor, MgrCommand, MgrModel, Row, ArrayComponentSource) {
  'use strict';

  var _MgrCommand$flags = MgrCommand.flags,
    ALL_BARS = _MgrCommand$flags.ALL_BARS,
    MAIN_CONTEXT_MENU = _MgrCommand$flags.MAIN_CONTEXT_MENU;
  function makeSubMgrModel(manager) {
    var mgrModel = manager.getModel();
    var selectedRows = manager.getMainTable().getSelectedRows();
    var comps = _.map(selectedRows, function (row) {
      return row.getSubject();
    });
    return new MgrModel({
      componentSource: new ArrayComponentSource(comps),
      rows: selectedRows,
      columns: mgrModel.getEditableColumns()
    });
  }

  /**
   * Command for editing existing components in a Manager view.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/mgr/commands/EditCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   */
  var EditCommand = function EditCommand(manager) {
    var subMgrModel;
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.mgr.edit',
      enabled: false,
      flags: ALL_BARS | MAIN_CONTEXT_MENU,
      /**
       * Takes the components that are currently selected in the manager's
       * main table, and allows for editing them using a `BatchComponentEditor`.
       * @alias module:nmodule/webEditors/rc/wb/mgr/commands/EditCommand#invoke
       * @returns {Promise}
       */
      func: function func() {
        return manager.getOrdBase().then(function (ordBase) {
          return feDialogs.showFor({
            value: makeSubMgrModel(manager),
            properties: {
              ordBase: ordBase
            },
            type: BatchComponentEditor
          });
        }).then(function (subModel) {
          subMgrModel = subModel;
          if (subModel) {
            var dbModel = manager.getModel();
            var instances = _.invoke(subModel.getRows(), 'getSubject');
            return dbModel.postEdit(instances);
          }
        }).then(function () {
          return subMgrModel;
        });
      }
    });
  };
  EditCommand.prototype = Object.create(Command.prototype);
  EditCommand.prototype.constructor = EditCommand;
  return EditCommand;
});
