/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/menu/navMenuAgent
 */
define(['bajaux/commands/CommandGroup', 'underscore', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/wb/menu/Separator'], function (CommandGroup, _, ExportCommand, menuUtils, Separator) {
  'use strict';

  var makeViewsGroup = menuUtils.makeViewsGroup;

  /**
   * @alias module:nmodule/webEditors/rc/wb/menu/navMenuAgent
   * @param {module:bajaux/Widget} widget
   * @param {baja.Component} comp
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   */
  var navMenuAgent = function navMenuAgent(widget, comp) {
    return menuUtils.ifAllowedByProfile('viewSelection', function () {
      return makeViewsGroup(comp.getNavOrd());
    }).then(function (viewsGroup) {
      var commands,
        exportCommand = new ExportCommand(comp);
      commands = viewsGroup ? [viewsGroup, new Separator(), exportCommand] : [exportCommand];
      return new CommandGroup({
        commands: commands
      });
    });
  };
  return navMenuAgent;
});
