function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/job/commands/ViewLogCommand
 */
define(['baja!', 'jquery', 'underscore', 'Promise', 'dialogs', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/wb/job/commands/JobCommand', 'nmodule/webEditors/rc/wb/job/jobSupport', 'nmodule/webEditors/rc/wb/table/Table'], function (baja, $, _, Promise, dialogs, fe, JobCommand, jobSupport, Table) {
  "use strict";

  /**
   * Command to read the JobLog via the action on the BJob and display it in
   * a dialog.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/job/commands/JobCommand
   * @alias nmodule/webEditors/rc/wb/job/commands/ViewLogCommand
   * @param {baja.Component|module:nmodule/webEditors/rc/wb/job/JobBar} job
   */
  var readLogItems = jobSupport.readLogItems,
    makeLogTableRow = jobSupport.makeLogTableRow,
    makeLogModel = jobSupport.makeLogModel,
    showItemDetailsDialog = jobSupport.showItemDetailsDialog;
  var ViewLogCommand = /*#__PURE__*/function (_JobCommand) {
    function ViewLogCommand(job) {
      var _this;
      _classCallCheck(this, ViewLogCommand);
      _this = _callSuper(this, ViewLogCommand, [job, {
        module: 'webEditors',
        lex: 'commands.viewLog',
        enabled: true,
        /**
         * Function called to read the job log via an action on the BJob.
         * @returns {Promise}
         */
        func: function func() {
          var _ref = _this.getJobs() || [],
            _ref2 = _slicedToArray(_ref, 1),
            job = _ref2[0];
          if (!job) {
            return Promise.resolve();
          }

          /**
           * Create and show the dialog containing the table of log entries.
           */
          function showLogDialog(params) {
            // eslint-disable-next-line promise/avoid-new
            return new Promise(function (resolve, reject) {
              dialogs.showOk({
                title: params.title,
                content: function content(dlg, _content) {
                  return fe.buildFor(params).then(function (ed) {
                    _content.prepend(ed.jq());
                    configureDoubleClick(params.dom);
                    dlg.ok(function () {
                      ed.jq().off();
                      return ed.destroy();
                    });
                  })["catch"](reject);
                }
              });
            });
          }
          return readLogItems(job).then(function (items) {
            var rows = _.map(items, makeLogTableRow),
              model = makeLogModel(rows, {});
            return showLogDialog({
              dom: $('<table class="ux-table job-log-table"/>'),
              value: model,
              type: Table
            });
          });
        }
      }]);
      function configureDoubleClick(elem) {
        elem.on('dblclick', 'tr', function (e) {
          var tr = $(e.target),
            table = tr.closest('.job-log-table').data('widget'),
            item = _.head(table.getSubject(tr));
          showItemDetailsDialog(item);
        });
      }
      return _this;
    }

    /**
     * @override
     * @returns {baja.Value}
     */
    _inherits(ViewLogCommand, _JobCommand);
    return _createClass(ViewLogCommand, [{
      key: "getJobs",
      value: function getJobs() {
        var _superPropGet2 = _superPropGet(ViewLogCommand, "getJobs", this, 3)([]),
          _superPropGet3 = _slicedToArray(_superPropGet2, 1),
          job = _superPropGet3[0];
        if (typeof job.$getJob === 'function') {
          return [job.$getJob()];
        }
        return [job];
      }
    }]);
  }(JobCommand);
  return ViewLogCommand;
});
