function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/composite/commands/AddCommand
 */

define(['baja!', 'baja!baja:CompositeAction,baja:CompositeTopic', 'jquery', 'lex!workbench', 'Promise', 'underscore', 'bajaux/commands/Command', 'nmodule/webEditors/rc/wb/table/model/Row'], function (baja, types, $, lexs, Promise, _, Command, Row) {
  'use strict';

  var IN = 0,
    OUT = 1,
    IN_ICON = baja.Icon.make('module://icons/x16/arrowLeft.png'),
    OUT_ICON = baja.Icon.make('module://icons/x16/arrowRight.png'),
    ACTION_TYPE = baja.lt('baja:CompositeAction'),
    TOPIC_TYPE = baja.lt('baja:CompositeTopic'),
    READONLY_FLAG = baja.Flags.READONLY,
    unescape = baja.SlotPath.unescape;
  function makeUniqueName(composite, model, name) {
    var slots = composite.getSlots().toArray(),
      rows = model.getRows(),
      tempName = name,
      count = 1;
    for (var i = 0; i < slots.length; i++) {
      if (slots[i].getName() === tempName) {
        tempName = name + count;
        count += 1;
        i = -1;
      } else {
        for (var j = 0; j < rows.length; j++) {
          var _rows$j$getSubject = rows[j].getSubject(),
            _name = _rows$j$getSubject.name;
          if (_name === tempName) {
            tempName = _name + count;
            count += 1;
            j = rows.length;
            i = -1;
          }
        }
      }
    }
    return tempName;
  }
  function makeTableRow(params) {
    var dir = params.dir,
      name = params.name,
      ord = params.ord,
      slot = params.slot,
      type = params.type,
      readonly = params.readonly,
      backup = params.backup,
      flags = params.flags,
      subject = {
        dir: dir,
        name: unescape(name),
        ord: ord,
        slot: slot,
        type: type,
        readonly: readonly,
        flags: flags
      };
    if (backup) {
      subject.backup = _.clone(subject);
    }
    return new Row(subject, dir === IN ? IN_ICON : OUT_ICON);
  }
  function handleAdd(editor) {
    var composite = editor.value(),
      tree = editor.$getTree(),
      table = editor.$getTable(),
      model = table.value(),
      nodes = tree.getSelectedNodes(),
      rows;
    rows = _(nodes).map(function (node) {
      var parent = node.getParent().value(),
        name = node.getName(),
        ord = parent.getSlotPath().toString(),
        slot = parent.getSlot(name),
        slotName = slot.getName(),
        rows = model.getRows(),
        flags = parent.getFlags(slot),
        inExists,
        outExists;
      _(rows).each(function (row) {
        var _row$getSubject = row.getSubject(),
          tempOrd = _row$getSubject.ord,
          tempSlot = _row$getSubject.slot,
          dir = _row$getSubject.dir;
        if (tempOrd + tempSlot === ord + slotName) {
          if (dir === OUT) {
            outExists = true;
          }
          if (dir === IN) {
            inExists = true;
          }
        }
      });
      if (inExists && outExists) {
        return null;
      } else {
        var readonly = slot.isTopic() || !!(flags & READONLY_FLAG);
        if (outExists && readonly) {
          return null;
        }
        var dir = readonly ? OUT : IN;
        dir = outExists ? IN : inExists ? OUT : dir;
        var type = slot.isTopic() ? TOPIC_TYPE : slot.isAction() ? dir === IN ? ACTION_TYPE : TOPIC_TYPE : node.value() ? node.value().getType() : parent.get(name).getType();
        return makeTableRow({
          dir: dir,
          ord: ord,
          type: type,
          readonly: readonly,
          name: makeUniqueName(composite, model, name),
          slot: slotName,
          backup: false,
          flags: baja.Flags.COMPOSITE
        });
      }
    });
    return model.insertRows(_.compact(rows));
  }

  /**
   * AddCommand
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/composite/commands/AddCommand
   */
  var AddCommand = /*#__PURE__*/function (_Command) {
    function AddCommand(editor) {
      _classCallCheck(this, AddCommand);
      return _callSuper(this, AddCommand, [{
        module: "workbench",
        lex: 'compositeEditor.add',
        enabled: false,
        func: function func() {
          return handleAdd(editor);
        }
      }]);
    }
    _inherits(AddCommand, _Command);
    return _createClass(AddCommand, null, [{
      key: "$makeTableRow",
      value: function $makeTableRow(params) {
        return makeTableRow(params);
      }
    }]);
  }(Command);
  return AddCommand;
});
