function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/composite/CompositeEditor
 */
define([
//Core
'baja!', 'baja!baja:CompositeAction,baja:CompositeTopic', 'lex!workbench', 'log!nmodule.webEditors.rc.wb.composite.CompositeEditor', 'bajaux/Widget', 'jquery', 'underscore', 'Promise', 'bajaux/events',
//webEditors
'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor',
//Tree
'nmodule/webEditors/rc/wb/tree/NavTree', 'nmodule/webEditors/rc/wb/tree/TreeNode', 'nmodule/webEditors/rc/wb/tree/BajaComplexTreeNode',
//Table
'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/fe/baja/IconEditor',
//Commands
'bajaux/util/CommandButton', 'bajaux/commands/CommandGroup', 'bajaux/util/CommandButtonGroup', 'nmodule/webEditors/rc/wb/composite/commands/AddCommand', 'nmodule/webEditors/rc/wb/table/commands/MoveDownCommand', 'nmodule/webEditors/rc/wb/table/commands/MoveUpCommand', 'nmodule/webEditors/rc/wb/table/commands/RemoveCommand', 'nmodule/webEditors/rc/wb/table/commands/RenameCommand', 'nmodule/webEditors/rc/wb/composite/commands/ReverseCommand', 'nmodule/webEditors/rc/wb/composite/commands/CompositeCommand',
//Template
'hbs!nmodule/webEditors/rc/wb/composite/template/CompositeEditor',
//Styles
'css!nmodule/js/rc/jquery/split-pane/split-pane', 'css!nmodule/webEditors/rc/wb/composite/style/CompositeEditor',
//Split-pane plugin
'nmodule/js/rc/jquery/split-pane/split-pane'], function (baja, types, lexs, log, Widget, $, _, Promise, events, fe, BaseEditor, NavTree, TreeNode, BajaComplexTreeNode, Table, TableModel, Column, Row, IconEditor, CommandButton, CommandGroup, CommandButtonGroup, AddCommand, MoveDownCommand, MoveUpCommand, RemoveCommand, RenameCommand, ReverseCommand, CompositeCommand, template) {
  'use strict';

  var lex = lexs[0],
    makeRow = AddCommand.$makeTableRow,
    logError = log.severe.bind(log),
    IN = 0,
    OUT = 1,
    DELETE_KEY = 46,
    ENTER_KEY = 13,
    HEADER_TITLE = lex.get("compositeEditor.title"),
    HEADER_SUBTITLE = lex.get("compositeEditor.subtitle"),
    HEADER_ICON = "/module/icons/x32/composite.png",
    IN_TEXT = lex.getSafe("compositeEditor.in"),
    OUT_TEXT = lex.getSafe("compositeEditor.out"),
    IN_ICON = baja.Icon.make('module://icons/x16/arrowLeft.png'),
    OUT_ICON = baja.Icon.make('module://icons/x16/arrowRight.png'),
    TEMPLATE_CONTEXT = {
      title: HEADER_TITLE,
      subtitle: HEADER_SUBTITLE,
      icon: HEADER_ICON
    },
    //classes/selectors
    ADD_CMD_SELECTOR = '.add-command',
    TREE_SELECTOR = '.composite-tree',
    TABLE_SELECTOR = '.composite-table',
    CMD_GROUP_SELECTOR = '.table-command-group',
    SPLIT_PANE_SELECTOR = '.split-pane',
    DIR_COL_CLASS = 'directionColumn',
    DIR_COL_SELECTOR = ".".concat(DIR_COL_CLASS),
    SLOT_ICON_CLASS = 'slotIcon',
    SLOT_DIRECTION_CLASS = 'slotDirection',
    //table columns
    DIRECTION_COLUMN = new Column(lex.get("compositeEditor.dir")),
    SLOT_COLUMN = new Column(lex.get("compositeEditor.slot")),
    ORD_COLUMN = new Column(lex.get("compositeEditor.ord"));

  /////////////////////////////////////////////////////////////////
  //Commands
  ///////////////////////////////////////////////////////////////////////
  function initCommands(editor) {
    return Promise.all([initAddCommand(editor), initTableCommands(editor)]);
  }
  function initAddCommand(editor) {
    return fe.buildFor({
      dom: editor.jq().find(ADD_CMD_SELECTOR),
      type: CommandButton,
      value: new AddCommand(editor),
      formFactor: 'mini'
    });
  }
  function initTableCommands(editor) {
    return fe.buildFor({
      dom: editor.jq().find(CMD_GROUP_SELECTOR),
      type: CommandButtonGroup,
      value: initTableCommandGroup(editor),
      properties: {
        toolbar: true
      },
      formFactor: 'mini'
    });
  }
  function initTableCommandGroup(editor) {
    var getTable = function getTable() {
      return editor.$getTable();
    };
    var validateUniqueName = function validateUniqueName(name) {
      var composite = editor.value();
      var slots = composite.getSlots().toArray();
      var isAlreadySlot = slots.filter(function (slot) {
        return slot.getName() === name;
      }).length > 0;
      return !isAlreadySlot;
    };
    var module = 'workbench';
    return new CommandGroup({
      commands: [new ReverseCommand(editor), new RenameCommand(getTable, {
        validateUniqueName: validateUniqueName,
        module: module,
        lex: 'compositeEditor.rename'
      }), new RemoveCommand(getTable, {
        module: module,
        lex: 'compositeEditor.remove'
      }), new MoveUpCommand(getTable, {
        module: module,
        lex: 'compositeEditor.moveUp'
      }), new MoveDownCommand(getTable, {
        module: module,
        lex: 'compositeEditor.moveDown'
      })]
    });
  }

  //////////////////////////////////////////////////////////////////////
  //Tree
  ///////////////////////////////////////////////////////////////////////
  function initTree(editor) {
    return fe.makeFor({
      //only initialize but don't load the tree
      type: NavTree,
      value: new TreeNode(''),
      formFactor: 'mini'
    }).then(function (tree) {
      return tree.initialize(editor.$getTreeDom()).then(function () {
        return tree;
      });
    }).then(function (tree) {
      return armTreeEvents(tree, editor);
    });
  }
  function armTreeEvents(tree, editor) {
    var ACTIVATED_EVENT = NavTree.ACTIVATED_EVENT,
      SELECTED_EVENT = NavTree.SELECTED_EVENT,
      DESELECTED_EVENT = NavTree.DESELECTED_EVENT;
    tree.jq().on(ACTIVATED_EVENT, function () {
      //invoke Add command on double click
      var addCmd = editor.$getAddCommand();
      if (addCmd.isEnabled()) {
        addCmd.invoke()["catch"](logError);
      }
    }).on("".concat(SELECTED_EVENT, " ").concat(DESELECTED_EVENT), function () {
      //Enable/Disable the Add command on selection/deselection
      var addCmd = editor.$getAddCommand(),
        selectedNodes = editor.$getTree().getSelectedNodes(),
        addCmdEnabled = _(selectedNodes).every(treeNodeValid);
      addCmd.setEnabled(addCmdEnabled);
    }).on('selectstart', function () {
      return false;
    }); //disable highlighting in IE
  }
  function treeNodeValid(node) {
    var value = node && node.value();
    if (!value) {
      //the node may be a simple, action or topic
      var parent = node.getParent(),
        _value = parent && parent.value();
      return _value && _.isFunction(_value.getSlotPath); //node is valid if parent is defined
    } else {
      //consider the node valid only if it's not a Component
      return !value.getType().isComponent();
    }
  }
  function loadTree(editor, component) {
    var root = new BajaComplexTreeNode(component),
      tree = editor.$getTree();
    function removableKids(kid) {
      var value = kid.value();
      return !baja.hasType(value, 'baja:Component');
    }
    return root.getKids().then(function (kids) {
      return Promise.all(kids.filter(removableKids).map(function (kid) {
        return root.remove(kid);
      }));
    }).then(function () {
      return tree.load(root);
    });
  }

  ///////////////////////////////////////////////////////////////////////
  //Table
  ///////////////////////////////////////////////////////////////////////

  function initTable(editor) {
    configureColumnOverrides(editor);
    return fe.buildFor({
      dom: editor.jq().find(TABLE_SELECTOR),
      type: Table,
      value: new TableModel({
        columns: [DIRECTION_COLUMN, SLOT_COLUMN, ORD_COLUMN]
      }),
      formFactor: 'mini',
      initializeParams: {
        finishBuildingRow: updateRowClass
      }
    }).then(function (table) {
      return armTableEvents(table, editor);
    });
  }
  function configureColumnOverrides(editor) {
    //Direction column
    DIRECTION_COLUMN.buildCell = function (row, dom) {
      var slot = row.getSubject(),
        icon = slot.dir === IN ? IN_ICON : OUT_ICON,
        dir = slot.dir === IN ? IN_TEXT : OUT_TEXT;
      dom.addClass(DIR_COL_CLASS);
      return fe.buildFor({
        dom: $("<span/>").appendTo(dom).addClass(SLOT_ICON_CLASS),
        type: IconEditor,
        value: icon
      }).then(function () {
        return dom.append($("<span>".concat(dir, "</span>")).addClass(SLOT_DIRECTION_CLASS));
      });
    };

    //Slot column
    SLOT_COLUMN.getValueFor = function (row) {
      return row.getSubject().name;
    };

    //Ord column
    ORD_COLUMN.getValueFor = function (row) {
      var composite = editor.value(),
        subject = row.getSubject(),
        slotPathPrefix = composite.getSlotPath().toString(),
        slotPath = "".concat(subject.ord, "/").concat(subject.slot);
      return slotPath.substring(slotPathPrefix.length + 1);
    };
  }
  function updateRowClass(row, dom) {
    var type = row.getSubject().type,
      isAction = type && type.isAction && type.isAction(),
      isTopic = type && type.isTopic && type.isTopic();

    //add the corresponding color class to the dom row
    return dom.removeClass('propertyRow actionRow topicRow').addClass(isAction ? 'actionRow' : isTopic ? 'topicRow' : 'propertyRow');
  }
  function armTableEvents(table, editor) {
    var cmds = editor.$getTableCommandGroup().getChildren(),
      _cmds = _slicedToArray(cmds, 3),
      reverseCmd = _cmds[0],
      renameCmd = _cmds[1],
      removeCmd = _cmds[2];

    //TableController events
    table.jq().keyup(function (event) {
      if (event.which === DELETE_KEY && removeCmd.isEnabled()) {
        removeCmd.invoke();
      }
      if (event.which === ENTER_KEY && renameCmd.isEnabled()) {
        renameCmd.invoke();
        return false;
      }
    }).on('dblclick', 'tr', function () {
      if (renameCmd.isEnabled()) {
        renameCmd.invoke();
      }
    }).on('dblclick', DIR_COL_SELECTOR, function (event) {
      if (reverseCmd.isEnabled()) {
        reverseCmd.invoke();
      }
      event.stopPropagation(); //prevent 'tr' dblclick handler from handling this event
    }).on('selectstart', function () {
      return false;
    }); //disable highlighting in IE

    //TableSelection events
    var model = table.value(),
      selection = table.$getSelection();
    selection.on('changed', function () {
      _(cmds).each(function (cmd) {
        cmd.setEnabled(!selection.isEmpty());
      });

      //disable the Reverse command if the table selection includes rows with a
      //readonly slot or if both directions are represented
      if (!selection.isEmpty()) {
        var rows = model.getRows(),
          selectedRows = selection.getSelectedElements(rows),
          enabled = reverseCmd.isEnabled();
        for (var i = 0; i < selectedRows.length; i++) {
          var slot = selectedRows[i].getSubject();
          if (slot.readonly) {
            enabled = false;
            break;
          }
          for (var j = 0; j < rows.length; j++) {
            var temp = rows[j].getSubject();
            if (temp.ord + temp.slot === slot.ord + slot.slot && temp.name !== slot.name) {
              enabled = false;
              break;
            }
          }
        }
        reverseCmd.setEnabled(enabled);
      }
    });
    table.getModel().on('rowsRemoved', function (removedRows) {
      editor.$removed = editor.$removed || [];
      removedRows.forEach(function (row) {
        var slot = row.getSubject();
        if (slot.backup) {
          editor.$removed.push(_.clone(slot.backup));
        }
      });
    });
  }
  function loadTable(editor, composite) {
    var model = editor.$getTable().value();
    return Promise.all([getLinkRows(model, composite), getKnobRows(model, composite)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        linkRows = _ref2[0],
        knobRows = _ref2[1];
      return model.insertRows(linkRows.concat(knobRows));
    }).then(function () {
      return sortRows(composite, model);
    });
  }

  /**
   * Returns the list of rows corresponding to the composite's links
   * @private
   * @param model TableModel
   * @param composite
   * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Row>} The array of link rows
   */
  function getLinkRows(model, composite) {
    var links = composite.getLinks(); //get incoming links from child components

    return Promise.all(links.map(function (link) {
      return link.getSourceOrd().resolve({
        base: composite,
        lease: true
      }).then(function (ordTarget) {
        // Filter to only display links that have the COMPOSITE flag
        if ((link.getParent().getFlags(link.getPropertyInParent()) & baja.Flags.COMPOSITE) !== baja.Flags.COMPOSITE) {
          return null;
        }
        var src = ordTarget.getComponent(),
          srcSlotPath = src.getSlotPath().toString(),
          compositeSlotPath = composite.getSlotPath().toString();

        //process only if the composite is on the source's slot path (implying the source is a descendant)
        if (srcSlotPath.indexOf(compositeSlotPath) === 0 && srcSlotPath !== compositeSlotPath) {
          var srcSlotName = link.getSourceSlotName(),
            srcSlot = src.getSlot(srcSlotName),
            srcFlags = src.getFlags(srcSlot),
            //TODO: bug here
            srcSlotReadonly = srcSlot.isTopic() || (srcFlags & baja.Flags.READONLY) === baja.Flags.READONLY,
            targetSlotName = link.getTargetSlotName(),
            targetSlot = composite.getSlot(targetSlotName);
          if (!targetSlot) {
            return composite.remove(link.getName())["return"](null);
          } else {
            return makeRow({
              dir: OUT,
              //Outgoing link from the perspective of the sub-component
              name: targetSlotName,
              ord: srcSlotPath,
              slot: srcSlotName,
              type: composite.get(targetSlot).getType(),
              readonly: srcSlotReadonly,
              backup: true,
              flags: composite.getFlags(targetSlot)
            });
          }
        } else {
          return null;
        }
      });
    })).then(_.compact);
  }

  /**
   * Returns the list of rows corresponding to the composite's knobs
   * @private
   * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} model
   * @param {baja.Component} composite
   * @returns {Promise.<Array.<module:nmodule/webEditors/rc/wb/table/model/Row>>} The array of knob rows
   */
  function getKnobRows(model, composite) {
    var knobs = composite.getKnobs();
    return Promise.all(knobs.map(function (knob) {
      return knob.getTargetOrd().resolve({
        base: composite,
        lease: true
      }).then(function (ordTarget) {
        var target = ordTarget.getComponent();
        var targetSlotPath = target.getSlotPath().toString(),
          compositeSlotPath = composite.getSlotPath().toString();
        if (targetSlotPath.indexOf(compositeSlotPath) === 0 && targetSlotPath !== compositeSlotPath) {
          var sourceSlotName = knob.getSourceSlotName(),
            targetSlotName = knob.getTargetSlotName(),
            sourceSlot = composite.getSlot(sourceSlotName);

          // Filter to only display a knob whose corresponding link has the COMPOSITE flag
          return Promise.all(target.getLinks(targetSlotName).map(function (linkToTargetSlot) {
            return linkToTargetSlot.getSourceOrd().get({
              base: composite
            }).then(function (srcTargetComponent) {
              if (knob.getSourceComponent() === srcTargetComponent && knob.getSourceSlotName().equals(linkToTargetSlot.getSourceSlotName()) && (linkToTargetSlot.getParent().getFlags(linkToTargetSlot.getPropertyInParent()) & baja.Flags.COMPOSITE) === baja.Flags.COMPOSITE) {
                return linkToTargetSlot;
              }
              return null;
            });
          })).then(function (relations) {
            if (relations.find(function (relation) {
              return relation !== null;
            })) {
              if (!sourceSlot) {
                //delete the corresponding links on the target
                return Promise.all(target.getLinks(targetSlotName).map(function (link) {
                  return target.remove(link.getName());
                })).then(function () {
                  return null;
                });
              } else {
                return makeRow({
                  dir: IN,
                  //Incoming link from the perspective of the sub-component
                  name: sourceSlotName,
                  ord: targetSlotPath,
                  slot: targetSlotName,
                  type: composite.get(sourceSlot).getType(),
                  readonly: false,
                  backup: true,
                  flags: composite.getFlags(sourceSlot)
                });
              }
            }
          });
        } else {
          return null;
        }
      });
    })).then(_.compact);
  }

  /**
   * Sort the loaded slots so that they appear in the correct order
   * @param composite
   * @param model
   */
  function sortRows(composite, model) {
    var names = _(composite.getSlots().toArray()).map(function (slot) {
      return slot.getName();
    });
    model.sort(function (r1, r2) {
      return _.indexOf(names, r1.getSubject().name) - _.indexOf(names, r2.getSubject().name);
    });
  }

  /**
   * CompositeEditor
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/wb/composite/CompositeEditor
   */
  var CompositeEditor = /*#__PURE__*/function (_BaseEditor) {
    function CompositeEditor() {
      var _this;
      _classCallCheck(this, CompositeEditor);
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      _this = _callSuper(this, CompositeEditor, [].concat(args));
      _this.$compositeCmd = new CompositeCommand(_this);
      return _this;
    }

    /**
     * Returns a reference to the NavTree DOM in the editor
     * @private
     * @returns {JQuery} DOM representing NavTree
     */
    _inherits(CompositeEditor, _BaseEditor);
    return _createClass(CompositeEditor, [{
      key: "$getTreeDom",
      value: function $getTreeDom() {
        return this.jq().find(TREE_SELECTOR);
      }

      /**
       * Returns a reference to the NavTree for selecting slots to composite
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/tree/NavTree} NavTree editor
       */
    }, {
      key: "$getTree",
      value: function $getTree() {
        return this.$getTreeDom().data('widget');
      }

      /**
       * Returns a reference to the Table for displaying composited slots
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table} Table editor
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.jq().find(TABLE_SELECTOR).data('widget');
      }

      /**
       * Returns a reference to the TableModel for the display Table widget
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel} TableModel
       */
    }, {
      key: "$getTableModel",
      value: function $getTableModel() {
        return this.$getTable().value();
      }

      /**
       * Returns a reference to the CommandButton editor for the AddCommand
       * @private
       * @returns {module:bajaux/util/CommandButton} CommandButton
       */
    }, {
      key: "$getAddCommandButton",
      value: function $getAddCommandButton() {
        return this.jq().find(ADD_CMD_SELECTOR).data('widget');
      }

      /**
       * Returns a reference to the AddCommand for adding selected slots from the tree to the table
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/composite/commands/AddCommand} AddCommand
       */
    }, {
      key: "$getAddCommand",
      value: function $getAddCommand() {
        return this.$getAddCommandButton().value();
      }

      /**
       * Returns a reference to the CommandButtonGroup editor for the table commands
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup} CommandButtonGroup
       */
    }, {
      key: "$getTableCommandButtonGroup",
      value: function $getTableCommandButtonGroup() {
        // noinspection JSValidateTypes
        return Widget["in"](this.jq().find(CMD_GROUP_SELECTOR));
      }

      /**
       * Returns a reference to the CommandGroup for the table commands
       * @private
       * @returns {module:bajaux/commands/CommandGroup} CommandGroup
       */
    }, {
      key: "$getTableCommandGroup",
      value: function $getTableCommandGroup() {
        return this.$getTableCommandButtonGroup().value();
      }

      /**
       * Returns a reference to the CompositeCommand for compositing slots
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/composite/commands/CompositeCommand} CompositeCommand
       */
    }, {
      key: "$getCompositeCommand",
      value: function $getCompositeCommand() {
        return this.$compositeCmd;
      }

      /**
       * Initializes the CompositeEditor elements in a split pane
       * @param {JQuery} dom
       * @returns {Promise} Promise resolved when editor elements have been initialized
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        //initialize template and split pane
        dom.addClass("CompositeEditor").html(template(TEMPLATE_CONTEXT)).find(SPLIT_PANE_SELECTOR).splitPane();

        //init commands, tree, and table
        return Promise.all([initCommands(this), initTree(this), initTable(this)]);
      }

      /**
       * Loads the component to composite into the editor
       * @param {baja.Component} component to composite
       * @returns {Promise} Promise resolved when component has been loaded
       */
    }, {
      key: "doLoad",
      value: function doLoad(component) {
        return Promise.all([loadTree(this, component), loadTable(this, component)]);
      }

      /**
       * Saves the composited slots
       * @param value
       * @param params
       * @returns {Promise} Promise resolved when composite has been saved
       */
    }, {
      key: "doSave",
      value: function doSave(value, params) {
        return this.$compositeCmd.invoke(params);
      }

      /**
       * Destroys child editors
       * @returns {Promise} Promise resolved when editor has been destroyed
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        return this.getChildWidgets().destroyAll();
      }
    }]);
  }(BaseEditor);
  return CompositeEditor;
});
