function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/SetDisplayNameCommand
 */
define(['baja!', 'lex!webEditors', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand'], function (baja, lexs, Promise, _, feDialogs, compUtils, ComponentEditorCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var getDisplayName = compUtils.getDisplayName;

  /**
   * A command for setting the display name on a slot on an editor's loaded
   * `Component` value.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/SetDisplayNameCommand
   * @param {baja.Component} component the component on which to set slot
   * display names
   * @throws {Error} if no `Widget` provided
   */
  var SetDisplayNameCommand = function SetDisplayNameCommand(component) {
    var _this = this;
    ComponentEditorCommand.call(this, {
      module: 'webEditors',
      lex: 'commands.setDisplayName',
      undoable: function undoable(params) {
        return _this.$makeUndoable(params);
      }
    }, component);
  };
  SetDisplayNameCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  SetDisplayNameCommand.prototype.constructor = SetDisplayNameCommand;

  /**
   * Make sure we have admin write permissions.
   *
   * @param {baja.Component} comp
   * @returns {Boolean} true if I can set slot display names on this component
   */
  SetDisplayNameCommand.prototype.canPerformCommand = function (comp) {
    return hasAdminWrite(comp);
  };

  //TODO: support search/replace for multiple display names
  /**
   * Set the display names for the given slots.
   *
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots the slots for which to set display names
   * (note: only the first slot will actually get its display name set)
   * @returns {Promise} promise to be resolved after the user as entered
   * a new display name and it has been set on the component slot
   */
  SetDisplayNameCommand.prototype.performCommand = function (comp, slots) {
    return SetDisplayNameCommand.$setupRename(comp, slots).then(function (_ref) {
      var comp = _ref.comp,
        slot = _ref.slot,
        newDisplayName = _ref.displayName;
      if (newDisplayName !== null) {
        return comp.setDisplayName({
          slot: slot,
          newDisplayName: newDisplayName
        });
      }
    });
  };

  /**
   * @private
   * @param {object} params
   * @returns {Promise.<module:bajaux/commands/Command~Undoable>}
   */
  SetDisplayNameCommand.prototype.$makeUndoable = function (params) {
    return this.processParams(params).then(function (_ref2) {
      var comp = _ref2.comp,
        slots = _ref2.slots;
      return SetDisplayNameCommand.$setupRename(comp, slots);
    }).then(function (_ref3) {
      var comp = _ref3.comp,
        slot = _ref3.slot,
        newDisplayName = _ref3.displayName,
        oldDisplayName = _ref3.oldDisplayName;
      if (newDisplayName === null) {
        return;
      }
      return {
        redo: function redo() {
          return comp.setDisplayName({
            slot: slot,
            newDisplayName: newDisplayName
          });
        },
        undo: function undo() {
          return comp.setDisplayName({
            slot: slot,
            newDisplayName: oldDisplayName
          });
        },
        redoText: function redoText() {
          return webEditorsLex.get({
            key: 'commands.setDisplayName.redoText',
            args: [slot, getDisplayName(comp), newDisplayName]
          });
        },
        undoText: function undoText() {
          return webEditorsLex.get({
            key: 'commands.setDisplayName.undoText',
            args: [slot, getDisplayName(comp), oldDisplayName]
          });
        },
        canRedo: function canRedo() {
          return hasAdminWrite(comp) && comp.has(slot);
        },
        canUndo: function canUndo() {
          return hasAdminWrite(comp) && comp.has(slot);
        }
      };
    });
  };

  /**
   * @private
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots
   * @returns {Promise.<{ comp: baja.Component, slot: baja.Slot, displayName: string, oldDisplayName: string }>} displayName
   * will be null if user canceled prompt
   */
  SetDisplayNameCommand.$setupRename = function (comp, slots) {
    var _slots = _slicedToArray(slots, 1),
      slot = _slots[0];
    if (!slot) {
      return Promise.reject(new Error('slot to rename required'));
    }
    var oldDisplayName = comp.getDisplayName(slot);
    return SetDisplayNameCommand.$promptForNewDisplayName(oldDisplayName).then(function (displayName) {
      if (displayName === oldDisplayName) {
        displayName = null;
      }
      return {
        comp: comp,
        slot: slot,
        displayName: displayName,
        oldDisplayName: oldDisplayName
      };
    });
  };

  /**
   * @private
   * @param {string} oldDisplayName
   * @returns {Promise.<string|null>}
   */
  SetDisplayNameCommand.$promptForNewDisplayName = function (oldDisplayName) {
    return feDialogs.showFor({
      title: webEditorsLex.get('commands.setDisplayName.description'),
      value: oldDisplayName,
      formFactor: 'mini'
    });
  };
  function hasAdminWrite(comp) {
    return comp.getPermissions().hasAdminWrite();
  }
  return SetDisplayNameCommand;
});
