function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/RenameCommand
 */
define(['baja!', 'lex!webEditors', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand'], function (baja, lexs, Promise, feDialogs, compUtils, ComponentEditorCommand) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];
  var getDisplayName = compUtils.getDisplayName;

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A command for renaming slots on an editor's `Component` value.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/RenameCommand
   * @param {baja.Component} component the component on which to rename slots
   * @throws {Error} if no `Widget` provided
   */
  var RenameCommand = function RenameCommand(component) {
    var that = this;
    ComponentEditorCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.rename'
    }, component);
  };
  RenameCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  RenameCommand.prototype.constructor = RenameCommand;

  /**
   * Make sure we have admin write permissions and we're not renaming a
   * frozen slot.
   *
   * @param {baja.Component} comp
   * @param {baja.Slot} slot
   * @returns {Boolean} true if I can rename this slot
   */
  RenameCommand.prototype.canPerformCommand = function (comp, slot) {
    return isRenamable(comp, slot);
  };

  //TODO: support find/replace to renames
  /**
   * Shows a dialog for the component's currently configured slot name,
   * and renames the slot after the user clicks OK.
   *
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots the slots to rename (*Note*: only the
   * first given slot will be renamed)
   * @returns {Promise}
   */
  RenameCommand.prototype.performCommand = function (comp, slots) {
    var _this = this;
    return getSlotToRename(slots).then(function (slot) {
      var oldName = slot.getName();
      return _this.$promptForNewName(oldName).then(validateNewName).then(function (newName) {
        return _this.$doRename(comp, oldName, newName);
      });
    })["catch"](feDialogs.error);
  };
  RenameCommand.prototype.undoable = function (params) {
    var _this2 = this;
    return this.$setupRename(params).then(function (_ref) {
      var comp = _ref.comp,
        oldName = _ref.oldName,
        newName = _ref.newName;
      if (!newName || newName === oldName) {
        return;
      }
      return {
        redo: function redo() {
          return _this2.$doRename(comp, oldName, newName);
        },
        undo: function undo() {
          return _this2.$doRename(comp, newName, oldName);
        },
        canRedo: function canRedo() {
          return isRenamable(comp, oldName);
        },
        canUndo: function canUndo() {
          return isRenamable(comp, newName);
        },
        redoText: function redoText() {
          return webEditorsLex.get({
            key: 'commands.rename.redoText',
            args: [oldName, getDisplayName(comp), newName]
          });
        },
        undoText: function undoText() {
          return webEditorsLex.get({
            key: 'commands.rename.undoText',
            args: [newName, getDisplayName(comp), oldName]
          });
        }
      };
    });
  };

  /**
   * @private
   * @param {object} params params passed to invoke() or undoable()
   * @returns {Promise.<{ comp: baja.Component, oldName: string, newName: string }>}
   */
  RenameCommand.prototype.$setupRename = function (params) {
    var _this3 = this;
    return this.processParams(params).then(function (_ref2) {
      var comp = _ref2.comp,
        slots = _ref2.slots;
      return getSlotToRename(slots).then(function (slot) {
        var oldName = slot.getName();
        return _this3.$promptForNewName(oldName).then(validateNewName).then(function (newName) {
          return {
            comp: comp,
            oldName: oldName,
            newName: newName
          };
        })["catch"](function (err) {
          feDialogs.error(err);
          return {};
        });
      });
    });
  };

  /**
   * @private
   * @param {baja.Component }comp
   * @param {string} oldName
   * @param {string} newName
   * @returns {Promise}
   */
  RenameCommand.prototype.$doRename = function (comp, oldName, newName) {
    if (newName && newName !== oldName) {
      return comp.rename({
        slot: oldName,
        newName: newName
      });
    } else {
      return Promise.resolve();
    }
  };

  /**
   * @private
   * @returns {Promise.<string|null>}
   */
  RenameCommand.prototype.$promptForNewName = function (oldName) {
    return feDialogs.showFor({
      title: webEditorsLex.get('commands.rename.description'),
      value: baja.SlotPath.unescape(oldName),
      formFactor: 'mini'
    });
  };
  function validateNewName(newName) {
    if (newName === null) {
      return null;
    }
    if (newName.trim() === '') {
      throw new Error(webEditorsLex.get('enterName'));
    }
    return baja.SlotPath.escape(newName.trim());
  }
  function getSlotToRename(slots) {
    var slot = slots[0];
    if (!slot) {
      return Promise.reject(new Error('slot to rename required'));
    } else {
      return Promise.resolve(slot);
    }
  }
  function isRenamable(comp, slot) {
    slot = comp && slot && comp.getSlot(slot);
    return !!(slot && comp.getPermissions().hasAdminWrite() && !slot.isFrozen());
  }
  return RenameCommand;
});
