/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LinkToCommand
 */
define(['underscore', 'nmodule/webEditors/rc/wb/commands/LinkCommand'], function (_, LinkCommand) {
  'use strict';

  var extend = _.extend;

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/wb/commands/LinkCommand
   * @alias module:nmodule/webEditors/rc/wb/commands/LinkToCommand
   * @param {object} params
   * @param {baja.Component} params.subject - the link target component
   */
  var LinkToCommand = function LinkToCommand(params) {
    LinkCommand.call(this, extend({
      direction: 'to',
      lex: 'commands.linkTo'
    }, params));
  };
  LinkToCommand.prototype = Object.create(LinkCommand.prototype);
  LinkToCommand.prototype.constructor = LinkToCommand;

  /**
   * @param {module:nmodule/webEditors/rc/wb/commands/LinkToCommand|*} cmd
   * @returns {module:nmodule/webEditors/rc/wb/commands/LinkToCommand|null}
   */
  LinkToCommand.prototype.merge = function (cmd) {
    if (!(cmd instanceof LinkToCommand)) {
      return null;
    }
    var mySubject = this.$subject || [];
    var hisSubject = cmd.$subject || [];
    return new LinkToCommand({
      subject: mySubject.concat(hisSubject)
    });
  };

  /**
   * Make a LinkToCommand and initialize it.
   *
   * @param {baja.Component|Array.<baja.Component>} subject the link target component(s)
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/commands/LinkToCommand>} promise
   * that resolves to a LinkToCommand after the command has been initialized.
   */
  LinkToCommand.make = function (subject) {
    return new LinkToCommand({
      subject: subject
    }).init();
  };
  return LinkToCommand;
});
