/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/LinkMarkCommand
 */
define(['nmodule/webEditors/rc/wb/util/TransferDataManager', 'bajaux/commands/Command'], function (TransferDataManager, Command) {
  'use strict';

  var transferDataManager = TransferDataManager.getInstance();

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/LinkMarkCommand
   * @param {baja.Component|Array.<baja.Component>} subject the Component(s) to mark for linking
   */
  var LinkMarkCommand = function LinkMarkCommand(subject) {
    var _this = this;
    this.$subject = [].concat(subject);
    Command.call(this, {
      module: 'webEditors',
      lex: 'commands.linkMark',
      func: function func() {
        return transferDataManager.setLinkMark(_this.$subject);
      }
    });
  };
  LinkMarkCommand.prototype = Object.create(Command.prototype);
  LinkMarkCommand.prototype.constructor = LinkMarkCommand;

  /**
   * @param {module:nmodule/webEditors/rc/wb/commands/LinkMarkCommand|*} cmd
   * @returns {module:nmodule/webEditors/rc/wb/commands/LinkMarkCommand|null}
   */
  LinkMarkCommand.prototype.merge = function (cmd) {
    if (!(cmd instanceof LinkMarkCommand)) {
      return null;
    }
    var mySubject = this.$subject || [];
    var hisSubject = cmd.$subject || [];
    return new LinkMarkCommand(mySubject.concat(hisSubject));
  };

  /**
   * Make a LinkMarkCommand and initialize it.
   *
   * @param {baja.Component} component
   * @returns {module:nmodule/webEditors/rc/wb/commands/LinkMarkCommand}
   */
  LinkMarkCommand.make = function (component) {
    return new LinkMarkCommand(component);
  };
  return LinkMarkCommand;
});
