function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/commands/HelpCommand
 */
define(['baja', 'jquery', 'Promise', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, $, Promise, _, events, spandrel, Command, CommandButton, asyncUtils, fe, feDialogs, htmlUtils) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;
  var doRequire = asyncUtils.doRequire;

  /**
   * A command to show some help.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/webEditors/rc/wb/commands/HelpCommand
   * @since Niagara 4.13
   */
  var HelpCommand = /*#__PURE__*/function (_Command) {
    function HelpCommand(_ref) {
      var _this;
      var module = _ref.module,
        lex = _ref.lex,
        title = _ref.title,
        _ref$height = _ref.height,
        height = _ref$height === void 0 ? 400 : _ref$height,
        _ref$width = _ref.width,
        width = _ref$width === void 0 ? 500 : _ref$width;
      _classCallCheck(this, HelpCommand);
      _this = _callSuper(this, HelpCommand, [{
        module: 'webEditors',
        lex: 'commands.help',
        func: function func() {
          return _this.$showHelp();
        }
      }]);
      _this.$module = module;
      _this.$lex = lex;
      _this.$title = title;
      _this.$width = width;
      _this.$height = height;
      return _this;
    }

    /**
     * The module to use for retrieving the localized help content.
     * @returns {String}
     */
    _inherits(HelpCommand, _Command);
    return _createClass(HelpCommand, [{
      key: "getModule",
      value: function getModule() {
        return this.$module;
      }

      /**
       * The lexicon key to use for retrieving the localized help content.
       * @returns {String}
       */
    }, {
      key: "getLex",
      value: function getLex() {
        return this.$lex;
      }

      /**
       * The title String for the help dialog.
       * @returns {String|undefined}
       */
    }, {
      key: "getTitle",
      value: function getTitle() {
        return this.$title;
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showHelp",
      value: function $showHelp() {
        var _this2 = this;
        return doRequire('lex!' + this.$module)["catch"](function () {
          return [];
        }) //module not found
        .then(function (lexs) {
          var _lexs = _slicedToArray(lexs, 1),
            lex = _lexs[0];
          if (lex) {
            var content = lex.get(_this2.$lex);
            if (!content) {
              return;
            }
            content = htmlUtils.limitedHtml(content);
            return feDialogs.showFor({
              type: HelpWidget,
              value: content,
              title: _this2.$title,
              properties: {
                width: _this2.$width,
                height: _this2.$height
              },
              progressCallback: function progressCallback(msg, editor) {
                switch (msg) {
                  case 'initialized':
                    {
                      editor.$dlg.buttonJq('cancel').toggle(false);
                    }
                }
              }
            });
          }
        });
      }

      /**
       * Make a help command button by appending a new CommandButton to the dom element provided.
       * @param {Object} params The object literal containing the method's arguments
       * @param {JQuery} params.dom
       * @param {string} params.module
       * @param {string} params.lex
       * @param {string} [params.title]
       * @param {string} [params.height=400]
       * @param {string} [params.width=500]
       * @returns {Promise.<module:bajaux/util/CommandButton>} a CommandButton with the HelpCommand set as the value.
       */
    }], [{
      key: "makeCommandButton",
      value: function makeCommandButton(params) {
        var dom = params.dom;
        var helpDom = $('<button type="button" class="-t-HelpCommand ux-btn-tb"></button>');
        return fe.buildFor({
          dom: helpDom.appendTo(dom),
          value: new HelpCommand(params),
          type: CommandButton
        });
      }

      /**
       * Mix in a HelpCommand for a Widget. This will handle adding the command to the dom
       * and removing the Command during the Widget's destroy.
       * @param {module:bajaux/Widget} target
       * @param {Object} params The object literal containing the method's arguments
       * @param {string} params.module
       * @param {string} params.lex
       * @param {Function|String} [params.title]
       * @param {string} [params.height=400]
       * @param {string} [params.width=500]
       */
    }, {
      key: "mixin",
      value: function mixin(target, params) {
        var initialize = target.initialize,
          superDestroy = target.destroy;
        target.initialize = function (dom) {
          var _this3 = this;
          dom.on(MODIFY_EVENT, '.-t-HelpCommand', function () {
            _this3.setModified(true);
            return false;
          });
          var module = params.module,
            lex = params.lex,
            title = params.title,
            width = params.width,
            height = params.height;
          title = _.isFunction(title) ? title() : title;
          return Promise.all([title, initialize.apply(target, arguments)]).then(function (_ref2) {
            var _ref3 = _slicedToArray(_ref2, 1),
              title = _ref3[0];
            return HelpCommand.makeCommandButton({
              dom: dom,
              module: module,
              lex: lex,
              title: title,
              width: width,
              height: height
            }).then(function (helpCommandButton) {
              target.$helpCommandButton = helpCommandButton;
            });
          });
        };
        target.destroy = function (params) {
          var helpCommandButton = target.$helpCommandButton;
          delete target.$helpCommandButton;
          return Promise.all([helpCommandButton && helpCommandButton.destroy(), superDestroy.apply(target, arguments)]);
        };
      }
    }]);
  }(Command);
  var HelpWidget = /*#__PURE__*/function (_spandrel) {
    function HelpWidget() {
      _classCallCheck(this, HelpWidget);
      return _callSuper(this, HelpWidget, arguments);
    }
    _inherits(HelpWidget, _spandrel);
    return _createClass(HelpWidget);
  }(spandrel(function (value, _ref4) {
    var properties = _ref4.properties;
    var height = properties.height,
      width = properties.width;
    var dom = document.createElement('div');
    dom.innerHTML = value;
    if (width) {
      dom.style.maxWidth = width + 'px';
    }
    if (height) {
      dom.style.maxHeight = height + 'px';
    }
    return {
      dom: dom
    };
  }, {
    strategy: 'niagara'
  }));
  return HelpCommand;
});
