function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/wb/MultiSheetRow
 */
define(['baja!', 'lex!webEditors', 'log!nmodule.webEditors.rc.wb.MultiSheetRow', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/wb/PropertySheetRow', 'nmodule/webEditors/rc/wb/mixin/PropertySheetRowDragSupport', 'nmodule/webEditors/rc/wb/mixin/PropertySheetRowLinkSupport', 'hbs!nmodule/webEditors/rc/wb/template/MultiSheet-row'], function (baja, lexs, log, $, Promise, fe, IconEditor, slotUtils, PropertySheetRow, addRowDragSupport, addRowLinkSupport, tplMultiSheetRow) {
  'use strict';

  var getTypeDisplay = slotUtils.getTypeDisplay,
    webEditorsLex = lexs[0],
    logError = log.severe.bind(log);

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function canEditSlotDetails(comp) {
    return baja.hasType(comp, 'baja:Component') && comp.getPermissions().hasAdminWrite();
  }

  /**
   * Get the string value to display slot flags.
   *
   * @inner
   * @param {baja.Slot} slot
   * @returns {String}
   */
  function getFlagsDisplay(slot) {
    return slotUtils.getFlagsDisplay(slot) || webEditorsLex.get('MultiSheetRow.flags.empty');
  }

  /**
   * Get the string value to display slot facets.
   *
   * @param {baja.Complex} comp
   * @param {baja.Slot} slot
   * @returns {Promise.<String>}
   */
  function getFacetsDisplay(comp, slot) {
    //empty context to prevent use of native JS toStrings (NCCB-24877)
    return comp.getFacets(slot).toString({}).then(function (str) {
      return str || webEditorsLex.get('MultiSheetRow.facets.empty');
    });
  }

  /**
   * Style the element as being editable.
   *
   * @inner
   * @param {JQuery} elem
   * @param {Boolean} editable
   */
  function setEditable(elem, editable) {
    elem.toggleClass('editable ux-highlight', editable);
  }

  /**
   * Get the title (hover/tooltip) to show for the icon for a particular slot.
   *
   * @inner
   * @param {baja.Slot} slot
   * @returns {String}
   */
  function getSlotTitle(slot) {
    //TODO: lex? theme?
    if (slot.isProperty()) {
      return webEditorsLex.get('property');
    } else if (slot.isAction()) {
      return webEditorsLex.get('action');
    } else {
      return webEditorsLex.get('topic');
    }
  }

  /**
   * Build the icon display editor for the given slot.
   *
   * @inner
   * @param {JQuery} dom
   * @param {baja.Slot} [slot] the complex slot represented by this row
   * @returns {Promise}
   */
  function buildSlotIconEditor(dom, slot) {
    if (!slot) {
      return Promise.resolve();
    }
    var old = dom.data('widget');
    return Promise.resolve(old && old.destroy()).then(function () {
      return fe.buildFor({
        dom: dom.attr('title', getSlotTitle(slot)),
        value: slot,
        type: IconEditor
      });
    });
  }

  ////////////////////////////////////////////////////////////////
  // MultiSheetRow definition
  ////////////////////////////////////////////////////////////////

  /**
   * An editor for displaying/editing one row in a `MultiSheet`.
   *
   * Extends `PropertySheetRow` with columns for slot-sheet functions like
   * slot flags and facets. These should be hidden in CSS (and will be by the
   * standard webEditors structure CSS) when the row is not in slot mode.
   *
   * This editor will only make sense if loaded into a `<tr>` element.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/PropertySheetRow
   * @alias module:nmodule/webEditors/rc/wb/MultiSheetRow
   */
  var MultiSheetRow = function MultiSheetRow(params) {
    var that = this;
    PropertySheetRow.call(that, $.extend(true, {
      properties: {
        showActionsAndTopics: false,
        showHiddenSlots: false,
        slotMode: false
      }
    }, params || {}));
    addRowDragSupport(this);
    addRowLinkSupport(this);
  };
  MultiSheetRow.prototype = Object.create(PropertySheetRow.prototype);
  MultiSheetRow.prototype.constructor = MultiSheetRow;

  ////////////////////////////////////////////////////////////////
  // Private setters and getters
  ////////////////////////////////////////////////////////////////

  /**
   * Performs the initial HTML templating.
   *
   * @private
   * @param {Object} obj
   * @returns {String}
   */
  MultiSheetRow.prototype.$template = function (obj) {
    return tplMultiSheetRow(obj);
  };

  /**
   * Returns the element containing the row's icon to display the type of the
   * slot (action.png for an Action. etc).
   *
   * @private
   * @returns {jQuery}
   */
  MultiSheetRow.prototype.$getSlotTypeIconElement = function () {
    return this.$getColumn('display').find('.slotTypeIcon');
  };

  /**
   * Returns the element containing the row's slot name (for slot mode).
   *
   * @private
   * @returns {jQuery}
   */
  MultiSheetRow.prototype.$getNameElement = function () {
    return this.$getColumn('name').children('span');
  };

  /**
   * Returns the element containing the slot's flags (for slot mode).
   *
   * @private
   * @returns {jQuery}
   */
  MultiSheetRow.prototype.$getFlagsElement = function () {
    return this.$getColumn('flags').children('span');
  };

  /**
   * Returns the element containing the slot's facets (for slot mode).
   *
   * @private
   * @returns {jQuery}
   */
  MultiSheetRow.prototype.$getFacetsElement = function () {
    return this.$getColumn('facets').children('span');
  };

  /**
   * Returns the element displaying the slot's type spec (for slot mode).
   *
   * @private
   * @returns {*}
   */
  MultiSheetRow.prototype.$getTypeElement = function () {
    return this.$getColumn('type').children('span');
  };

  /**
   * Ensure expanded rows are loaded as type MultiSheet by default.
   *
   * @private
   * @returns {String}
   */
  MultiSheetRow.prototype.$getDefaultSheetType = function () {
    return 'nmodule/webEditors/rc/wb/MultiSheet';
  };

  /**
   * Add extra handlers to the parent component to keep the slot mode text
   * up to date.
   */
  MultiSheetRow.prototype.$attachParent = function () {
    var that = this,
      att = PropertySheetRow.prototype.$attachParent.apply(that, arguments);
    if (att) {
      var complex = that.getComplex(),
        slot = complex.getSlot(that.getSlot());
      att.attach({
        'added changed removed': function added_changed_removed(prop) {
          if (prop.getName() === 'displayNames' && prop.getType().is('baja:NameMap')) {
            that.$getDisplayNameElement().text(this.getDisplayName(slot));
          }
        },
        'flagsChanged': function flagsChanged(prop) {
          if (prop === slot) {
            that.$getFlagsElement().text(getFlagsDisplay(prop));
          }
        },
        'renamed': function renamed(prop) {
          if (prop === slot) {
            that.$getDisplayNameElement().text(this.getDisplayName(slot));
            that.$getNameElement().text(slot.getName());
          }
        },
        'facetsChanged': function facetsChanged(prop) {
          if (prop === slot) {
            getFacetsDisplay(complex, slot).then(function (str) {
              that.$getFacetsElement().text(str);
            })["catch"](logError);
          }
        }
      });
    }
  };

  ////////////////////////////////////////////////////////////////
  // MultiSheetRow bajaux implementation
  ////////////////////////////////////////////////////////////////

  /*
   TODO: there is a nicer way of handling the editable cells in the table.
   they should simply be bound to the underlying commands. if the
   SetDisplayNameCommand is enabled, mark that cell as editable. that way
   i can just delegate that logic to the commands rather than duplicating it
   here.
   */

  /**
   * Builds and loads a sub-field editor for the given value. If a
   * `displayWidget` parameter was given, the editor will be of the requested
   * type. If the value is a mounted component, a live, subscribable
   * display-only editor will be loaded. Otherwise, the default mini editor
   * for that type will be loaded.
   *
   * If the type being loaded has a compact editor registered, the 'pop-out'
   * button will be shown.
   *
   * Subsequent calls to `load()` will not destroy and recreate the value
   * editor, but just load in the new value. Calling `load()` a second time
   * with a value of a different Type than the first will likely cause
   * unexpected/erroneous behavior. (Since the only way to change a Slot's Type
   * is to destroy and recreate the slot, this should not be a problem in
   * practice.)
   *
   * @param {baja.Value} value
   * @returns {Promise} promise to be resolved after the existing editor
   * (if any) is destroyed, the new editor is loaded, and the pop-out button is
   * hidden or shown
   */
  MultiSheetRow.prototype.doLoad = function (value) {
    var that = this,
      complex = that.getComplex(),
      slot = that.getSlot(),
      isDynamic = slot && !slot.isFrozen(),
      editable = canEditSlotDetails(complex),
      displayNameElement = that.$getDisplayNameElement(),
      nameElement = that.$getNameElement(),
      flagsElement = that.$getFlagsElement(),
      typeElement = that.$getTypeElement(),
      facetsElement = that.$getFacetsElement();
    return Promise.all([getFacetsDisplay(complex, slot), PropertySheetRow.prototype.doLoad.apply(this, arguments)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        facetsDisplay = _ref2[0];
      if (!slot) {
        return;
      }
      setEditable(displayNameElement, editable);
      setEditable(flagsElement, editable);
      setEditable(nameElement, editable && isDynamic);
      setEditable(facetsElement, editable && isDynamic);
      nameElement.text(slot.getName());
      flagsElement.text(getFlagsDisplay(slot));
      typeElement.text(getTypeDisplay(slot));
      facetsElement.text(facetsDisplay);
      return buildSlotIconEditor(that.$getSlotTypeIconElement(), slot);
    });
  };

  /**
   * Propagate changes to the `showActionsAndTopics` and `showHiddenSlots`
   * Properties down to expanded MultiSheets.
   *
   * @returns {Promise}
   */
  MultiSheetRow.prototype.doChanged = function (name, value) {
    var subSheet = this.$getSubPropertySheet();
    if (subSheet) {
      switch (name) {
        case 'showActionsAndTopics':
          return subSheet.setShowActionsAndTopics(value);
        case 'showHiddenSlots':
          return subSheet.setShowHiddenSlots(value);
      }
    }
  };
  MultiSheetRow.prototype.doDestroy = function () {
    var iconEditor = this.$getSlotTypeIconElement().data('widget');
    return Promise.all([iconEditor && iconEditor.destroy(), PropertySheetRow.prototype.doDestroy.apply(this, arguments)]);
  };
  return MultiSheetRow;
});
