function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

define(['lex!webEditors'], function (lexs) {
  'use strict';

  /**
   * @API Status: **Private**
   *
   * @since Niagara 4.8
   * @exports nmodule/webEditors/rc/util/byteUtils
   */
  var byteUtils = {},
    _lexs = _slicedToArray(lexs, 1),
    webEditorsLex = _lexs[0];

  /**
   * Function is used to append zeros to the string if it does not contain two values.
   *
   * @param {String} stringFromId - string value
   * @param {number} displayLength - the number of values required in the string ,
   * as per the radix value
   * @param {String} stringBytes - string containing byte values
   * @returns {String} string with zeros
   */
  function getStringOfZeros(stringFromId, displayLength) {
    var paddedValue = stringFromId;
    for (var n = stringFromId.length; n < displayLength; ++n) {
      paddedValue = "0".concat(paddedValue);
    }
    return paddedValue;
  }

  /**
   * Function is used to add zeros at the end of the byte array if it does not contain
   * the required number of elements
   *
   * @param {Array.<number>} idByteArray - byte array containing domain id
   * @param {number} len- length of the domain id allowed
   */
  function addTrailingZeros(idByteArray, len) {
    for (var i = idByteArray.length; i < len; i++) {
      idByteArray[i] = 0;
    }
    return idByteArray;
  }

  /**
   * Function is used to convert byte array to string.
   *
   * @example
   * //creates a string converting all the values to hex equivalent.
   * byteArrayToString([0x32,0x10,0xa,0x0,0x1,0x4],6)
   * //creates a string "20.0a.0a.00.01.7f"
   *
   * @example
   * //creates a string converting all the values to hex equivalent when length
   * of id provided is lesser than the expected len
   * byteArrayToString([ 100, 20 ],3) //creates a string "64.14"
   *
   *
   * @param {Array.<number>} byteArray - byte array containing the id .It holds hex values
   * @param {string} delimiter - delimiter character like [, . ; :]
   * @param {number} len - acceptable length of the domain id like 0,1,3,6 etc
   * @param radix
   * @returns {string} byte array string including the delimiter
   */
  byteUtils.byteArrayToString = function (byteArray, delimiter, len, radix) {
    var stringBytes = ""; //holds the byte array as string with delimiter
    var displayLength = 0x00ff.toString(radix.valueOf()).length; // gets a value 2
    //limiting the domain id length to the acceptable value of len
    if (len > byteArray.length) {
      len = byteArray.length;
    }

    //return an empty string if len is given as 0
    if (len === 0) {
      return "";
    }
    for (var i = 0; i < len; i++) {
      // Add delimiter before all bytes except first.
      if (i > 0) {
        stringBytes = stringBytes + delimiter;
      }
      // Convert byte to string with hex conversion
      var stringFromId = (byteArray[i] & 0x00ff).toString(radix.valueOf());
      var paddedValue = getStringOfZeros(stringFromId, displayLength);
      stringBytes = stringBytes.concat(paddedValue);
    }
    return stringBytes.toString();
  };

  /**
   * Function is used to convert hexString to byte array.
   * String can be delimited with space : , . ; / \
   *
   * @param {String} hexString - hexString containing the values to be made into a
   * byte array .It holds hex values.
   * @param {Number} len - acceptable length of the domain id like 0,1,3,6 etc
   * @param {Object} params
   * @param {RegExp} params.delimiter - delimiter used to separate the hexString
   * @param {Number} params.radix - radix used for number conversion
   * @returns {Array.<Number>|null} byte array
   * @throws {Error} If the input hexString has an invalid hexadecimal in it.
   */
  byteUtils.stringToByteArray = function (hexString, len) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      _ref$delimiter = _ref.delimiter,
      delimiter = _ref$delimiter === void 0 ? /[:,. ;/\\]/ : _ref$delimiter,
      _ref$radix = _ref.radix,
      radix = _ref$radix === void 0 ? 16 : _ref$radix;
    if (len === 0) {
      return [];
    }
    var delimiterMatch = hexString.match(delimiter),
      delimiterSource = delimiter instanceof RegExp ? delimiter.source : delimiter,
      handleDuplicates = function handleDuplicates() {
        var replaceDuplicateDelimiters = new RegExp("".concat(delimiterSource).concat(delimiterSource, "+"), 'g'),
          replaceLeading = new RegExp('^' + delimiterSource + '+'),
          replaceTrailing = new RegExp(delimiterSource + '+$');

        // Replace trailing and leading delimiters with blank and replace duplicate delimiters.
        hexString = hexString.replace(replaceLeading, "").replace(replaceTrailing, "").replace(replaceDuplicateDelimiters, delimiterMatch);
      };
    if (delimiterMatch) {
      handleDuplicates();
    }

    // If input hexString is of odd length, make it even by prepending 0.
    if ((hexString.length & 0x01) > 0) {
      hexString = "0" + hexString;
    }
    var hexArray = hexString.split(delimiter);
    var tokenCount = hexArray.length;

    // Handle special case of hex bytes with no delimiter
    if (tokenCount === 1 && radix === 16) {
      var byteArray = hexString.match(/..?/g).map(function (s) {
        return parseInt(s, radix);
      }); //for id ="25665" it returns [ 2, 86, 101 ]
      return addTrailingZeros(byteArray, len);
    } else if (len < 0) {
      len = tokenCount;
    }

    /* assigns idByteArray with values from idSplit after converting to
    hex values and discarding the NaN values which might get generated
    when hexString contains extra delimiter "34::45:::" */

    var idByteArray = hexArray.slice(0, len).map(function (s) {
      if (!byteUtils.isHex(s)) {
        throw new Error(webEditorsLex.get('byteUtils.invalidDecodeInput.message'));
      }
      return parseInt(s, radix);
    }).filter(function (f) {
      return !isNaN(f);
    });

    // add zeros in the end
    addTrailingZeros(idByteArray, len);
    return idByteArray;
  };

  /**
   * Validates if input string is Hexadecimal.
   *
   * @since Niagara 4.14
   * @param {String} str
   * @returns {boolean}
   */
  byteUtils.isHex = function (str) {
    return !str.match(/[^A-Fa-f\d]/);
  };

  /**
   * Converts a base64 array into a Hex String.
   *
   * @param {Array|Uint8Array} byteArray
   * @returns {string} hex string of the input byte array.
   */
  byteUtils.byteArrayToHexString = function () {
    var byteArray = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    if (byteArray) {
      return Array.from(byteArray, function (_byte) {
        return ('0' + (_byte & 0xFF).toString(16)).slice(-2);
      }).join('');
    }
    return '';
  };

  /**
   * Bytes will be reversed/ascii-ed and then converted into a hex string.
   *
   * @param {Array|Uint8Array} bytes Example input: [ 0, 18, 58 ] will be converted to '00123a' in hex.
   * @param {Object} params
   * @param {boolean} [params.reverse=false] false/undefined will reverse input bytes from [ 0, 18, 58 ] to [ 58, 18, 0 ] and resulting hex to '3a1200'
   * @param {boolean} [params.showAscii=false] true will make the method to return ascii-ed text of the bytes
   * @returns {string} ascii-ed or hex string of the input bytes.
   */
  byteUtils.getHexString = function () {
    var bytes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      _ref2$reverse = _ref2.reverse,
      reverse = _ref2$reverse === void 0 ? false : _ref2$reverse,
      _ref2$showAscii = _ref2.showAscii,
      showAscii = _ref2$showAscii === void 0 ? false : _ref2$showAscii;
    //If 'reverse' facet was set to false/undefined, then reverse the bytes.
    if (!reverse) {
      bytes = bytes.reverse();
    }
    //If 'showAscii' facet was set to true, then show raw bytes.
    if (showAscii) {
      var asciiText = '';
      bytes.forEach(function (_byte2) {
        asciiText += String.fromCharCode(_byte2);
      });
      return asciiText;
    }
    return byteUtils.byteArrayToHexString(bytes);
  };
  return byteUtils;
});
