/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * @fileOverview typedefs for the webEditors module, purely for documentation
 * and autocomplete.
 */

////////////////////////////////////////////////////////////////
// niagara.env
////////////////////////////////////////////////////////////////

/**
 * API Status: **Private**
 *
 * Documentation for the `niagara.env` global namespace.
 *
 * @global
 * @namespace niagara.env
 */

/**
 * A CSRF token to use when communicating with CSRF-protected servlets.
 *
 * @constant niagara.env.csrfToken
 * @type {string}
 */

/**
 * True if the web browser is currently in design time, i.e. when editing a
 * Px page.
 *
 * @constant niagara.env.designTime
 * @type {string}
 */

/**
 * Get the current session ORD; e.g. "local:" or "ip:1.2.3.4". This will be
 * present only if injected by `BWebWidget`.
 *
 * @function niagara.env.getSessionOrd
 * @returns {string}
 */

/**
 * Get the current base ORD; e.g. "local:|foxs:|station:|slot:/Folder".
 * This will be present only if injected by `BWebWidget`.
 *
 * @since Niagara 4.6
 * @function niagara.env.getBaseOrd
 * @returns {string}
 */

/**
 * Get the view list for a particular ord; e.g. "station:|slot:/Folder".
 * This will be present only if injected by `BWebWidget`.
 *
 * @since Niagara 4.9
 * @function niagara.env.listViews
 * @returns {string} empty String to indicate the view list should not be
 * overridden. Any other string should be the JSON encoding of an object of type
 * `profileInfo~ViewInfo`.
 */

/**
 * @function niagara.env.hyperlink
 * @param {string|baja.Ord} ord the ORD to hyperlink to
 * @param {Function} [assign] function to assign the URI; if omitted should use
 * `location.assign`
 * @returns {Promise} to be resolved after the hyperlink is complete
 */

/**
 * The module prefix to use when loading resources, e.g. `/module/`. This is
 * a specialized property used to support loading local Workbench resources and
 * will only be available in a Workbench environment.
 *
 * @private
 * @constant niagara.env.modulePrefix
 * @type {string}
 * @see WbWebWidgetServlet
 */

/**
 * The time the NRE was last booted. This will only be present in a Workbench
 * environment.
 *
 * @constant niagara.env.nreBootTime
 * @type {number}
 */

/**
 * The type spec of the current web profile.
 *
 * @constant niagara.env.profile
 * @type {string}
 */

/**
 * True if the station has been configured to enable the timing and profiling of
 * browser performance.
 *
 * @constant niagara.env.profileBrowser
 * @type {boolean}
 */

/**
 * The last build timestamp of the Niagara registry.
 *
 * @constant niagara.env.regLastBuildTime
 * @type {number}
 */

/**
 * Reloads by hyperlinking to the current view
 *
 * @function niagara.env.reload
 * @returns {Promise}
 * @see niagara.env.hyperlink
 */

/**
 * Start a drag operation. If called in a Workbench environment, the interop
 * will kick in to allow dragging out of the browser and into Workbench itself.
 *
 * @function niagara.env.startDrag
 * @param {String|Object} json a JSON encoded string, or an object to
 * be encoded to JSON. The encoded object should have a String `mime`
 * property, and an Array `data` property.
 * @param {JQuery.Event} ev the jQuery dragstart event
 */

/**
 * The name of the current theme, e.g. "Zebra".
 *
 * @constant niagara.env.themeName
 * @type {string}
 */

/**
 * @function niagara.env.toHyperlink
 * @param {string} ordStr an ORD string
 * @returns {Promise.<string>} a URI derived from that ORD that can be
 * hyperlinked to
 */

/**
 * The type of the current environment. Possible values are `hx`, `hxPx`,
 * `mobile`, and `wb`.
 *
 * @constant niagara.env.type
 * @type {string}
 */

/**
 * True if running in a Workbench environment and Workbench has been configured
 * to use local resources in place of those loaded from the station.
 *
 * @private
 * @constant niagara.env.useLocalWbRc
 * @type {boolean}
 */

/**
 * The name of the currently logged-in user.
 *
 * @constant niagara.env.user
 * @type {string}
 */

/**
 * The timezone of the station Niagara is running on.
 * @constant niagara.env.timeZoneId
 * @type {string}
 */

////////////////////////////////////////////////////////////////
// profileInfo
////////////////////////////////////////////////////////////////

/**
 * API Status: **Private**
 *
 * profileInfo is generated by BHTML5HxProfile and injected into the page using
 * `webEditors/rc/wb/profile/profile.vm`.
 *
 * @module profileInfo
 */

/**
 * @function isDynamicLoading
 * @memberOf module:profileInfo
 * @returns {boolean} true if the profile is configured as a single-page
 * application (widgets will dynamically load in the profile's content pane). If
 * false, should do a full page reload on every hyperlink
 */

/**
 * @function getConfigOptions
 * @memberOf module:profileInfo
 * @returns {module:profileInfo~ConfigOptions}
 */

/**
 * @function getHomeOrd
 * @memberOf module:profileInfo
 * @returns {baja.Ord} the ORD for the user to go home
 */

/**
 * @function getOrd
 * @memberOf module:profileInfo
 * @returns {baja.Ord} the ORD for the current view
 */

/**
 * @function getSideBarConfigOptions
 * @memberOf module:profileInfo
 * @returns {Array.<module:profileInfo~SideBarConfigOptions>}
 */

/**
 * @function getStationName
 * @memberOf module:profileInfo
 * @returns {string} the station name
 */

/**
 * @function isMediaCommandAvailable
 * @memberOf module:profileInfo
 * @returns {boolean} true if the profile is configured to allow for view selection and
 * there is no system property for `niagara.profile.hideMediaCommand=true`.
 * @since Niagara 4.10
 */

/**
 * @function getViewInfo
 * @memberOf module:profileInfo
 * @returns {module:profileInfo~ViewInfo} ORD for the current view and a list
 * of info about available views on that ORD. This will be a safe copy so
 * editing this obj will not affect future calls to `getViewInfo`.
 */

/**
 * Sets new info for the current view. Call this with updated info when the
 * user navigates to a new ORD.
 *
 * @function setViewInfo
 * @memberOf module:profileInfo
 * @param {module:profileInfo~ViewInfo} new view info
 */

/**
 * Profile configuration options as configured on a user's `HTML5HxProfile`.
 *
 * @typedef {object} module:profileInfo~ConfigOptions
 * @property {boolean} configTree true if the component space should be shown
 * @property {boolean} filesTree true if the file space should be shown
 * @property {boolean} hierarchiesTree true if hierarchies should be shown
 * @property {boolean} historiesTree true if history space should be shown
 * @property {boolean} hxWbViews true if Hx Workbench views should be shown
 * @property {boolean} navFileTree true if the nav file space should be shown
 * @property {boolean} navTreeSideBar true if any nav tree sidebars should be shown
 * @property {boolean} paletteSideBar true if the palette should be shown
 * @property {boolean} searchSideBar true if search should be shown
 * @property {boolean} viewSelection true if the user should be able to select
 * non-default views via the dropdown
 */

/**
 * Configuration information used when rendering the sidebar.
 *
 * @typedef {object} module:profileInfo~SideBarConfigOptions
 * @property {string} key a key identifying which sidebar
 * @property {string} displayName sidebar display name
 * @property {string} className CSS class to apply to the sidebar's icon
 */

/**
 * All known view info for a given ORD as generated by ViewAllOrdServlet.
 *
 * @typedef {object} module:profileInfo~ViewInfo
 * @property {string} ord the ORD this view info is for
 * @property {BajaViewInfo[]} list info about all known views on this ORD
 */

/**
 * Describes info about one possible view on the result of a resolved ORD.
 * These are generated by `ViewAllOrdServlet`.
 *
 * @private
 * @typedef {object} BajaViewInfo
 *
 * @property {string} displayName display name of the view
 * @property {string} icon URI for the view's icon
 * @property {string} moduleName the module containing the view's Type, e.g.
 * `webEditors`
 * @property {string} typeName the type name, e.g. `UserManager`
 * @property {string} ord the original ORD, with the view query appended
 * @property {string} uri a URI suitable for hyperlinking
 * @property {Array.<string>} [builtRjs] an optional array of builtfile
 * dependencies that should be loaded before loading the actual module
 * @property {string} [rjs] the RequireJS ID for the module that implements
 * this view
 * @property {boolean} [def] true if this is the default view
 * @property {boolean} [hx] true if this is an Hx view
 * @property {boolean} [sv] true if this is a `ServletView`
 * @property {boolean} [px] true if this is a Px view
 * @property {boolean} [ux] true if this is UxMedia view
 * @property {boolean} [wb] true if this is a Workbench view
 */
