function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'Promise', 'underscore'], function (baja, Promise, _) {
  'use strict';

  var RPC_TYPE_ORD = 'type:webEditors:TypeConfigRpc';
  var getTypeConfigInfo = _.chain(baja.rpc).bind(baja).partial(RPC_TYPE_ORD, 'getTypeConfigInfo').memoize().value();
  var getConfigurableInfo = _.chain(baja.rpc).bind(baja).partial(RPC_TYPE_ORD, 'getConfigurableInfo').memoize(String.prototype.concat).value();
  function decodeAsync(str) {
    return baja.bson.decodeAsync(JSON.parse(str));
  }

  /**
   * API Status: **Private**
   *
   * Utilities for retrieving information about `BTypeConfig` and
   * `IConfigurable` Types from the station.
   *
   * This module communicates with the following RPC services:
   *
   * - `com.tridium.webeditors.ux.servlets.BTypeConfigRpc`
   *
   * @exports nmodule/webEditors/rc/servlets/typeConfig
   */
  var exports = {};

  /**
   * Retrieve information about the given `BTypeConfig` class. The resolved
   * object will contain the following properties:
   *
   * - `defaultType`: the default type to preselect, if none is set
   * - `targetType`: only types extending this type should be available for
   *   selection
   *
   * To illustrate, the info retrieved for `web:WebProfileConfig` would have
   * `hx:HTML5HxProfile` as the `defaultType` (that should be
   * preselected on a brand new web profile) and `targetType` would be
   * `web:IWebProfile` (only subtypes of that should be available to the user).
   *
   * @param {String} typeSpec
   * @returns {Promise.<{ defaultType: string, targetType: string }>} promise
   * to be resolved with an object literal containing `BTypeConfig` info
   */
  exports.getTypeConfigInfo = function (typeSpec) {
    return getTypeConfigInfo(String(typeSpec)).then(_.clone); //safe copy
  };

  /**
   * Retrieve information about the given `BTypeConfig.IConfigurable` class.
   * The resolved object will contain the following properties:
   *
   * - `config`: an array of objects corresponding to each key provided by
   *   the `IConfigurable`
   *
   * Each object in the `config` array will contain the following properties:
   *
   * - `key`: the string identifying that config object
   * - `displayName`: a display name string for that key
   * - `facets`: a `baja.Facets` for that config object
   * - `value`: the default `baja.Value` for that config object
   *
   * @param {String} typeConfigSpec
   * @param {String} configurableSpec
   * @returns {Promise} promise to be resolved with an object literal
   * containing `IConfigurable` info
   */
  exports.getConfigurableInfo = function (typeConfigSpec, configurableSpec) {
    // { config: [ { 'displayName', 'facets', 'key', 'value' } ] }
    // since we're memoizing, we need to return a safe copy
    return getConfigurableInfo(String(typeConfigSpec), String(configurableSpec)).then(function (_ref) {
      var config = _ref.config;
      return Promise.all(_.map(config, decodeConfigObject));
    }).then(function (config) {
      return {
        config: config
      };
    });
  };
  function decodeConfigObject(obj) {
    var facets = obj.facets,
      value = obj.value;
    return Promise.all([decodeAsync(facets), decodeAsync(value)]).then(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        facets = _ref3[0],
        value = _ref3[1];
      return _.extend({}, obj, {
        facets: facets,
        value: value
      });
    });
  }
  return exports;
});
