function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/servlets/resolveServerSide
 */

define(['baja!', 'Promise', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils'], function (baja, Promise, compUtils, facetsUtils) {
  'use strict';

  var toFacets = facetsUtils.toFacets;
  var hasCustomToString = compUtils.hasCustomToString;
  function doRpc(complexesBson, clientFacetsBson, batch) {
    if (!complexesBson || complexesBson.length === 0) {
      return Promise.resolve([]);
    }
    return baja.rpc({
      typeSpec: "webEditors:ResolveServerSideRpc",
      method: "resolveServerSideToString",
      args: [complexesBson, clientFacetsBson],
      batch: batch
    });
  }
  function doLocalString(toBeLocalToStringed, context) {
    var promises = [];
    toBeLocalToStringed.forEach(function (comp) {
      promises.push(comp.toString(context));
    });
    return Promise.all(promises);
  }
  /**
   * Exports utilities to resolve component information on the server
   * @since Niagara 4.14
   * @exports nmodule/webEditors/rc/servlets/resolveServerSide
   */

  var exports = {};

  /**
   * Resolves the string value of a complex by either calling its 'toString' if it has overwritten
   * the complex default complex 'toString' or calling the server side 'toString' via RPC
   * @param {Array<baja.Complex>|baja.Complex} complexes a complex or an array of complexes to  have
   * their toString called on
   * @param {Object} [params] parameters for the resolve to string call
   * @param {baja.Facets|Object} [params.cx] the context
   * @param {baja.comm.Batch} [params.batch] the batch to run the rpc in
   * @returns {Promise<Array<String>>} the resulting value from the toString call
   */
  exports.resolveToString = function (complexes) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var indicesDoneLocally = [];
    var indicesSentToServer = [];
    var toBeLocalToStringed = [];
    var toBeServerToStringed = [];
    var cx = params.cx,
      batch = params.batch;
    var clientFacets = baja.Facets.DEFAULT;
    var clientFacetsBson;
    complexes = Array.isArray(complexes) ? complexes : [complexes];
    if (cx) {
      clientFacets = toFacets(cx);
    }
    clientFacetsBson = JSON.stringify(baja.bson.encodeValue(clientFacets));
    complexes.forEach(function (comp, index) {
      if (hasCustomToString(comp)) {
        indicesDoneLocally.push(index);
        toBeLocalToStringed.push(comp);
      } else {
        indicesSentToServer.push(index);
        toBeServerToStringed.push(JSON.stringify(baja.bson.encodeValue(comp)));
      }
    });
    return Promise.all([doLocalString(toBeLocalToStringed, cx), doRpc(toBeServerToStringed, clientFacetsBson, batch)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        localToStrings = _ref2[0],
        serverToString = _ref2[1];
      var results = [];
      localToStrings.forEach(function (str, index) {
        results[indicesDoneLocally[index]] = str;
      });
      serverToString.forEach(function (str, index) {
        results[indicesSentToServer[index]] = str;
      });
      return results;
    });
  };

  /**
   * Check whether a parent is legal for the given value or not. If the parent is mounted, then actual parent's navOrd will be used
   * to do this check against the mounted component. If the parent is not mounted, it will be done against the unmounted value of that Component.
   * @param {baja.Component} parent
   * @param {baja.Value} value
   * @returns {Promise.<boolean>}
   */
  exports.isParentLegal = function (parent, value) {
    if (!value.getType().isComponent()) {
      return Promise.resolve(true);
    }
    var parentOrd = '';
    if (parent.isMounted()) {
      parentOrd = parent.getNavOrd().toString();
    }
    return baja.rpc({
      typeSpec: "webEditors:ResolveServerSideRpc",
      method: "isParentLegal",
      args: [JSON.stringify(baja.bson.encodeValue(parent)), JSON.stringify(baja.bson.encodeValue(value)), parentOrd]
    });
  };
  return exports;
});
