/**
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

define(['baja!'], function (baja) {
  'use strict';

  var FACETS_ENCODING = baja.Facets.make({
    includeCategorizableOrd: true
  }).encodeToString();
  /**
   * API Status: **Private**
   *
   * Category utility.
   *
   * @exports nmodule/webEditors/rc/servlets/category
   */
  var exports = {};

  /**
   * Returns the navChildren for a given node.
   * @param {String} ordString
   * @returns {Promise.<String>} array of navChildren
   */
  exports.getNavChildren = function (ordString) {
    return baja.rpc({
      typeSpec: "box:NavNodeSessionHandler",
      method: "getNavChildren",
      args: [ordString, FACETS_ENCODING]
    });
  };

  /**
   * Returns the novNode details for a given node.
   * @param {String} ordString
   * @returns {Promise.<Object>} navNode details in json format.
   */
  exports.getNavNodeInfo = function (ordString) {
    return baja.rpc({
      typeSpec: "box:NavNodeSessionHandler",
      method: "getNavNodeInfo",
      args: [ordString, FACETS_ENCODING]
    });
  };

  /**
   * Returns the categoryMask for a given component ord.
   * @param {String} ordString
   * @returns {Promise.<String>}
   */
  exports.getCategoryMask = function (ordString) {
    return baja.rpc({
      typeSpec: "webEditors:ComponentRpc",
      method: "getCategoryMask",
      args: [ordString]
    });
  };

  /**
   * Sets the categoryMask for a given component ord.
   * @param {String} ordString
   * @param {String} categoryMask
   * @returns {Promise}
   */
  exports.setCategoryMask = function (ordString, categoryMask) {
    return baja.rpc({
      typeSpec: "webEditors:ComponentRpc",
      method: "setCategoryMask",
      args: [ordString, categoryMask]
    });
  };

  /**
   * Returns applied categoryMask for a given component ord.
   * @param {String} ordString
   * @returns {Promise.<String>}
   */
  exports.getAppliedCategoryMask = function (ordString) {
    return baja.rpc({
      typeSpec: "webEditors:ComponentRpc",
      method: "getAppliedCategoryMask",
      args: [ordString]
    });
  };

  /**
   * Returns the categorizable Ord for a given component ord.
   * @param {String|baja.Ord} ord
   * @returns {string}
   */
  exports.toCategorizableOrd = function (ord) {
    var navOrd = ord.toString();
    if (navOrd.endsWith('|virtual:/')) {
      return navOrd.substring(0, navOrd.length - '|virtual:/'.length);
    }
    return navOrd;
  };
  return exports;
});
