function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder
 */
define(['baja!', 'bajaux/Properties', 'bajaux/mixin/batchLoadMixin', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/util/ComplexDiff', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/fe/baja/util/slotUtils', 'nmodule/webEditors/rc/fe/baja/util/typeUtils', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, Properties, batchLoadMixin, $, Promise, _, ComplexDiff, compUtils, slotUtils, typeUtils, CompositeBuilder) {
  'use strict';

  var canWriteSlot = compUtils.canWriteSlot,
    getSlotIcon = slotUtils.getSlotIcon,
    isComplex = typeUtils.isComplex,
    loadWidgets = batchLoadMixin.loadWidgets;

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  function isRawSlot(slot) {
    return typeof slot === 'string' || slot instanceof baja.Slot;
  }
  function isFeConfig(slot) {
    return _typeof(slot) === 'object' && isRawSlot(slot.slot);
  }
  function toSlotName(slot) {
    if (isRawSlot(slot)) {
      return String(slot);
    }
    if (isFeConfig(slot)) {
      return String(slot.slot);
    }
  }
  function findBySlot(complex, slots, slotName) {
    var slot, i;
    if (typeof slots === 'function') {
      slot = complex.getSlot(slotName);
      return slot ? slots.call(complex, slot) : null;
    }
    for (i = 0; i < slots.length; i++) {
      slot = slots[i];
      if (toSlotName(slot) === slotName) {
        return isRawSlot(slot) ? slotName : slot;
      }
    }
    return null;
  }
  function toKeys(complex, slots) {
    if (!complex || !slots) {
      return [];
    }
    if (Array.isArray(slots)) {
      return _.map(slots, toSlotName);
    }

    //if not an array, slots is a filter function
    return _.map(complex.getSlots().toArray().filter(_.bind(slots, complex)), String);
  }

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * `CompositeBuilder` that will manage editors for individual slots on
   * a parent `Complex` instance. Every key used by this builder should
   * correspond to a slot name on the Complex.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/config/CompositeBuilder
   * @alias module:nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder
   * @param {Object} [params]
   * @param {baja.Complex} [params.complex] the complex whose slots we will create
   * editors for
   * @param {Array|Function} [params.slots] a slot filter that determines which
   * slots we will create editors for.
   */
  var ComplexCompositeBuilder = function ComplexCompositeBuilder(params) {
    var complex = params && params.complex,
      slots = params && params.slots;
    CompositeBuilder.call(this, $.extend(params, {
      dataSource: complex
    }));
    this.setSlots(slots);
  };
  ComplexCompositeBuilder.prototype = Object.create(CompositeBuilder.prototype);
  ComplexCompositeBuilder.prototype.constructor = ComplexCompositeBuilder;

  /**
   * Sets the data source to the given `Complex`.
   *
   * @param {baja.Complex} complex
   * @returns {Promise} promise to be resolved when data source is set,
   * or rejected if a non-`Complex` given
   */
  ComplexCompositeBuilder.prototype.setDataSource = function (complex) {
    if (complex && !isComplex(complex)) {
      return Promise.reject(new Error('baja.Complex required'));
    }
    return CompositeBuilder.prototype.setDataSource.apply(this, arguments);
  };

  /**
   * Set the slot filter that determines which slots will have editors built
   * for them.
   *
   * @param {Array|Function} slots
   */
  ComplexCompositeBuilder.prototype.setSlots = function (slots) {
    this.$slots = slots;
  };

  /**
   * The keys on this builder will correspond to slot names that exist on
   * the backing `Complex` and are matched by the current slot filter.
   *
   * @returns {Promise} promise to be resolved with an array of string keys
   * @throws {Error} if the slot filter results in a slot that does not exist
   * on the backing `Complex`
   */
  ComplexCompositeBuilder.prototype.getKeys = function () {
    var complex = this.getDataSource(),
      slots = this.$slots,
      keys = toKeys(complex, slots),
      i;
    for (i = 0; i < keys.length; i++) {
      if (!complex.has(keys[i])) {
        return Promise.reject(new Error('slot ' + keys[i] + ' not found on complex'));
      }
    }
    return Promise.resolve(keys);
  };

  /**
   * Build a parameter object that will be passed to `fe.makeFor`.
   *
   * Slot facets will be taken into account and passed through to be set
   * as facets on the editor itself. A `type` facet will be passed through
   * directly, to allow a `type` Slot Facet configured on the station to
   * determine what type of editor to instantiate.
   *
   * @param {String} key
   * @returns {Object}
   */
  ComplexCompositeBuilder.prototype.getConfigFor = function (key) {
    var complex = this.getDataSource(),
      slots = this.$slots;
    return Promise.resolve(findBySlot(complex, slots, key)).then(function (slotObj) {
      if (!slotObj) {
        return null;
      }
      var complexFacets = complex.getFacets(key),
        config = {
          complex: complex,
          slot: complex.getSlot(key),
          properties: complexFacets.toObject(),
          formFactor: 'mini'
        };
      if (_typeof(slotObj) === 'object') {
        config = _.extend({}, slotObj, config, {
          properties: _.extend(config.properties, slotObj.properties)
        });
      }
      return config;
    });
  };

  /**
   * Return the slot display name for that slot.
   *
   * @param {String} key
   * @returns {String}
   */
  ComplexCompositeBuilder.prototype.getDisplayNameFor = function (key) {
    return this.getDataSource().getDisplayName(key);
  };

  /**
   * Resolve the Type icon for a Property, or action.png/topic.png for an
   * Action or Topic.
   *
   * @param {String} key
   * @returns {Promise}
   */
  ComplexCompositeBuilder.prototype.getIconFor = function (key) {
    var complex = this.getDataSource(),
      slot = complex.getSlot(key),
      value = this.getValueFor(key);
    if (baja.hasType(value, 'baja:Component')) {
      var icon = value.getIcon();
      if (baja.hasType(icon, 'baja:Icon')) {
        return Promise.resolve(icon);
      }
    }
    return Promise.resolve(slot && getSlotIcon(slot) || '');
  };

  /**
   * If the key corresponds to `Property`, get that value off the backing
   * `Complex`. If the key corresponds to an `Action` or `Topic`, return the
   * slot instance directly.
   *
   * @param {String} key
   * @returns {baja.Value|baja.Slot} property value, or action or topic slot
   */
  ComplexCompositeBuilder.prototype.getValueFor = function (key) {
    var complex = this.getDataSource(),
      slot = complex.getSlot(key);
    if (slot && slot.isProperty()) {
      return complex.get(slot);
    }
    return slot;
  };

  //TODO: edit by ref semantics here? should this be all in doSave?
  /**
   * Retrieves the current value of the `Complex` by reading the current
   * states of all individual field editors. These values will be assembled
   * into a new `Complex` instance of the same Type that was initially loaded.
   *
   * Note that any child slots that are of a `Complex` type will be
   * `newCopy()`-ed before being set on the copy. This is to respect
   * edit-by-ref semantics and avoid "already parented" errors.
   *
   * @private
   * @returns {Promise} promise to be resolved with a brand new, unmounted
   * `Complex` instance constructed from the individual slot editors.
   */
  ComplexCompositeBuilder.prototype.$readNewCopy = function () {
    var that = this,
      complex = that.getDataSource(),
      copy = baja.$(complex.getType());
    return Promise.resolve(that.getKeys()).then(function (keys) {
      var includedKeys = keys.filter(function (key) {
        var slot = complex.getSlot(key);
        return slot && slot.isProperty();
      });
      return Promise.all(includedKeys.map(function (key) {
        var ed = that.getEditorFor(key);
        if (!ed) {
          throw new Error('could not find editor for slot ' + key + ' on complex ' + complex);
        }
        return ed.read().then(function (value) {
          var method = copy.has(key) ? 'set' : 'add';
          if (value instanceof ComplexDiff) {
            var subComp = complex.get(key).newCopy();
            return value.apply(subComp).then(function () {
              return copy[method]({
                slot: key,
                value: subComp
              });
            });
          } else {
            return copy[method]({
              slot: key,
              value: isComplex(value) ? value.newCopy() : value
            });
          }
        });
      }));
    }).then(function () {
      return copy;
    });
  };
  ComplexCompositeBuilder.prototype.$readDiff = function () {
    var that = this,
      modifiedKeys;
    return Promise.resolve(that.getKeys()).then(function (keys) {
      modifiedKeys = _.filter(keys, function (key) {
        return that.getEditorFor(key).isModified();
      });
      return that.$readForKeys(modifiedKeys).then(function (values) {
        var diff = new ComplexDiff();
        _.each(values, function (value, i) {
          try {
            diff.set(modifiedKeys[i], value);
          } catch (ignore) {}
        });
        return diff;
      });
    });
  };

  /**
   * Reads a diff of user-entered changes to the loaded `Complex` instance.
   * This will read all modified editors and assemble their values into a
   * `ComplexDiff` instance. Note that by default, this will be the value
   * resolved by `ComplexCompositeEditor#doRead`, so subclasses of that editor
   * that implement validators or a `doSave()` function will need to handle
   * the diff accordingly.
   *
   * Any child editors who resolve a value from `doRead()` that is not
   * compatible with a `ComplexDiff` will simply not be included in the diff.
   * When saving the `Complex`, that child editor will be solely responsible
   * for saving its own changes via its `doSave()` method.
   *
   * @returns {Promise} promise to be resolved with an
   * `nmodule/webEditors/rc/fe/baja/util/ComplexDiff` instance
   */
  ComplexCompositeBuilder.prototype.readAll = function () {
    return this.$readDiff();
  };
  ComplexCompositeBuilder.prototype.$updateReadonlyFor = function (key) {
    var complex = this.getDataSource();
    if (!complex.has(key)) {
      return;
    }
    //NCCB-9570, NCCB-11006
    return this.getEditorFor(key).setReadonly(!canWriteSlot(complex, key));
  };

  /**
   * Loads the editor for the given key, also setting the editor to
   * readonly according to the backing slot's READONLY flag.
   *
   * @param {String} key
   * @returns {Promise}
   */
  ComplexCompositeBuilder.prototype.$loadFor = function (key) {
    var that = this;
    return CompositeBuilder.prototype.$loadFor.apply(this, arguments).then(function () {
      return that.$updateReadonlyFor(key);
    });
  };

  /**
   * Loads editors for all matching slots on the backing Complex. Widgets
   * that have `batchLoadMixin` will be taken into account; all subscriptions
   * will be batched into a single network call.
   *
   * @private
   * @returns {Promise}
   */
  ComplexCompositeBuilder.prototype.$loadAll = function () {
    var that = this;
    return Promise.all([that.getKeys(), that.$initializeAll()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        keys = _ref2[0];
      var getWidgets = _.map(keys, function (key) {
          return that.getEditorFor(key);
        }),
        getValues = _.map(keys, function (key) {
          return that.getValueFor(key);
        });
      return Promise.all([Promise.all(getWidgets), Promise.all(getValues)]).then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          widgets = _ref4[0],
          values = _ref4[1];
        return loadWidgets(widgets, values);
      }).then(function () {
        return Promise.all(_.map(keys, function (key) {
          return that.$updateReadonlyFor(key);
        }));
      });
    });
  };
  return ComplexCompositeBuilder;
});
