function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/StatusEditor
 */
define(['baja!', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/baja/BooleanPicker', 'nmodule/webEditors/rc/fe/baja/util/statusUtils'], function (baja, spandrel, BooleanPicker, statusUtils) {
  'use strict';

  var statusToString = statusUtils.statusToString;

  //TODO: put this in BajaScript?
  var SUPPORT = {
    '1': 'disabled',
    '2': 'fault',
    '4': 'down',
    '8': 'alarm',
    '16': 'stale',
    '32': 'overridden',
    '64': 'null',
    '128': 'unackedAlarm'
  };
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'webEditors',
      keyName: 'StatusEditor',
      properties: {
        rootCssClass: '-t-StatusEditor'
      }
    };
  };

  /**
   * A field editor for working with Statuses. It supports the following
   * `Properties`:
   *
   * - `filter`: if a numeric `filter` property is provided, only those Statuses
   *   that bitwise-match the filter will be shown.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/webEditors/rc/fe/baja/StatusEditor
   */
  var StatusEditor = /*#__PURE__*/function (_spandrel) {
    function StatusEditor(params) {
      var _this;
      _classCallCheck(this, StatusEditor);
      _this = _callSuper(this, StatusEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$isHonoraryBaseEditor = true;
      return _this;
    }

    /**
     * @returns {baja.Status|Promise.<baja.Status>}
     */
    _inherits(StatusEditor, _spandrel);
    return _createClass(StatusEditor, [{
      key: "doRead",
      value: function doRead() {
        return this.$getPicker().read().then(function (bits) {
          return baja.Status.make(bits.reduce(bitwiseOr, 0));
        });
      }

      /**
       * Override to choose exactly which status bits will be editable by this editor. Returns true by
       * default to edit all bits.
       * @param {number} bit
       * @return {boolean} true if this bit should be editable
       */
    }, {
      key: "isToDisplay",
      value: function isToDisplay(bit) {
        return true;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/BooleanPicker|undefined} the bit picker, or
       * undefined when readonly
       */
    }, {
      key: "$getPicker",
      value: function $getPicker() {
        return this.queryWidget('picker');
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getReadonlyTextInput",
      value: function $getReadonlyTextInput() {
        return this.jq().find('input[type=text]');
      }
    }]);
  }(spandrel(function (status, _ref) {
    var filter = _ref.properties.filter,
      self = _ref.self,
      writable = _ref.writable;
    var choices = getChoices(function (bit) {
      // noinspection JSBitwiseOperatorUsage
      return self.isToDisplay(bit) && (!filter || filter & bit);
    });
    return statusToString(status).then(function (str) {
      return [spandrel.jsx(BooleanPicker, {
        spandrelKey: "picker",
        value: getBitsArray(status),
        properties: {
          choices: choices
        },
        onUxModify: function onUxModify() {
          return self.rerender();
        }
      }), spandrel.jsx("input", {
        className: "-t-StatusEditor-display",
        type: "text",
        readOnly: true,
        value: str
      })];
    });
  }));
  /**
   * @param {baja.Status} status
   * @returns {Array.<number>}
   */
  function getBitsArray(status) {
    var bitsArray = [];
    allBits().forEach(function (bit) {
      if (status.getBit(bit)) {
        bitsArray.push(bit);
      }
    });
    return bitsArray;
  }

  /**
   * @param {function} filter function to filter on each bit
   * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/BooleanPicker~Choice>}
   */
  function getChoices(filter) {
    return allBits().filter(filter).map(function (bit) {
      var name = SUPPORT[bit];
      var display = "%lexicon(baja:Status.".concat(name, ")%");
      return {
        display: display,
        value: bit
      };
    });
  }
  function allBits() {
    return Object.keys(SUPPORT).map(function (bit) {
      return +bit;
    });
  }
  function bitwiseOr(a, b) {
    return a | b;
  }
  return StatusEditor;
});
