function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/HostOrdEditor
 */
define(['baja!', 'nmodule/webEditors/rc/util/ipAddressUtil', 'lex!webEditors', 'jquery', 'underscore', 'bajaux/events', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/StringEditor', 'nmodule/webEditors/rc/wb/options/MruButton', 'nmodule/webEditors/rc/wb/options/MruOptions'], function (baja, ipAddressUtil, lex, $, _, events, spandrel, Widget, Promise, fe, feDialogs, BaseWidget, StringEditor, MruButton, MruOptions) {
  'use strict';

  var _lex = _slicedToArray(lex, 1),
    webEditorsLex = _lex[0];
  var isValidHost = ipAddressUtil.isValidHost;
  var MRU_NAME = 'hostOrdFE';
  var resolveMruOptions = function resolveMruOptions() {
    return MruOptions.make(MRU_NAME);
  };
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-HostOrdEditor'
      },
      rows: []
    };
  };

  /**
   * A field edit for editing host ords
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/HostOrdEditor
   * @extends module:bajaux/Widget
   * @since Niagara 4.13
   **/
  var HostOrdEditor = /*#__PURE__*/function (_spandrel) {
    function HostOrdEditor(params) {
      var _this;
      _classCallCheck(this, HostOrdEditor);
      _this = _callSuper(this, HostOrdEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$loadOrd = function (value) {
        _this.load(baja.Ord.make(value));
      };

      /**
       * The HostOrdEditor will fail to validate when
       *  The ordHost is not a valid IPv4, IPv6, IPv4Mapped address and not a
       *  valid host name.  If it is a valid one of ANY of the above it will pass
       *  the test. (some invalid IPv4 addresses are valid host name)
       *
       * @method module:nmodule/webEditors/rc/fe/baja/NumericEditor#validate
       */
      _this.validators().add(function () {
        return this.$validateOrd();
      });
      return _this;
    }
    _inherits(HostOrdEditor, _spandrel);
    return _createClass(HostOrdEditor, [{
      key: "toState",
      value: function toState(ord) {
        var scheme = "ip";
        var body = "";
        var queries = ord.parse();
        var firstQuery = queries.get(0);
        if (firstQuery) {
          scheme = firstQuery.getSchemeName().toLowerCase();
          body = firstQuery.getBody();
          if (scheme !== "ip") {
            if (scheme === "local") {
              body = "local";
            } else {
              scheme = "ip";
              body = "";
            }
          }
        }
        return {
          ordScheme: scheme,
          ordHost: body
        };
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        var ordHost = state.ordHost;
        var ord;
        if (ordHost.toLowerCase() === "local") {
          ord = "local:";
        } else {
          ord = "ip:" + ordHost;
        }
        return baja.Ord.make(ord);
      }
    }, {
      key: "doInitialize",
      value: function doInitialize() {
        var _arguments = arguments,
          _this2 = this;
        if (baja.isOffline()) {
          return _superPropGet(HostOrdEditor, "doInitialize", this, 3)(arguments);
        } else {
          return resolveMruOptions().then(function (mruOptions) {
            _this2.state({
              mruOptions: mruOptions
            });
            return _superPropGet(HostOrdEditor, "doInitialize", _this2, 3)(_arguments);
          });
        }
      }
    }, {
      key: "doSave",
      value: function doSave() {
        /*
         * Removed the saving of the current ord from the doDestory as part of NCCB-53988
         * @since Niagara 4.14
         *
         * Saves the current ord when necessary
         */
        var ord = this.fromState(this.state()).$ord;
        return !baja.isOffline() && MruOptions.make(MRU_NAME).then(function (mru) {
          mru.add(ord);
          return mru.save();
        });
      }
    }, {
      key: "$validateOrd",
      value: function $validateOrd() {
        var _this$state = this.state(),
          ordHost = _this$state.ordHost;
        if (!isValidHost(ordHost)) {
          throw new Error(webEditorsLex.get('HostOrdEditor.error.invalidHost', [ordHost]));
        }
      }

      /**
       * @private
       * @param {object} state
       * @returns {object}
       */
    }, {
      key: "$buildEditor",
      value: function $buildEditor(state) {
        var ordHost = state.ordHost,
          mruOptions = state.mruOptions,
          self = state.self;
        return [spandrel.jsx("div", {
          "class": "-t-HostOrdEditor",
          spandrelKey: "layout"
        }, spandrel.jsx("div", {
          className: "-t-HostOrdField",
          spandrelKey: "hostOrdScheme"
        }, "IP"), spandrel.jsx("any", {
          "class": "-t-HostOrdEditor-stringVal -t-HostOrdField",
          bindKey: "ordHost",
          spandrelKey: "hostOrdVal",
          lax: "true",
          value: ordHost
        }), !baja.isOffline() ? spandrel.jsx(MruButton, {
          value: {
            options: mruOptions,
            select: self.$loadOrd
          },
          spandrelKey: "mru",
          className: "mru -t-HostOrdEditor-Mru"
        }) : null)];
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getOrdScheme",
      value: function $getOrdScheme() {
        return this.queryWidget('layout/hostOrdScheme');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getHostOrdVal",
      value: function $getHostOrdVal() {
        return this.queryWidget('layout/hostOrdVal');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getMruButton",
      value: function $getMruButton() {
        return this.queryWidget('layout/mru');
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor(state);
  }, {
    strategy: 'niagara'
  }));
  return HostOrdEditor;
});
