function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Scott Hoye
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/EnumSetEditor
 */
define(['baja!', 'lex!', 'bajaux/events', 'bajaux/Widget', 'jquery', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/util/ListSelection', 'hbs!nmodule/webEditors/rc/fe/baja/template/EnumSetEditor'], function (baja, lex, events, Widget, $, Promise, _, fe, BaseEditor, DisplayOnlyEditor, OrderedMapEditor, htmlUtils, ListSelection, tplEnumSetEditor) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT,
    preventSelectOnShiftClick = htmlUtils.preventSelectOnShiftClick;

  ////////////////////////////////////////////////////////////////
  // Support functions
  ////////////////////////////////////////////////////////////////

  /**
   * Returns the baja:EnumRange for the given EnumSet value.  If there is
   * no range specified on the EnumSet value (or it is using baja.EnumRange.DEFAULT),
   * the fallback behavior will be to look at the slot facets and use any EnumRange
   * declared there. If found, the results is of type `baja:EnumRange`.
   *
   * @private
   * @inner
   * @param widget The field editor for the EnumSet
   * @param {baja.EnumSet} enumSet The EnumSet value
   * @returns {baja.EnumRange} range facet set, or undefined if not present
   * or not `EnumRange`
   */
  function getEnumRange(widget, enumSet) {
    var range = enumSet && enumSet.getRange(),
      slotFacetRange;
    if (!range || range === baja.EnumRange.DEFAULT) {
      slotFacetRange = widget.properties().getValue('range');
      if (baja.hasType(slotFacetRange, 'baja:EnumRange')) {
        range = slotFacetRange;
      }
    }
    return range;
  }

  /**
   * Looks up the display value of a given element in the range.
   *
   * @private
   * @inner
   * @param {baja.EnumRange} range
   * @param {Number} ordinal
   * @param {Lexicon} lex the lexicon to attempt to find the key in
   * @returns {Promise|String} promise to be resolved with the String value
   * looked up from the specified lexicon, or the display tag of the ordinal if
   * not found.
   */
  function getTagDisplay(range, ordinal, lex) {
    var tag = range.getTag(ordinal);
    var unescaped = baja.SlotPath.unescape(tag);
    if (lex) {
      var tagDisplay = lex.get({
        // TODO: This escape is likely wrong (but this is currently how workbench works for enum ranges)
        key: baja.SlotPath.escape(tag),
        def: unescaped
      });
      if (tagDisplay !== tag) {
        return tagDisplay;
      }
      var val = range.get(ordinal);
      if (_.isFunction(val.getDisplayTag)) {
        return val.getDisplayTag();
      }
      return tag;
    }
    return unescaped;
  }

  /**
   * Given an `EnumSet` value, look up the optional Lexicon from its EnumRange.
   * If no Lexicon is found on the EnumRange, try finding a lexicon declared on
   * the slot facets.
   *
   * @private
   * @inner
   * @param widget The field editor for the EnumSet
   * @param {baja.EnumSet} enumSet the value for which to retrieve the Lexicon
   * @returns {Promise} a promise that will always resolve if a Lexicon is
   * found, but resolve with `undefined` if it cannot be found.
   */
  function getLexiconFromValue(widget, enumSet) {
    var enumRange = getEnumRange(widget, enumSet),
      lexicon = enumRange && enumRange.getOptions().get('lexicon');
    if (!lexicon) {
      // If no lexicon specified on the EnumSet's range, try the slot facets
      lexicon = widget.properties().getValue('lexicon');
    }
    var frozenType = enumRange.getFrozenType();
    if (!lexicon && frozenType) {
      lexicon = frozenType.toString().split(':')[0];
    }
    if (!lexicon) {
      return Promise.resolve();
    }
    return lex.module(lexicon)["catch"](function err() {});
  }

  ////////////////////////////////////////////////////////////////
  // EnumSetEditor definition
  ////////////////////////////////////////////////////////////////

  /**
   * A field editor for working with `EnumSet` values.  Depending
   * on the form factor, this will use the full (compact) EnumSetEditor
   * a mini, display-only version.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/EnumSetEditor
   */
  var EnumSetEditor = function EnumSetEditor(params) {
    BaseEditor.call(this, $.extend({
      keyName: 'EnumSetEditor'
    }, params));
    if (this.getFormFactor() === Widget.formfactor.mini && !this.$isSingleSelection()) {
      DisplayOnlyEditor.$mixin(this);
    }
  };
  EnumSetEditor.prototype = Object.create(BaseEditor.prototype);
  EnumSetEditor.prototype.constructor = EnumSetEditor;

  /**
   * When in single-selection mode, an `OrderedMapEditor` will be shown.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor} the
   * ordered map editor, or undefined if not present
   */
  EnumSetEditor.prototype.$getOrderedMapEditor = function () {
    return this.jq().children('.OrderedMap').data('widget');
  };

  /**
   * Get ordinals currently selected by the user.
   *
   * @private
   * @returns {Array.<Number>}
   */
  EnumSetEditor.prototype.$getSelectedOrdinals = function () {
    return this.jq().find('input:checked').map(function () {
      return parseInt($(this).data('ordinal'), 10);
    }).get();
  };

  /**
   * Return true if the `singleSelection` property is true.
   * @private
   * @returns {Boolean}
   */
  EnumSetEditor.prototype.$isSingleSelection = function () {
    return !!this.properties().getValue('singleSelection');
  };
  EnumSetEditor.prototype.$toDisplay = function (enumSet, ordinal) {
    var that = this;
    return Promise.all([getEnumRange(that, enumSet), getLexiconFromValue(that, enumSet)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        range = _ref2[0],
        lex = _ref2[1];
      return getTagDisplay(range, ordinal, lex);
    });
  };
  /**
   * When in single-selection mode, we'll instantiate an OrderedMapEditor for
   * the user to select a single value from.
   *
   * @private
   * @param {JQuery} dom
   * @param {baja.EnumSet} enumSet
   * @returns {Promise}
   */
  EnumSetEditor.prototype.$buildOrderedMapEditor = function (dom, enumSet) {
    var that = this,
      range = getEnumRange(that, enumSet),
      ordinals = range.getOrdinals();
    return Promise.all(_.map(ordinals, function (ordinal) {
      return that.$toDisplay(enumSet, ordinal);
    })).then(function (displays) {
      var map = new baja.OrderedMap();
      displays.forEach(function (display, i) {
        map.put(display, ordinals[i]);
      });
      return fe.buildFor({
        dom: dom,
        loadParams: {
          selectedValue: enumSet.getOrdinals()[0]
        },
        type: OrderedMapEditor,
        value: map
      });
    });
  };

  /**
   * Override the updateDisplay function on DisplayOnlyEditor
   * to provide a tag summary of the selected ordinals
   *
   * @returns {Promise} promise to be resolved after the display has been
   * updated
   */
  EnumSetEditor.prototype.updateDisplay = function (value) {
    var that = this,
      dom = that.jq(),
      ordinals = value.getOrdinals(),
      range = getEnumRange(that, value),
      emptyDisplay;
    if (!ordinals.length) {
      // Nothing selected, so display empty text
      emptyDisplay = that.properties().getValue('emptyDisplayText'); // Give priority to the slot facets

      if (!emptyDisplay) {
        // Fallback to the range facets if slot facets don't have emptyDisplayText
        emptyDisplay = range && range.getOptions().get('emptyDisplayText');
      }
      return dom.text(emptyDisplay || '');
    }
    return getLexiconFromValue(this, value).then(function (lex) {
      dom.text(_.map(ordinals, function (ordinal) {
        return getTagDisplay(range, ordinal, lex);
      }).join(', '));
    });
  };
  EnumSetEditor.prototype.$applyListSelectionToInputs = function () {
    var that = this;
    if (that.isReadonly() || !that.isEnabled()) {
      return;
    }
    // Iterate through the table rows and set .selected as indicated by ListSelection
    that.jq().find('.ux-table-row').each(function (i, element) {
      $(element).toggleClass('selected', that.$listSelection.isSelected(i));
      var inputElement = $(element).find('input').get(0);
      if (inputElement.checked !== that.$listSelection.isSelected(i)) {
        inputElement.checked = that.$listSelection.isSelected(i);
        $(inputElement).trigger('change');
      }
    });
  };

  /**
   * Respond to input change events
   *
   * @param {JQuery} dom
   */
  EnumSetEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.on('change', 'input', function () {
      that.setModified(true);
    });
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    preventSelectOnShiftClick(dom);
    that.$listSelection = new ListSelection();
    that.$listSelection.installTouchHandler(that.jq(), '.ux-table', '.ux-table-row', function () {
      return that.$applyListSelectionToInputs();
    });
  };

  /**
   * Loads the `EnumSet` into the editor, creating a checkbox and label
   * for each value in the enum range and selecting the ordinals.
   *
   * @param {baja.EnumSet} enumSet
   * @returns {Promise} promise to be resolved when all the checkboxes and
   * labels have finished loading into the DOM
   */
  EnumSetEditor.prototype.doLoad = function (enumSet) {
    var that = this,
      dom = that.jq();
    if (that.$isSingleSelection()) {
      var omDiv = $('<div class="OrderedMap"/>');
      dom.html(omDiv);
      return that.$buildOrderedMapEditor(omDiv, enumSet);
    }
    var ordinals = enumSet.getOrdinals(),
      range = getEnumRange(that, enumSet),
      rangeOrdinals = range && range.getOrdinals();
    if (range && range !== baja.EnumRange.DEFAULT) {
      return getLexiconFromValue(that, enumSet).then(function (lex) {
        dom.html(tplEnumSetEditor({
          rangeEnum: _.map(rangeOrdinals, function (ordinal) {
            return {
              id: that.generateId(),
              selected: ordinals.indexOf(ordinal) >= 0,
              ordinal: ordinal,
              displayName: getTagDisplay(range, ordinal, lex)
            };
          })
        }));
      });
    } else {
      // If there is no EnumRange specified, then just use the ordinals
      dom.html(tplEnumSetEditor({
        rangeEnum: _.map(ordinals, function (ordinal) {
          return {
            id: that.generateId(),
            selected: true,
            ordinal: ordinal,
            displayName: ordinal
          };
        })
      }));
    }
  };

  /**
   * Reads the checkbox inputs and returns an 'EnumSet' instance for
   * the selections made.
   *
   * @returns {baja.EnumSet|Promise.<baja.EnumSet>} a `baja.EnumSet` instance
   * read from checkbox editors
   */
  EnumSetEditor.prototype.doRead = function () {
    var that = this,
      val = that.value(),
      enumRange = val && getEnumRange(that, val);
    if (that.$isSingleSelection()) {
      return that.$getOrderedMapEditor().read().then(function (ordinal) {
        return baja.EnumSet.make({
          ordinals: [ordinal],
          range: enumRange
        });
      });
    } else {
      return baja.EnumSet.make({
        ordinals: that.$getSelectedOrdinals(),
        range: enumRange
      });
    }
  };

  /**
   * Enables or disables all checkboxes.
   *
   * @param {Boolean} enabled
   */
  EnumSetEditor.prototype.doEnabled = function (enabled) {
    this.jq().find('input').prop('disabled', this.isReadonly() || !enabled);
    return this.getChildWidgets().setAllEnabled(enabled);
  };

  /**
   * Sets all checkboxes readonly/writable.
   *
   * @param {Boolean} readonly
   */
  EnumSetEditor.prototype.doReadonly = function (readonly) {
    this.jq().find('input').prop('disabled', !this.isEnabled() || readonly);
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * Destroy child widgets.
   * @returns {Promise}
   */
  EnumSetEditor.prototype.doDestroy = function () {
    return this.getChildWidgets().destroyAll();
  };
  return EnumSetEditor;
});
