function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/EnumEditor
 */
define(['baja!', 'bajaux/spandrel', 'Promise', 'underscore', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/util/rangeUtils'], function (baja, spandrel, Promise, _, OrderedMapEditor, rangeUtils) {
  'use strict';

  var OrderedMap = baja.OrderedMap;
  var getEnumRangeDisplay = rangeUtils.getEnumRangeDisplay;
  var isNumber = _.isNumber,
    isString = _.isString;

  /**
   * Base editor for working with DynamicEnum or FrozenEnum instances, or "enum-like" scenarios in
   * which one value is selected from a set of choices.
   *
   * It can load values of type:
   *
   * - baja.Enum - a `range` property that is a `baja.EnumRange` will be respected; if omitted, will
   *   use the range from the Enum directly. `read()` will resolve the currently selected
   *   `baja.Enum` instance.
   * - string, with a `range` property that is a `baja.EnumRange` - `read()` will then resolve to
   *   the selected tag
   * - number, with a `range` property that is a `baja.EnumRange` - `read()` will then resolve to
   *   the selected ordinal
   * - Any `baja:IDataValue`, with a `range` property that is a `baja.Facets`. The loaded value
   *   corresponds to one of the values in the `Facets` - it is presumed there are no duplicate
   *   values. `read()` will then resolve to the currently selected value.
   *
   * It supports the following bajaux Properties:
   *
   * - `customEntry` (boolean) - if true, shows a string editor to allow the user to type a custom
   *   ordinal that may not actually be in the loaded Enum's range. If false, a dropdown will be
   *   shown instead. Only loading `DynamicEnum`s is supported when `customEntry` is true.
   * - `range` (baja.EnumRange|baja.Facets|String) - if specified, this range will be used instead
   *   of the range from the loaded Enum. If a String, this is the string encoding of a Facets. If
   *   loading a non-`Enum`, this is _required_.
   * - `uxValidOptions` (string) - a comma-separated string of ordinals (`BEnumSet` encoding). If
   *   specified, only these ordinals will be shown to the user to choose from, allowing you to
   *   discourage the user from selecting unwanted enum values. If loading a non-`Enum`, this is
   *   ignored.
   */
  var EnumEditor = /*#__PURE__*/function (_spandrel) {
    function EnumEditor() {
      _classCallCheck(this, EnumEditor);
      return _callSuper(this, EnumEditor, arguments);
    }
    _inherits(EnumEditor, _spandrel);
    return _createClass(EnumEditor, [{
      key: "toState",
      value: function toState(en) {
        if (baja.hasType(en, 'baja:Enum')) {
          return {
            enumType: en.getType(),
            rangeFromEnum: en.getRange(),
            selectedValue: en.getOrdinal()
          };
        } else {
          return {
            selectedValue: en
          };
        }
      }
    }, {
      key: "fromState",
      value: function fromState(_ref) {
        var _this = this;
        var enumType = _ref.enumType,
          rangeFromEnum = _ref.rangeFromEnum,
          selectedValue = _ref.selectedValue,
          properties = _ref.properties;
        return decodeRange(properties.range).then(function (range) {
          if (isFacets(range)) {
            // when using facets as range, we're choosing an arbitrary value from those facets.
            // selectedValue is always that value.
            return selectedValue;
          }
          if (enumType) {
            if (enumType.is('baja:Boolean')) {
              return selectedValue === 1;
            }
            if (selectedValue === '') {
              return baja.DynamicEnum.DEFAULT;
            }
            var ordinal = parseInt(selectedValue, 10);
            if (isNaN(ordinal)) {
              throw new Error('invalid ordinal: ' + selectedValue);
            } else {
              if (enumType.isFrozenEnum()) {
                return baja.$(enumType, ordinal);
              } else {
                return baja.DynamicEnum.make({
                  range: range || rangeFromEnum,
                  ordinal: ordinal
                });
              }
            }
          } else {
            var loadedValue = _this.value();
            if (isString(loadedValue)) {
              return range.get(selectedValue).getTag();
            } else {
              return selectedValue;
            }
          }
        });
      }
    }]);
  }(spandrel(function (en, state) {
    var enumType = state.enumType,
      properties = state.properties,
      rangeFromEnum = state.rangeFromEnum,
      selectedValue = state.selectedValue;
    var customEntry = properties.customEntry,
      uxValidOptions = properties.uxValidOptions;
    return decodeRange(properties.range).then(function (range) {
      var editedRange = range || rangeFromEnum;
      if (!enumType) {
        if (customEntry) {
          throw new Error('cannot load a non-Enum with customEntry: true');
        }
        if (!range) {
          throw new Error('range required when loading a non-Enum');
        }
        selectedValue = getValueOrDefault(range, selectedValue);
      } else if (isFacets(editedRange)) {
        selectedValue = en;
      }
      if (customEntry) {
        return rangeToDatalist(range || rangeFromEnum, function () {
          return true;
        }).then(function (datalist) {
          return spandrel.jsx("any", {
            tagName: "span",
            bind: true,
            spandrelKey: "selectedValue",
            value: String(selectedValue),
            properties: {
              datalist: datalist,
              filterWhileTyping: false
            }
          });
        });
      } else {
        var getDisplayText = isEnumRange(editedRange) && function (map, key) {
          var ordinal = map.get(key);
          return getEnumRangeDisplay(ordinal, editedRange);
        };
        return resolveOrdinalFilter(uxValidOptions, selectedValue).then(function (filter) {
          return rangeToOrderedMap(editedRange, filter);
        }).then(function (map) {
          return spandrel.jsx(OrderedMapEditor, {
            tagName: "span",
            lax: true,
            bind: true,
            spandrelKey: "selectedValue",
            value: selectedValue,
            properties: {
              map: map,
              getDisplayText: getDisplayText
            }
          });
        });
      }
    });
  }, {
    strategy: 'niagara'
  }));
  /**
   * @param {baja.EnumRange} range
   * @param {function(number): boolean} [ordinalIsValid]
   * @returns {Promise.<object>} resolves to a mapping from ordinal as string to display string for
   * that ordinal
   */
  function rangeToDatalist(range, ordinalIsValid) {
    var ordinals = range.getOrdinals();
    if (ordinalIsValid) {
      ordinals = ordinals.filter(ordinalIsValid);
    }
    return Promise.all(ordinals.map(function (ordinal) {
      return getEnumRangeDisplay(ordinal, range);
    })).then(function (displays) {
      var datalist = {};
      ordinals.forEach(function (ordinal, i) {
        datalist[ordinal] = displays[i];
      });
      return datalist;
    });
  }

  /**
   * @param {baja.EnumRange|baja.Facets} range
   * @param {function(number): boolean} ordinalIsValid
   * @returns {Promise.<baja.OrderedMap>} resolves an OrderedMap where the keys are display strings
   * for the tags, and the values are the ordinals
   */
  function rangeToOrderedMap(range, ordinalIsValid) {
    if (isEnumRange(range)) {
      var ordinals = range.getOrdinals();
      if (ordinalIsValid) {
        ordinals = ordinals.filter(ordinalIsValid);
      }
      var map = new OrderedMap();
      ordinals.forEach(function (ordinal) {
        map.put(String(ordinal), ordinal);
      });
      return map;
    } else {
      var _map = new OrderedMap();
      range.getKeys().forEach(function (key) {
        _map.put(baja.SlotPath.unescape(key), range.get(key));
      });
      return Promise.resolve(_map);
    }
  }

  /**
   * @param {string} [uxValidOptions]
   * @param {number} [selectedOrdinal]
   * @returns {Promise.<function(number): boolean|undefined>} resolves to a function that returns
   * true if an ordinal is valid for the user to choose, or undefined if any ordinal is valid
   */
  function resolveOrdinalFilter(uxValidOptions, selectedOrdinal) {
    if (!isString(uxValidOptions) || !isNumber(selectedOrdinal)) {
      return Promise.resolve();
    }
    return baja.EnumSet.DEFAULT.decodeAsync(uxValidOptions).then(function (enumSet) {
      var validOrdinals = [].concat(_toConsumableArray(enumSet.getOrdinals()), [selectedOrdinal]);
      return function (o) {
        return validOrdinals.includes(o);
      };
    });
  }
  function decodeRange(range) {
    return isString(range) ? baja.Facets.DEFAULT.decodeAsync(range) : Promise.resolve(range);
  }
  function getValueOrDefault(range, ordinalOrTag) {
    if (isEnumRange(range)) {
      try {
        return range.get(ordinalOrTag).getOrdinal();
      } catch (ignore) {
        return range.getOrdinals()[0];
      }
    } else {
      var keys = range.getKeys();
      for (var i = 0, len = keys.length; i < len; ++i) {
        var val = range.get(keys[i]);
        if (val.equivalent(ordinalOrTag)) {
          return val;
        }
      }
      return ordinalOrTag;
    }
  }
  function isEnumRange(obj) {
    return baja.hasType(obj, 'baja:EnumRange');
  }
  function isFacets(obj) {
    return baja.hasType(obj, 'baja:Facets');
  }
  return EnumEditor;
});
