function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/BooleanEditor
 */
define(['baja!', 'lex!baja', 'log!nmodule.webEditors.rc.fe.baja.BooleanEditor', 'bajaux/events', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, lexs, log, events, $, Promise, BaseEditor, IconEditor, fe, htmlUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bajaLex = _lexs[0];
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var escapeHtml = htmlUtils.escapeHtml;
  var logError = log.severe.bind(log);
  var widgetDefaults = function widgetDefaults() {
    return {
      keyName: 'BooleanEditor',
      properties: {
        displayType: 'auto',
        falseIcon: bajaLex.get('false.icon'),
        falseText: bajaLex.get('false'),
        trueIcon: bajaLex.get('true.icon'),
        trueText: bajaLex.get('true')
      }
    };
  };
  function doFormat(pattern) {
    return baja.Format.format({
      pattern: pattern
    });
  }

  /**
   * A field editor for working with booleans. It supports the following
   * properties:
   *
   * - `displayType`: set to "slider" or "checkbox" to force that display style,
   *   or leave as "auto" (the default) to use a slider unless trueText and
   *   falseText are the same, in which case a checkbox will be used. Also supports "radio"; since
   *   you will have multiple BooleanEditors in this case, also give them a common "name" property
   *   to ensure they group together.
   * - `falseIcon`: specify a `baja.Format`, `baja.Ord`, or string for an icon to use for the false value
   *   (`baja.Ord` or string; defaults to `redCircle.png`)
   * - `falseText`: specify the text for the false value (defaults to "false"
   *   from `baja` lexicon)
   * - `trueIcon`: specify a `baja.Format`, `baja.Ord`, or string for an icon to use for the true value
   *   (`baja.Ord` or string; defaults to `greenCircle.png`)
   * - `trueText`: specify the text for the true value (defaults to "true" from
   *   `baja` lexicon)
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/webEditors/rc/fe/baja/BooleanEditor
   */
  var BooleanEditor = function BooleanEditor(params) {
    BaseEditor.call(this, {
      params: params,
      defaults: widgetDefaults()
    });
  };
  BooleanEditor.prototype = Object.create(BaseEditor.prototype);
  BooleanEditor.prototype.constructor = BooleanEditor;

  /**
   * Compute the true/false display text to use from the `trueText` /
   * `falseText` facets.
   *
   * @private
   * @returns {Promise} promise to be resolved with an array containing two
   * strings for trueText/falseText
   */
  BooleanEditor.prototype.$getTrueFalseText = function () {
    var props = this.properties(),
      trueText = props.getValue('trueText'),
      falseText = props.getValue('falseText');
    return Promise.all([doFormat(trueText), doFormat(falseText)]);
  };

  /**
   * Compute the true/false icon to use.
   *
   * @private
   * @returns {Promise} promise to be resolved with an array containing two
   * strings for trueIcon/falseIcon
   */
  BooleanEditor.prototype.$getTrueFalseIcon = function () {
    var props = this.properties(),
      trueIcon = String(props.getValue('trueIcon')),
      falseIcon = String(props.getValue('falseIcon'));
    return Promise.all([doFormat(trueIcon), doFormat(falseIcon)]);
  };

  /**
   * Return the checkbox element.
   *
   * @private
   * @returns {JQuery}
   */
  BooleanEditor.prototype.$getCheckbox = function () {
    return this.jq().children('input');
  };

  /**
   * Update the current value of the display label with the `trueText` or
   * `falseText` facet, falling back to `true` and `false` from the `baja`
   * lexicon if either of those facets is not configured.
   * @private
   * @param {Boolean} value whether the the editor currently has true or false
   * loaded
   * @returns {Promise}
   */
  BooleanEditor.prototype.$updateLabel = function (value) {
    if (this.$getDisplayType() === 'slider') {
      return Promise.resolve();
    }
    var jq = this.jq();
    return this.$getTrueFalseText().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        trueText = _ref2[0],
        falseText = _ref2[1];
      jq.children('label').text(value ? trueText : falseText);
    });
  };

  /**
   * Creates a checkbox input.
   * @param {JQuery} dom
   */
  BooleanEditor.prototype.doInitialize = function (dom) {
    var _this = this;
    var id = this.generateId();
    dom.on('change', 'input', function () {
      _this.setModified(true);
      _this.read().then(function (value) {
        return _this.$updateLabel(value);
      })["catch"](logError);
    });
    dom.on(MODIFY_EVENT, '*', function () {
      _this.setModified(true);
      return false;
    });
    switch (this.$getDisplayType()) {
      case 'slider':
        dom.addClass('-t-booleanEditor-slider');
        dom.toggleClass('-t-booleanEditor-slider-transition', BooleanEditor.$supportsTransitionsWithFocus());
        return Promise.all([this.$getTrueFalseText(), this.$getTrueFalseIcon()]).then(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            _ref4$ = _slicedToArray(_ref4[0], 2),
            trueText = _ref4$[0],
            falseText = _ref4$[1],
            _ref4$2 = _slicedToArray(_ref4[1], 2),
            trueIcon = _ref4$2[0],
            falseIcon = _ref4$2[1];
          dom.html(tplSlider({
            id: id,
            trueText: trueText,
            falseText: falseText
          }));
          return Promise.all([fe.buildFor({
            dom: dom.find('.-t-booleanEditor-slider-falseIcon'),
            value: [falseIcon],
            type: IconEditor
          }), fe.buildFor({
            dom: dom.find('.-t-booleanEditor-slider-trueIcon'),
            value: [trueIcon],
            type: IconEditor
          })]);
        });
      case 'radio':
        dom.addClass('-t-booleanEditor-checkbox');
        dom.html(tplRadio({
          id: id,
          name: escapeHtml(this.properties().getValue('name') || id)
        }));
        break;
      case 'checkbox':
      default:
        dom.addClass('-t-booleanEditor-checkbox');
        dom.html(tplCheckbox({
          id: id
        }));
    }
  };

  /**
   * Checks or unchecks the checkbox to reflect the loaded value.
   * @param {Boolean} val
   * @returns {Promise}
   */
  BooleanEditor.prototype.doLoad = function (val) {
    this.$getCheckbox().prop('checked', !!val);
    return this.$updateLabel(val);
  };

  /**
   * Returns the checked/unchecked state of the checkbox.
   * @returns {Boolean} the boolean checked state of the checkbox
   */
  BooleanEditor.prototype.doRead = function () {
    return this.$getCheckbox().prop('checked');
  };
  BooleanEditor.prototype.doDestroy = function () {
    this.jq().removeClass('-t-booleanEditor-slider -t-booleanEditor-checkbox -t-booleanEditor-slider-transition');
    return this.getChildWidgets().destroyAll();
  };

  /**
   * Enables or disables the checkbox element.
   *
   * @param {Boolean} enabled
   */
  BooleanEditor.prototype.doEnabled = function (enabled) {
    this.$getCheckbox().prop('disabled', this.isReadonly() || !enabled);
    return this.getChildWidgets().setAllEnabled(enabled);
  };

  /**
   * Disables or enables the checkbox element.
   *
   * @param {Boolean} readonly
   */
  BooleanEditor.prototype.doReadonly = function (readonly) {
    this.$getCheckbox().prop('disabled', !this.isEnabled() || readonly);
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * @private
   * @returns {string} `checkbox` or `slider`
   */
  BooleanEditor.prototype.$getDisplayType = function () {
    var props = this.properties();
    var displayStyle = props.getValue('displayType') || 'auto';
    if (displayStyle === 'auto') {
      var trueText = props.getValue('trueText');
      var falseText = props.getValue('falseText');
      displayStyle = trueText === falseText ? 'checkbox' : 'slider';
    }
    return displayStyle;
  };

  /**
   * JavaFx bug: it will not paint CSS transitions resulting from an input click
   * until the mouse leaves.
   * @private
   * @returns {boolean}
   */
  BooleanEditor.$supportsTransitionsWithFocus = function () {
    return !isJavaFX();
  };
  function tplCheckbox(_ref5) {
    var id = _ref5.id;
    return "<input type=\"checkbox\" id=\"".concat(id, "\"><label for=\"").concat(id, "\"></label>");
  }
  function tplRadio(_ref6) {
    var id = _ref6.id,
      name = _ref6.name;
    return "<input type=\"radio\" id=\"".concat(id, "\" name=\"").concat(name, "\"><label for=\"").concat(id, "\"></label>");
  }
  function tplSlider(_ref7) {
    var id = _ref7.id,
      trueText = _ref7.trueText,
      falseText = _ref7.falseText;
    return "\n    <input type=\"checkbox\" id=\"".concat(id, "\">\n    <label class=\"-t-booleanEditor-slider-wrapper ux-border ux-select-none\" for=\"").concat(id, "\">\n      <span class=\"-t-booleanEditor-slider-spacer\">\n        <span class=\"-t-booleanEditor-slider-spacer-falseText\">").concat(escapeHtml(falseText), "</span>\n        <span class=\"-t-booleanEditor-slider-spacer-trueText\">").concat(escapeHtml(trueText), "</span>\n      </span>\n      <span class=\"-t-booleanEditor-slider-falseText\">").concat(escapeHtml(falseText), "</span>\n      <span class=\"-t-booleanEditor-slider-thumb ux-border\">\n        <span class=\"-t-booleanEditor-slider-falseIcon\"></span>\n        <span class=\"-t-booleanEditor-slider-trueIcon\"></span>\n      </span>\n      <span class=\"-t-booleanEditor-slider-trueText\">\n        <span class=\"-t-booleanEditor-slider-text\">").concat(escapeHtml(trueText), "</span>\n      </span>\n    </label>");
  }

  // TODO: it is past time to have an envUtils or similar
  function isJavaFX() {
    return !!navigator.userAgent.match(/JavaFX/);
  }
  return BooleanEditor;
});
