function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/baja/AdapterEditor
 */
define(['underscore', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor'], function (_, Promise, fe, BaseEditor) {
  'use strict';

  /**
   * Quite often, an editor for one type will essentially be the same as an
   * existing editor for another type, possibly with some extra configuration.
   * This class allows you to define an editor in terms of building another.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/baja/AdapterEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   */
  var AdapterEditor = /*#__PURE__*/function (_BaseEditor) {
    function AdapterEditor() {
      _classCallCheck(this, AdapterEditor);
      return _callSuper(this, AdapterEditor, arguments);
    }
    _inherits(AdapterEditor, _BaseEditor);
    return _createClass(AdapterEditor, [{
      key: "getCommandGroup",
      value:
      /**
       * @returns {module:bajaux/commands/CommandGroup} the commands of the adapted editor
       */
      function getCommandGroup() {
        var ed = this.$ed;
        return ed ? ed.getCommandGroup() : _superPropGet(AdapterEditor, "getCommandGroup", this, 3)([]);
      }

      /**
       * This method will provide the fe.makeFor config that defines what our
       * adapted editor looks like.
       *
       * @abstract
       * @param {*} value the value to load
       * @returns {object|Promise.<object>} a params object to be passed
       * to `fe.makeFor`. At minimum, `value` is required.
       *
       * @example
       * <caption>Create a string editor that allows the user to edit the string
       * as-is, but also provide an extra datalist of known good values.</caption>
       * toConfig(myString) {
       *   return getKnownGoodValues()
       *     .then((goodValues) => {
       *       return {
       *         value: myString,
       *         properties: { datalist: goodValues.join(';') }
       *       };
       *     });
       * }
       */
    }, {
      key: "toConfig",
      value: function toConfig(value) {
        throw new Error('not implemented');
      }

      /**
       * This method converts the adapted value back to the original type.
       *
       * @abstract
       * @param {*} readValue the value read from the converted editor
       * @param {module:bajaux/Widget} convertedEditor the converted editor
       * @returns {*|Promise.<*>} the value, converted back to the type originally
       * loaded in
       */
    }, {
      key: "toValue",
      value: function toValue(readValue, convertedEditor) {
        return readValue;
      }

      /**
       * Essentially a no-op. initialize() behavior is delegated to adapted editor in doLoad.
       * @since Niagara 4.14
       * @param {JQuery} dom
       * @returns {Promise}
       */
    }, {
      key: "initialize",
      value: function initialize(dom) {
        this.$jq = dom;
        return Promise.resolve(this.$resolveInit()); // we're done!
      }

      /**
       * Performs the work of initializing and loading the converted editor.
       *
       * @private
       * @param {*} value
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _this = this;
        return Promise.resolve(this.toConfig(value)).then(function (myConfig) {
          var convertedValue = myConfig.value;

          // by default, we will pass our own properties
          var defaultConfig = {
            properties: _this.properties().toValueMap(),
            formFactor: _this.getFormFactor(),
            enabled: _this.isEnabled(),
            readonly: _this.isReadonly()
          };
          return fe.makeFor(_.extend(defaultConfig, myConfig)).then(function (ed) {
            //hold onto a reference to use in doRead()...
            _this.$ed = ed;

            // (emptying it out each time because, doLoad can be called multiple
            // times)...
            var jq = ed.$jq = _this.jq().empty().off().removeData('widget');

            // we *have* to call initialize not doInitialize so DynamicSpandrelWidgets use the correct WidgetManager
            // otherwise <any> doesn't work (NCCB-62678)
            return Promise.resolve(ed.initialize(jq)).then(function () {
              return ed.$resolveInit();
            }).then(function () {
              // set widget data back from adapted editor, to this, to respect Widget semantics
              jq.data('widget', _this);
              return ed.load(convertedValue);
            });
          });
        });
      }

      /**
       * @private
       */
    }, {
      key: "$updateTypeClasses",
      value: function $updateTypeClasses() {
        // skip - the adapted editor will do its own classes
      }

      /**
       * Resolves the value, as read from the converted editor.
       * @returns {Promise.<*>} respective value
       */
    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;
        return this.$ed.read().then(function (convertedValue) {
          // here, convertedReadValue would be any primitive type, so convert it back to
          // the original type
          return _this2.toValue(convertedValue, _this2.$ed);
        });
      }

      /**
       * Sets the readonly state of the converted editor.
       * @param {boolean} readonly
       * @returns {Promise}
       */
    }, {
      key: "doReadonly",
      value: function doReadonly(readonly) {
        // ed will not be available for the first time when the property sheet loads,
        // so returning Promise.resolve().
        if (this.$ed) {
          return this.$ed.doReadonly(readonly);
        }
        return Promise.resolve();
      }

      /**
       * Sets the enabled state of the converted editor.
       * @param {boolean} enabled
       * @returns {Promise}
       */
    }, {
      key: "doEnabled",
      value: function doEnabled(enabled) {
        // ed will not be available for the first time when the property sheet loads,
        // so returning Promise.resolve().
        if (this.$ed) {
          return this.$ed.doEnabled(enabled);
        }
        return Promise.resolve();
      }

      /**
       * Delegates destruction to the converted editor.
       * @param {object} [params]
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy(params) {
        // ed will not be available for the first time when the property sheet loads,
        // so returning Promise.resolve().
        if (this.$ed) {
          return this.$ed.doDestroy(params);
        }
        return Promise.resolve();
      }

      /**
       * Delegates validation to the converted editor.
       * @returns {Promise}
       */
    }, {
      key: "validate",
      value: function validate() {
        var _this3 = this;
        var ed = this.$ed;
        return Promise.resolve(ed && ed.validate().then(function (innerValidValue) {
          return _this3.toValue(innerValidValue, ed);
        }));
      }

      /**
       * @returns {boolean}
       */
    }, {
      key: "isModified",
      value: function isModified() {
        if (_superPropGet(AdapterEditor, "isModified", this, 3)([])) {
          return true;
        }
        if (this.$ed) {
          return this.$ed.isModified();
        }
        return false;
      }
    }]);
  }(BaseEditor);
  return AdapterEditor;
});
