function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/JSONPropertySheet
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/fe/feUtils', 'nmodule/webEditors/rc/wb/PropertySheet'], function (baja, Promise, feUtils, PropertySheet) {
  'use strict';

  var ORIGINALLY_COMPLEX_FLAG = baja.Flags.USER_DEFINED_4;
  var getPickerConfig = feUtils.getPickerConfig;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        showHeader: false,
        showControls: false,
        readBehavior: 'copy'
      }
    };
  };

  /**
   * PropertySheet implementation whose purpose is to load and read plain JSON data instead of
   * Components.
   *
   * See {@link module:nmodule/webEditors/rc/fe/feDialogs.props} for a description of the required
   * JSON structure.
   *
   * @class
   * @alias module:nmodule/webEditors/rc/fe/JSONPropertySheet
   * @extends module:nmodule/webEditors/rc/wb/PropertySheet
   */
  var JSONPropertySheet = /*#__PURE__*/function (_PropertySheet) {
    function JSONPropertySheet(params) {
      _classCallCheck(this, JSONPropertySheet);
      return _callSuper(this, JSONPropertySheet, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * Load in a JSON value. Can also load a Complex directly.
     *
     * @param {object|baja.Complex} json
     * @param {*} [params]
     * @returns {*|Promise<*>}
     */
    _inherits(JSONPropertySheet, _PropertySheet);
    return _createClass(JSONPropertySheet, [{
      key: "load",
      value: function load(json, params) {
        var _this = this;
        var isComplex = baja.hasType(json, 'baja:Complex');
        this.$loadedComplex = isComplex;
        this.jq().toggleClass('-t-JSONPropertySheet-json', !isComplex);
        return toBajaValue(json).then(function (complex) {
          return _superPropGet(JSONPropertySheet, "load", _this, 3)([complex, params]);
        });
      }
    }, {
      key: "doRead",
      value: function doRead() {
        var _this2 = this;
        return _superPropGet(JSONPropertySheet, "doRead", this, 3)(arguments).then(function (result) {
          if (_this2.$loadedComplex) {
            return result;
          } else {
            return toObjectLiteral(result);
          }
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('-t-JSONPropertySheet-json');
        return _superPropGet(JSONPropertySheet, "doDestroy", this, 3)(arguments);
      }
    }]);
  }(PropertySheet);
  /**
   * @param {baja.Value|object} json either a raw JSON object, or a baja.Value
   * @returns {Promise.<baja.Value>} promise to a baja.Value defined by the input JSON, to be loaded
   * into a PropertySheet or one of its rows
   */
  function toBajaValue(json) {
    if (baja.hasType(json)) {
      return Promise.resolve(json);
    }
    var keys = Object.keys(json);
    return Promise.all(keys.map(function (key) {
      var val = json[key];
      var displayName;
      var value;
      var flags = 0;
      var properties;
      var pickerConfig;
      if (baja.hasType(val)) {
        flags |= ORIGINALLY_COMPLEX_FLAG;
        value = val;
      } else if (!('value' in val)) {
        return Promise.reject(new Error('nested object literals must be applied as "value" attribute'));
      } else {
        displayName = val.displayName;
        if (val.hidden) {
          flags |= baja.Flags.HIDDEN;
        }
        if (val.readonly) {
          flags |= baja.Flags.READONLY;
        }
        value = toBajaValue(val.value);
        properties = val.properties;
        pickerConfig = getPickerConfig(val);
      }
      return Promise.all([value, displayName && baja.Format.format(displayName), pickerConfig]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 3),
          value = _ref2[0],
          displayName = _ref2[1],
          pickerConfig = _ref2[2];
        if (pickerConfig) {
          properties = pickerConfig.properties;
        }
        return {
          displayName: displayName,
          key: key,
          flags: flags,
          properties: properties,
          value: value
        };
      });
    })).then(function (results) {
      var comp = baja.$('baja:Component');
      results.forEach(function (_ref3) {
        var displayName = _ref3.displayName,
          key = _ref3.key,
          flags = _ref3.flags,
          properties = _ref3.properties,
          value = _ref3.value;
        var slot = baja.SlotPath.escape(key);
        var facets = baja.Facets.make(Object.assign({
          alwaysExpand: true
        }, properties));
        comp.add({
          slot: slot,
          value: value,
          facets: facets,
          flags: flags,
          cx: {
            displayName: displayName
          }
        });
      });
      return comp;
    });
  }

  /**
   * @param {baja.Complex} comp
   * @returns {object} JSON object that reflects the currently-entered values and is compatible
   * with the JSON Object originally loaded
   */
  function toObjectLiteral(comp) {
    var obj = {};
    comp.getSlots().toArray().forEach(function (slot) {
      var val = comp.get(slot);
      if (baja.hasType(val, 'baja:Complex') && (comp.getFlags(slot) & ORIGINALLY_COMPLEX_FLAG) === 0) {
        obj[slot] = toObjectLiteral(val);
      } else {
        obj[slot] = val;
      }
    });
    return obj;
  }
  return JSONPropertySheet;
});
