/*
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */
/*jshint browser: true*//* eslint-env browser */

/**
 * @module nmodule/web/rc/util/speedTest
 */
(function () {
  'use strict';

  var results = {};

  var csrfToken = null;
  var csrfTokenElem = document.getElementById("csrfToken");

  if (csrfTokenElem !== null) {
    csrfToken = encodeURIComponent(csrfTokenElem.value);
  } else {
    document.getElementById('latency', 'Error: CSRF Token unavailable');
  }

  function showLoading(name) {
    var elem = document.getElementById(name);
    if (elem) {
      if (elem.textContent.indexOf(" ") > -1) { //test complete
        return;
      }

      elem.textContent += "-";
      if (elem.textContent.length > 5) {
        elem.textContent = "-";
      }

      setTimeout(function () {
        showLoading(name);
      }, 500);
    }
  }

  function setResults(now, name, size) {
    var duration = new Date() - now,
      text;

    var elem = document.getElementById(name);
    results[name] = duration;
    if (name === "latency") {

      if (elem) {
        text = duration.toLocaleString() + " ms";
      }
    } else {
      var mbps = size / (duration) / 1000.0;
      text = mbps.toLocaleString() + " Mbps";
    }

    if (elem) {
      elem.textContent = text;
    }
  }

  /**
   * Starts the downloadTest
   */
  function startLatencyTest() {
    var now = new Date();
    var msg = new Message();

    showLoading("latency");
    var uri = '/niagaraSpeedTest/latency.gz?unique=' + new Date();
    msg.send(uri, "", function (xmlhttp) {
      setResults(now, "latency", xmlhttp.responseText.length * 8);
      showLoading("download");      
      startDownloadTest();      
    });
  }

  function startDownloadTest() {

    var now = new Date(),
      msg = new Message();
    //.gz extension prevents GzipServletOutputStream from zipping even if gzip is turned on
    var uri = '/niagaraSpeedTest/download/test.gz?unique' + new Date();
    msg.send(uri, "", function (xmlhttp) {
      setResults(now, "download", xmlhttp.responseText.length * 8);
      showLoading("upload");
      startUploadTest(xmlhttp.responseText);
    });
  }

  function startUploadTest(body) {

    var now = new Date();
    var msg = new Message();
    var uri = '/niagaraSpeedTest/upload';
    msg.send(uri, body, function () {
      setResults(now, "upload", (body.length * 8));
      if (window.speedTestResults) {
        startResults();
      }
    });
  }

  function startResults() {

    var msg = new Message();
    var uri = '/niagaraSpeedTest/results';
    msg.send(uri, JSON.stringify(results), function (xmlhttp) {
    });
  }

  function startTests() {
    startLatencyTest();
  }

  function Message() {
    var headers = [ { name: 'x-niagara-csrfToken', value: csrfToken } ];
    var responseHandler = null;
    var xmlhttp = new XMLHttpRequest();

    /**
     * Send a message.
     */
    this.send = function (url, body, handler) {
      try {
        responseHandler = handler;
        xmlhttp.open(body.length ? "post" : "get", url, true);
        for (var i = 0; i < headers.length; i++) {
          var header = headers[i];
          xmlhttp.setRequestHeader(header.name, header.value);
        }

        xmlhttp.onreadystatechange = this.handleResponse;
        xmlhttp.send(body);
      } catch (err) {
        window.console.log("Message error", err);
      }
    };

    /**
     * Handle request response.
     */
    this.handleResponse = function () {
      try {
        if (xmlhttp.readyState === 4) {
          if (xmlhttp.status !== 200) {
            var text = xmlhttp.responseText;
            if (text.length === 0) {
              text = "zero size";
            }
          } else if (responseHandler !== null) {
            responseHandler(xmlhttp);
          }
          xmlhttp.onreadystatechange = function () {
          };
          xmlhttp = null;
        }
      } catch (err) {
        window.console.log("catch:" + err);
        xmlhttp.onreadystatechange = function () {
        };
        xmlhttp = null;
      }
    };
  }

  startTests();
}());
