function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @since Niagara 4.3
 * @module nmodule/control/rc/fe/IntervalTriggerModeEditor
 */
define(['baja!', 'baja!control:IntervalTriggerMode', 'bajaux/events', 'hbs!nmodule/control/rc/fe/templates/IntervalTriggerModeEditor', 'lex!control', 'nmodule/control/rc/baja/IntervalTriggerMode', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'Promise'], function (baja, types, events, template, lexs, IntervalTriggerMode, CompositeEditor, CompositeBuilder, Promise) {
  'use strict';

  var controlLex = lexs[0],
    daysOfWeekLexEntry = controlLex.get({
      key: 'trigger.daysOfWeek',
      def: 'Days Of Week'
    }),
    disabledLexEntry = controlLex.get({
      key: 'trigger.disabled',
      def: 'Disabled'
    }),
    enabledLexEntry = controlLex.get({
      key: 'trigger.enabled',
      def: 'Enabled'
    }),
    endTimeLexEntry = controlLex.get({
      key: 'trigger.endTime',
      def: 'End Time'
    }),
    intervalLexEntry = controlLex.get({
      key: 'trigger.interval',
      def: 'Interval'
    }),
    startTimeLexEntry = controlLex.get({
      key: 'trigger.startTime',
      def: 'Start Time'
    }),
    timeOfDayLexEntry = controlLex.get({
      key: 'trigger.timeOfDay',
      def: 'Time Of Day'
    }),
    MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * Field editor for working with `control:IntervalTriggerMode` instances.
   * The following boolean can be passed as a property in the arguments.
   * --properties.showDay if set to true the IntervalTriggerModeEditor will show days
   *    as well as hours in the ReltimeEditor -- Since Niagara 4.14
   * @class
   * @alias module:nmodule/control/rc/fe/IntervalTriggerModeEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var IntervalTriggerModeEditor = function IntervalTriggerModeEditor() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    CompositeEditor.apply(this, arguments);
  };
  IntervalTriggerModeEditor.prototype = Object.create(CompositeEditor.prototype);
  IntervalTriggerModeEditor.prototype.constructor = IntervalTriggerModeEditor;

  /**
   * Initialize the `IntervalTriggerModeEditor`.
   *
   * @param {jQuery} dom
   * @returns {Promise}
   */
  IntervalTriggerModeEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(template({
      daysOfWeekLabel: daysOfWeekLexEntry,
      endTimeLabel: endTimeLexEntry,
      intervalLabel: intervalLexEntry,
      startTimeLabel: startTimeLexEntry,
      timeOfDayLabel: timeOfDayLexEntry
    }));
    dom.on(MODIFY_EVENT, '.key-rangeEnabled', function (e, ed) {
      ed.read().then(function (rangeEnabled) {
        return Promise.all([that.$getStartTimeEditor().setEnabled(rangeEnabled), that.$getEndTimeEditor().setEnabled(rangeEnabled)]);
      })["catch"](baja.error);
    });
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * The builder for `IntervalTriggerModeEditor` will create the following
   * editors for:
   *
   *   interval:     `RelTimeEditor`
   *   rangeEnabled: `BooleanEditor`
   *   startTime:    `TimeEditor`
   *   endTime:      `TimeEditor`
   *   daysOfWeek:   `DaysOfWeekBitsEditor`
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  IntervalTriggerModeEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['daysOfWeek', 'endTime', 'interval', 'rangeEnabled', 'startTime'];
    };
    builder.getDomFor = function (key) {
      return that.jq().find('.key-' + key);
    };
    builder.getValueFor = function (key) {
      var itm = this.getDataSource();
      switch (key) {
        case 'daysOfWeek':
          return itm.getDaysOfWeek();
        case 'endTime':
          return itm.getEndTime();
        case 'interval':
          return itm.getInterval();
        case 'rangeEnabled':
          return itm.isRangeEnabled();
        case 'startTime':
          return itm.getStartTime();
      }
    };
    builder.getConfigFor = function (key) {
      var config = {
        formFactor: 'mini'
      };
      switch (key) {
        case 'rangeEnabled':
          config.properties = {
            trueText: enabledLexEntry,
            falseText: disabledLexEntry
          };
          break;
        case 'interval':
          // get the properties, if not properties set the default values
          var props = that.properties();
          var showDays = props.getValue("showDays") || false;
          var min = props.getValue("min") || baja.RelTime.make(1);
          var max = props.getValue("max");
          config.properties = {
            min: min,
            max: max,
            shouldValidate: true,
            showDay: showDays
          };
          break;
      }
      return config;
    };
    return builder;
  };

  /**
   * Load the `interval`, `rangeEnabled`, `startTime`, `endTime`, and
   * `daysOfWeek` of the `IntervalTriggerMode` into the appropriate child
   * editors.
   *
   * @param {module:nmodule/control/rc/baja/IntervalTriggerMode} intervalTriggerMode
   * @returns {Promise}
   */
  IntervalTriggerModeEditor.prototype.doLoad = function (intervalTriggerMode) {
    var that = this,
      rangeEnabled = intervalTriggerMode.isRangeEnabled();
    return CompositeEditor.prototype.doLoad.apply(this, arguments).then(function () {
      return Promise.all([that.$getStartTimeEditor().setEnabled(rangeEnabled), that.$getEndTimeEditor().setEnabled(rangeEnabled)]);
    });
  };

  /**
   * Read a new `IntervalTriggerMode` with current values of `interval`,
   * `rangeEnabled`, `startTime`, `endTime`, and `daysOfWeek`.
   *
   * @returns {Promise}
   */
  IntervalTriggerModeEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 5),
        daysOfWeek = _ref2[0],
        endTime = _ref2[1],
        interval = _ref2[2],
        rangeEnabled = _ref2[3],
        startTime = _ref2[4];
      return IntervalTriggerMode.make({
        daysOfWeek: daysOfWeek,
        endTime: endTime,
        interval: interval,
        rangeEnabled: rangeEnabled,
        startTime: startTime
      });
    });
  };
  IntervalTriggerModeEditor.prototype.$getDaysOfWeekEditor = function () {
    return this.getBuilder().getEditorFor('daysOfWeek');
  };
  IntervalTriggerModeEditor.prototype.$getDaysOfWeekLabel = function () {
    return this.jq().find('.daysOfWeekLabel').text();
  };
  IntervalTriggerModeEditor.prototype.$getEndTimeEditor = function () {
    return this.getBuilder().getEditorFor('endTime');
  };
  IntervalTriggerModeEditor.prototype.$getEndTimeLabel = function () {
    return this.jq().find('.endTimeLabel').text();
  };
  IntervalTriggerModeEditor.prototype.$getIntervalEditor = function () {
    return this.getBuilder().getEditorFor('interval');
  };
  IntervalTriggerModeEditor.prototype.$getIntervalLabel = function () {
    return this.jq().find('.intervalLabel').text();
  };
  IntervalTriggerModeEditor.prototype.$getRangeEnabledEditor = function () {
    return this.getBuilder().getEditorFor('rangeEnabled');
  };
  IntervalTriggerModeEditor.prototype.$getStartTimeEditor = function () {
    return this.getBuilder().getEditorFor('startTime');
  };
  IntervalTriggerModeEditor.prototype.$getStartTimeLabel = function () {
    return this.jq().find('.startTimeLabel').text();
  };
  IntervalTriggerModeEditor.prototype.$getTimeOfDayLabel = function () {
    return this.jq().find('.timeOfDayLabel').text();
  };
  return IntervalTriggerModeEditor;
});
