function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @since Niagara 4.3
 * @module nmodule/control/rc/fe/DailyTriggerModeEditor
 */
define(['baja!control:DailyTriggerMode', 'hbs!nmodule/control/rc/fe/templates/DailyTriggerModeEditor', 'lex!control', 'nmodule/control/rc/baja/DailyTriggerMode', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'Promise'], function (types, template, lexs, DailyTriggerMode, CompositeEditor, CompositeBuilder, Promise) {
  'use strict';

  var controlLex = lexs[0],
    daysOfWeekLexEntry = controlLex.get({
      key: 'trigger.daysOfWeek',
      def: 'Days Of Week'
    }),
    randomizationLexEntry = controlLex.get({
      key: 'trigger.randomization',
      def: 'Randomization'
    }),
    timeOfDayLexEntry = controlLex.get({
      key: 'trigger.timeOfDay',
      def: 'Time Of Day'
    });

  /**
   * Field editor for working with `control:DailyTriggerMode` instances.
   *
   * @class
   * @alias module:nmodule/control/rc/fe/DailyTriggerModeEditor
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */
  var DailyTriggerModeEditor = function DailyTriggerModeEditor() {
    CompositeEditor.apply(this, arguments);
  };
  DailyTriggerModeEditor.prototype = Object.create(CompositeEditor.prototype);
  DailyTriggerModeEditor.prototype.constructor = DailyTriggerModeEditor;

  /**
   * Initialize the `DailyTriggerModeEditor`.
   *
   * @param {jQuery} dom
   * @returns {Promise}
   */
  DailyTriggerModeEditor.prototype.doInitialize = function (dom) {
    dom.html(template({
      daysOfWeekLabel: daysOfWeekLexEntry,
      randomizationLabel: randomizationLexEntry,
      timeOfDayLabel: timeOfDayLexEntry
    }));
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * The builder for `DailyTriggerModeEditor` will create the following
   * editors for:
   *
   *   timeOfDay:     `TimeEditor`
   *   randomization: `RelTimeEditor`
   *   daysOfWeek:    `DaysOfWeekBitsEditor`
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  DailyTriggerModeEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['daysOfWeek', 'randomization', 'timeOfDay'];
    };
    builder.getDomFor = function (key) {
      return that.jq().find('.key-' + key);
    };
    builder.getValueFor = function (key) {
      var dtm = this.getDataSource();
      switch (key) {
        case 'daysOfWeek':
          return dtm.getDaysOfWeek();
        case 'randomization':
          return dtm.getRandomization();
        case 'timeOfDay':
          return dtm.getTimeOfDay();
      }
    };
    builder.getConfigFor = function (key) {
      var config = {
        formFactor: 'mini'
      };
      var props = that.properties();
      var showDays = props.getValue("showDays") || false;
      config.properties = {
        showDay: showDays
      };
      return config;
    };
    return builder;
  };

  /**
   * Load the `timeOfDay`, `randomization`, and `daysOfWeek` of the
   * `DailyTriggerMode` into the appropriate child editors.
   *
   * @param {module:nmodule/control/rc/baja/DailyTriggerMode} intervalTriggerMode
   * @returns {Promise}
   */
  DailyTriggerModeEditor.prototype.doLoad = function (intervalTriggerMode) {
    return CompositeEditor.prototype.doLoad.apply(this, arguments);
  };

  /**
   * Read a new `DailyTriggerMode` with current values of `timeOfDay`,
   * `randomization`, and `daysOfWeek`.
   *
   * @returns {Promise}
   */
  DailyTriggerModeEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        daysOfWeek = _ref2[0],
        randomization = _ref2[1],
        timeOfDay = _ref2[2];
      return DailyTriggerMode.make({
        daysOfWeek: daysOfWeek,
        randomization: randomization,
        timeOfDay: timeOfDay
      });
    });
  };
  DailyTriggerModeEditor.prototype.$getDaysOfWeekEditor = function () {
    return this.getBuilder().getEditorFor('daysOfWeek');
  };
  DailyTriggerModeEditor.prototype.$getDaysOfWeekLabel = function () {
    return this.jq().find('.daysOfWeekLabel').text();
  };
  DailyTriggerModeEditor.prototype.$getRandomizationEditor = function () {
    return this.getBuilder().getEditorFor('randomization');
  };
  DailyTriggerModeEditor.prototype.$getRandomizationLabel = function () {
    return this.jq().find('.randomizationLabel').text();
  };
  DailyTriggerModeEditor.prototype.$getTimeOfDayEditor = function () {
    return this.getBuilder().getEditorFor('timeOfDay');
  };
  DailyTriggerModeEditor.prototype.$getTimeOfDayLabel = function () {
    return this.jq().find('.timeOfDayLabel').text();
  };
  return DailyTriggerModeEditor;
});
