function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/wb/commands/DisposeJobCommand
 * @since Niagara 4.14
 */
define(['baja!', 'lex!batchJob', 'dialogs', 'underscore', 'Promise', 'nmodule/webEditors/rc/wb/job/commands/JobCommand'], function (baja, lexs, dialogs, _, Promise, JobCommand) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    batchJobLex = _lexs[0];
  function isDeviceJobComplete(job) {
    var stateTag = job && job.get('jobState').getTag();
    return stateTag === "success" || stateTag === "canceled" || stateTag === "failed";
  }

  /**
   * Command to dispose/delete a completed job.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/wb/job/commands/JobCommand
   * @alias module:nmodule/batchJob/rc/wb/commands/DisposeJobCommand
   * @param {baja.Complex|Array.<baja.Complex>} job baja:Job or a batchJob:IBatchJobSummary object
   */
  var DisposeJobCommand = /*#__PURE__*/function (_JobCommand) {
    function DisposeJobCommand(job) {
      var _this;
      _classCallCheck(this, DisposeJobCommand);
      var jobList = Array.isArray(job) ? job : [job];
      _this = _callSuper(this, DisposeJobCommand, [jobList, {
        module: 'batchJob',
        displayName: batchJobLex.get("BatchJobList.disposeCommand.label"),
        lex: 'BatchJobList.disposeCommand',
        func: function func() {
          return _this.$disposeJob(_this.getJobs());
        }
      }]);
      _this.setEnabled(_this.$isComplete());
      return _this;
    }

    /**
     * @private
     * @returns {boolean} 
     */
    _inherits(DisposeJobCommand, _JobCommand);
    return _createClass(DisposeJobCommand, [{
      key: "$isComplete",
      value: function $isComplete() {
        var job = this.getJobs();
        return job && job.every(isDeviceJobComplete);
      }
      /**
       * Disposes a Job
       *
       * @private
       * @param {Array.<baja.Complex>} jobList
       * @returns {Promise}
       */
    }, {
      key: "$disposeJob",
      value: function $disposeJob(jobList) {
        return dialogs.showOkCancel({
          title: batchJobLex.get('BatchJobList.disposeCommand.dlgTitle'),
          text: batchJobLex.get('BatchJobList.disposeCommand.dlgMessage')
        }).ok(function () {
          return baja.Ord.make("service:batchJob:BatchJobService").get().then(function (batchJobService) {
            return Promise.all(jobList.map(function (job) {
              var jobStartTime = baja.hasType(job, 'batchJob:IBatchJobSummary') ? job.getTimestamp() : job.getStartTime();
              return batchJobService.disposeJob(jobStartTime);
            }));
          });
        }).cancel(function () {
          return Promise.resolve(null);
        }).promise();
      }
    }]);
  }(JobCommand);
  return DisposeJobCommand;
});
