function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/wb/DeviceNetworkUxJobView
 */

define(['baja!', 'lex!batchJob', 'Promise', 'underscore', 'bajaux/commands/CommandGroup', 'bajaux/mixin/subscriberMixIn', 'bajaux/spandrel', 'bajaux/util/CommandButtonGroup', 'bajaux/Widget', 'nmodule/batchJob/rc/util/TimestampPropertyColumn', 'nmodule/batchJob/rc/wb/columns/HyperlinkToLogFileColumn', 'nmodule/batchJob/rc/wb/commands/CancelDeviceCommand', 'nmodule/batchJob/rc/wb/commands/CancelJobCommand', 'nmodule/batchJob/rc/wb/commands/DisposeJobCommand', 'nmodule/batchJob/rc/wb/commands/ViewJobListCommand', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/job/commands/ViewLogCommand', 'nmodule/webEditors/rc/wb/job/jobSupport', 'nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/model/Row', 'nmodule/webEditors/rc/wb/table/Table', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/model/columns/IconColumn', 'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn', 'css!nmodule/batchJob/rc/batchJob'], function (baja, lexs, Promise, _, CommandGroup, subscriberMixIn, spandrel, CommandButtonGroup, Widget, TimestampPropertyColumn, HyperlinkToLogFileColumn, CancelDeviceCommand, CancelJobCommand, DisposeJobCommand, ViewJobListCommand, DepthSubscriber, ExportCommand, ViewLogCommand, jobSupport, DefaultTableContextMenu, Column, Row, Table, TableModel, IconColumn, PropertyColumn) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    batchJobLex = _lexs[0];
  var ROW_SELECTION_CHANGED_EVENT = Table.ROW_SELECTION_CHANGED_EVENT;
  var DEVICE_LABEL = batchJobLex.get("DeviceNetworkJobView.col.device");
  var TYPE_LABEL = batchJobLex.get("DeviceNetworkJobView.col.type");
  var START_LABEL = batchJobLex.get("DeviceNetworkJobView.col.start");
  var END_LABEL = batchJobLex.get("DeviceNetworkJobView.col.end");
  var READONLY = Column.flags.READONLY;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-DeviceNetworkUxJobView ux-fullscreen'
      }
    };
  };
  function getStageSteps(stage, stepTypeFilter) {
    var steps = stage.get('steps');
    return steps && steps.getSlots().properties().is(stepTypeFilter).toValueArray() || [];
  }
  function getDeviceDetails(step, deviceStepFilter, networkStepFilter) {
    return step && step.getSlots().toValueArray().filter(function (val) {
      return val.getType().is(networkStepFilter) || val.getType().is(deviceStepFilter);
    }) || [];
  }

  /**
   * A specialized DefaultTableContextMenu that only adds the Export Command
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/table/menu/DefaultTableContextMenu
   */
  var ExportOnlyTableContextMenu = /*#__PURE__*/function (_DefaultTableContextM) {
    function ExportOnlyTableContextMenu() {
      _classCallCheck(this, ExportOnlyTableContextMenu);
      return _callSuper(this, ExportOnlyTableContextMenu, arguments);
    }
    _inherits(ExportOnlyTableContextMenu, _DefaultTableContextM);
    return _createClass(ExportOnlyTableContextMenu, [{
      key: "toContextMenu",
      value: function toContextMenu() {
        return new CommandGroup({
          commands: [new ExportCommand(this.$table)]
        });
      }
    }]);
  }(DefaultTableContextMenu);
  /**
   * 
   * @inner
   * @class
   * @extends module:nmodule/webEditors/rc/wb/table/Table
   */
  var TableWithMenu = /*#__PURE__*/function (_Table) {
    function TableWithMenu() {
      var _this;
      _classCallCheck(this, TableWithMenu);
      _this = _callSuper(this, TableWithMenu, arguments);
      DefaultTableContextMenu.mixin(_this, {
        ctor: ExportOnlyTableContextMenu
      });
      return _this;
    }
    _inherits(TableWithMenu, _Table);
    return _createClass(TableWithMenu);
  }(Table);
  /**
   * @since Niagara 4.14
   * @class
   * @alias module:nnmodule/batchJob/rc/wb/DeviceNetworkUxJobView
   * @extends {module:bajaux/spandrel}
   */
  return /*#__PURE__*/function (_spandrel) {
    function DeviceNetworkUxJobView(params) {
      var _this2;
      _classCallCheck(this, DeviceNetworkUxJobView);
      _this2 = _callSuper(this, DeviceNetworkUxJobView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this2.$subscriber = new DepthSubscriber(Number.MAX_VALUE);
      _this2.$subscriber.attach('changed added removed', function () {
        return _this2.rerender();
      });
      subscriberMixIn(_this2);
      return _this2;
    }

    /**
     * Return true if the given job is currently in the running state.
     *
     * @param {baja.Component} job
     * @returns {boolean}
     */
    _inherits(DeviceNetworkUxJobView, _spandrel);
    return _createClass(DeviceNetworkUxJobView, [{
      key: "isRunning",
      value: function isRunning(job) {
        return job && job.get('jobState').getTag() === 'running';
      }

      /**
       * Subclasses should override this method with one that returns an Ord
       * w/ViewQuery that will navigate to an appropriate BatchJobList for this
       * job
       */
    }, {
      key: "getJobListOrd",
      value: function getJobListOrd() {
        throw new Error('getJobListOrd() is not implemented.');
      }

      /**
       * @private
       * @param {baja.Component} job
       * @returns {Promise.<Object>} Promise resolved with object containing model and progressInfo
       */
    }, {
      key: "$buildDeviceStepDetails",
      value: function $buildDeviceStepDetails(job) {
        var columns = this.$buildTableCols();
        var deviceJobStepDetails = this.$loadDeviceJobStepDetails(job);
        var rows = deviceJobStepDetails.map(function (detail) {
          return new Row(detail);
        });
        return this.$getProgressInfo(job).then(function (progressInfo) {
          return {
            progressInfo: progressInfo,
            model: new TableModel({
              rows: rows,
              columns: columns
            })
          };
        });
      }

      /**
       * @private
       * @returns {Array<module:nmodule/webEditors/rc/wb/table/model/Column>}
       */
    }, {
      key: "$buildTableCols",
      value: function $buildTableCols() {
        var iconCol = new IconColumn('icon');
        iconCol.getValueFor = function (row) {
          return baja.Icon.make(jobSupport.stateToIconOrd(row.getSubject().get('state')));
        };
        var deviceCol = new PropertyColumn('deviceDisplayName', {
          displayName: DEVICE_LABEL,
          flags: READONLY,
          getDefaultValue: _.constant(batchJobLex.get("DeviceNetworkJobView.col.device.none"))
        });
        var typeCol = new PropertyColumn('stepDescription', {
          displayName: TYPE_LABEL,
          flags: READONLY
        });
        var startCol = new TimestampPropertyColumn('startTime', {
          displayName: START_LABEL,
          flags: READONLY
        });
        var endCol = new TimestampPropertyColumn('endTime', {
          displayName: END_LABEL,
          flags: READONLY
        });
        var statusCol = new PropertyColumn('state', {
          flags: READONLY
        });
        return [iconCol, deviceCol, typeCol, startCol, endCol, statusCol, new HyperlinkToLogFileColumn('hyperlink')];
      }

      /**
       * @private
       * @param {module:nmodule/webEditors/rc/wb/table/Table} table
       */
    }, {
      key: "$setCancelDeviceCommandEnabled",
      value: function $setCancelDeviceCommandEnabled(table) {
        var rows = table.getModel().getRows(),
          selectedRows = table.getSelectedRows();
        var selectedRow = selectedRows && selectedRows.length > 0 && selectedRows[0].getSubject();
        if (selectedRow) {
          var deviceState = selectedRow.getState();
          var isInProgress = true;
          if (selectedRow.getType().is('batchJob:DeviceStepDetails')) {
            if (this.$isDeviceJobComplete(deviceState) || deviceState.getTag() === "canceling") {
              isInProgress = false;
            }
          } else {
            isInProgress = false;
          }
          var cancelDeviceCmdEnabled = selectedRows && selectedRows.length === 1 && rows.length > 1 && isInProgress;
          this.$getCancelDeviceCommand().setEnabled(cancelDeviceCmdEnabled);
        }
      }

      /**
       * @private
       * @returns {module:nmodule/batchJob/rc/wb/commands/CancelDeviceCommand}
       */
    }, {
      key: "$getCancelDeviceCommand",
      value: function $getCancelDeviceCommand() {
        return this.$commands.findCommand(CancelDeviceCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/provisioningNiagara/rc/wb/commands/ViewJobListCommand}
       */
    }, {
      key: "$getViewJobListCommand",
      value: function $getViewJobListCommand() {
        return this.$commands.findCommand(ViewJobListCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/provisioningNiagara/rc/wb/commands/CancelJobCommand}
       */
    }, {
      key: "$getCancelJobCommand",
      value: function $getCancelJobCommand() {
        return this.$commands.findCommand(CancelJobCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/provisioningNiagara/rc/wb/commands/ViewLogCommand}
       */
    }, {
      key: "$getViewLogCommand",
      value: function $getViewLogCommand() {
        return this.$commands.findCommand(ViewLogCommand);
      }

      /**
       * @private
       * @returns {module:nmodule/provisioningNiagara/rc/wb/commands/DisposeJobCommand}
       */
    }, {
      key: "$getDisposeJobCommand",
      value: function $getDisposeJobCommand() {
        return this.$commands.findCommand(DisposeJobCommand);
      }

      /**
       * Returns all steps of intial stage
       * @param {baja.Component} job
       * @returns {Array}
       */
    }, {
      key: "$getAllInitialSteps",
      value: function $getAllInitialSteps(job) {
        var jobStages = job.getStages(),
          initialStage = jobStages && jobStages.get("initial");
        return initialStage && getStageSteps(initialStage, 'batchJob:NetworkJobStep') || [];
      }

      /**
       * Returns all steps of forEachStation stage
       * @param {baja.Component} job
       * @returns {Array}
       */
    }, {
      key: "$getAllForEachStationSteps",
      value: function $getAllForEachStationSteps(job) {
        var jobStages = job.getStages();
        var forEachStationStage = jobStages && jobStages.get("forEachStation");
        return forEachStationStage && getStageSteps(forEachStationStage, 'batchJob:DeviceJobStep') || [];
      }

      /**
       * @param {baja.Component} jobSteps
       * @returns {Array}
       */
    }, {
      key: "$getSteps",
      value: function $getSteps(jobSteps) {
        var steps = [];
        jobSteps.forEach(function (step) {
          if (step.get("ExcludeFromProgress") === null) {
            steps.push({
              status: ""
            });
          }
        });
        return steps;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/Table}
       */
    }, {
      key: "$getTable",
      value: function $getTable() {
        return this.queryWidget('jobView/*/jobTable');
      }

      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */
    }, {
      key: "$getCommandGroup",
      value: function $getCommandGroup() {
        return this.queryWidget('commandContainer/commands');
      }

      /**
       * @private
       * @returns {bajaux/Widget} returns the grid container
       */
    }, {
      key: "$getGridContainer",
      value: function $getGridContainer() {
        return Widget["in"](this.jq().find('.-t-DeviceNetworkUxJobView-grid-container'));
      }

      /**
       *
       * @param {baja.Component} job
       * @returns {Object} an object containing the total and completed number of steps
       */
    }, {
      key: "$getProgressInfo",
      value: function $getProgressInfo(job) {
        var _this3 = this;
        var progressInfo = {};
        progressInfo.completedSteps = 0;
        progressInfo.totalSteps = 0;
        var allSteps = {};
        var jobStages = job.getStages().getSlots().toValueArray();
        var initialSteps = this.$getAllInitialSteps(job);
        var forEachStationSteps = this.$getAllForEachStationSteps(job);
        var devices;
        jobStages.forEach(function (stage) {
          //Create initial data structure for job steps
          //Ex : If there are 2 stations and 2 stages then the data structure will be
          // allSteps = {"initial" : {"initial": [{status: ""}]}, "forEachStation": {"station1": [{status: ""},
          // {status: ""}],"station2": [{status: ""}, {status: ""}]
          var stageSteps = {};
          var stageName = stage.get('stageName');
          if (stage.getType().is('batchJob:NetworkJobStage')) {
            var steps = _this3.$getSteps(initialSteps);
            progressInfo.totalSteps += steps.length;
            stageSteps[stageName] = steps;
          } else if (stage.getType().is('batchJob:ForEachDeviceStage')) {
            var _steps = _this3.$getSteps(forEachStationSteps);
            if (!_this3.isRunning(job)) {
              devices = stage.get('deviceStates').getSlots().dynamic().properties().toArray();
              devices.forEach(function (device) {
                progressInfo.totalSteps += _steps.length;
                stageSteps[device.getName()] = JSON.parse(JSON.stringify(_steps));
              });
            } else {
              devices = job.getDevicesToProcess().toArray();
              devices.forEach(function (device) {
                progressInfo.totalSteps += _steps.length;
                stageSteps[String(device)] = JSON.parse(JSON.stringify(_steps));
              });
            }
          }
          allSteps[stageName] = stageSteps;
        });
        var jobStepDetails = [];
        var jobSteps = initialSteps.concat(forEachStationSteps);
        jobSteps.forEach(function (step) {
          jobStepDetails = jobStepDetails.concat(getDeviceDetails(step, "batchJob:DeviceStepDetails", "batchJob:NetworkStepDetails"));
        });
        //get the jobStepDetails and loop through each detail and get the jobSteps for this detail
        jobStepDetails.forEach(function (detail) {
          var deviceName;
          deviceName = detail.getStageName();
          if (detail.getType().is('batchJob:DeviceStepDetails')) {
            deviceName = detail.getDeviceId();
          }
          var stageJobSteps = allSteps[detail.getStageName()];
          var steps = stageJobSteps[deviceName];
          for (var i = 0; i < steps.length; i++) {
            var step = steps[i];
            if (step.status === "") {
              step.status = detail.getState().getTag();
              if (_this3.$isDeviceJobComplete(detail.getState())) {
                progressInfo.completedSteps++;
              }
              if (detail.getState().getTag() === "canceled" || detail.getState().getTag() === "failed") {
                //Remove all the steps from this failed point and update the total steps
                var filteredSteps = steps.filter(function (step) {
                  return step.status !== "";
                });
                progressInfo.totalSteps -= steps.length - filteredSteps.length;
              }
              break;
            }
          }
        });
        return Promise.resolve(progressInfo);
      }

      /**
       * @private
       * @returns {Boolean} true if job is complete
       */
    }, {
      key: "$isDeviceJobComplete",
      value: function $isDeviceJobComplete(state) {
        var stateTag = state.getTag();
        return stateTag === "success" || stateTag === "canceled" || stateTag === "failed";
      }

      /**
       * Returns all the job step details
       *
       * @param {baja.Component} job
       * @returns {Array}
       */
    }, {
      key: "$loadDeviceJobStepDetails",
      value: function $loadDeviceJobStepDetails(job) {
        var initialStageSteps = this.$getAllInitialSteps(job),
          forEachStationStageSteps = this.$getAllForEachStationSteps(job);
        var jobSteps = initialStageSteps.concat(forEachStationStageSteps);
        var jobStepDetails = [];
        jobSteps.forEach(function (step) {
          jobStepDetails = jobStepDetails.concat(getDeviceDetails(step, "batchJob:DeviceStepDetails", "batchJob:NetworkStepDetails"));
        });
        return jobStepDetails;
      }

      /**
       * @private
       * @param {baja.Value} job the batchJob:DeviceNetworkJob instance
       */
    }, {
      key: "$makeViewCommands",
      value: function $makeViewCommands(job) {
        this.$commands = new CommandGroup({
          commands: [new ViewLogCommand(job), new ViewJobListCommand(this), new CancelJobCommand(job), new CancelDeviceCommand(this), this.$makeDisposeJobCommand(job)]
        });
        return this.$commands;
      }

      /**
       * @private
       * @param {baja.Value} job the batchJob:DeviceNetworkJob instance
       * @returns {module:nmodule/batchJob/rc/wb/commands/DisposeJobCommand}
       */
    }, {
      key: "$makeDisposeJobCommand",
      value: function $makeDisposeJobCommand(job) {
        var _this4 = this;
        var disposeJobCmd = new DisposeJobCommand(job);
        var disposeFunc = disposeJobCmd.getFunction();
        disposeJobCmd.setFunction(function () {
          return disposeFunc().then(function () {
            return niagara.env.hyperlink(_this4.getJobListOrd());
          });
        });
        return disposeJobCmd;
      }
    }]);
  }(spandrel(function (job, _ref) {
    var self = _ref.self;
    return self.$buildDeviceStepDetails(job).then(function (deviceStepDetails) {
      var _deviceStepDetails$pr = deviceStepDetails.progressInfo,
        totalSteps = _deviceStepDetails$pr.totalSteps,
        completedSteps = _deviceStepDetails$pr.completedSteps;
      var progressPercent = totalSteps ? Math.ceil(100.0 * completedSteps / totalSteps) : 0;
      var progressStr = batchJobLex.get("DeviceNetworkJobView.progressPhrase", completedSteps, totalSteps, progressPercent);
      return [spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-container",
        spandrelKey: "jobView"
      }, spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-container"
      }, spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item-bold"
      }, batchJobLex.get("DeviceNetworkJobView.user")), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item"
      }, String(job.getSubmitUser())), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item-bold"
      }, batchJobLex.get("DeviceNetworkJobView.started")), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item"
      }, job.getStartTime().toString({})), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item-bold"
      }, batchJobLex.get("DeviceNetworkJobView.ended")), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item"
      }, job.getEndTime().toString({})), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item-bold"
      }, batchJobLex.get("DeviceNetworkJobView.state")), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item"
      }, String(job.getJobState().toString())), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item-bold"
      }, batchJobLex.get("DeviceNetworkJobView.progress")), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-grid-item"
      }, progressStr)), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-jobTable-container"
      }, spandrel.jsx(TableWithMenu, {
        value: deviceStepDetails.model,
        className: "-t-DeviceNetworkUxJobView-jobTable",
        spandrelKey: "jobTable",
        on: _defineProperty({}, ROW_SELECTION_CHANGED_EVENT, function (e, table) {
          self.$setCancelDeviceCommandEnabled(table);
        }),
        properties: {
          fixedHeaders: true
        }
      }))), spandrel.jsx("div", {
        className: "-t-DeviceNetworkUxJobView-commands",
        spandrelKey: "commandContainer"
      }, spandrel.jsx(CommandButtonGroup, {
        value: self.$makeViewCommands(job),
        spandrelKey: "commands"
      }))];
    });
  }));
});
