function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/* global niagara */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/PrototypeJobList
 */

define(['baja!', 'baja!batchJob:PermanentRetentionPolicy', 'lex!batchJob', 'Promise', 'underscore', 'bajaux/commands/Command', 'bajaux/mixin/subscriberMixIn', 'bajaux/spandrel', 'bajaux/util/CommandButton', 'bajaux/util/SaveCommand', 'nmodule/batchJob/rc/fe/RetentionPolicyEditor', 'nmodule/batchJob/rc/util/JobSummariesTable', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber'], function (baja, types, lexs, Promise, _, Command, subscriberMixin, spandrel, CommandButton, SaveCommand, RetentionPolicyEditor, JobSummariesTable, DepthSubscriber) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    BATCH_JOB_LEX = _lexs[0];
  var once = _.once;
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-PrototypeJobList'
      }
    };
  };

  /**
   * @class
   * @alias module:nmodule/batchJob/rc/PrototypeJobList
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel) {
    function PrototypeJobList(params) {
      var _this;
      _classCallCheck(this, PrototypeJobList);
      _this = _callSuper(this, PrototypeJobList, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixin(_this);
      _this.$setupSubscriptionsOnce = once(function () {
        return _this.$setupSubscriptions();
      });
      _this.getCommandGroup().add(new SaveCommand());
      return _this;
    }
    _inherits(PrototypeJobList, _spandrel);
    return _createClass(PrototypeJobList, [{
      key: "doDestroy",
      value: function doDestroy() {
        var jobSubscriber = this.$jobSubscriber;
        return jobSubscriber && jobSubscriber.unsubscribeAll();
      }

      /**
       * Save the newly set retention policy and policy enforcement check frequency back to the 
       * prototype.
       * @override
       * @return {Promise}
       */
    }, {
      key: "doSave",
      value: function doSave() {
        var jobPrototype = this.value();
        return Promise.all([this.$getRetentionPolicyEditor().read(), this.$getRetentionPolicyCheckFrequencyEditor().read()]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            retentionPolicyReadValue = _ref2[0],
            policyEnforceFrequencyReadValue = _ref2[1];
          return Promise.all([jobPrototype.set({
            slot: 'retentionPolicy',
            value: retentionPolicyReadValue
          }), jobPrototype.set({
            slot: 'retentionPolicyCheckFrequency',
            value: policyEnforceFrequencyReadValue
          })]);
        });
      }

      /**
       * @private
       * @param {baja.Component} batchjobPrototype 
       * @returns {Promise}
       */
    }, {
      key: "$getJobSummaries",
      value: function $getJobSummaries(batchjobPrototype) {
        return baja.rpc({
          typeSpec: "batchJob:BatchJobRpcUtil",
          method: "getPrototypeJobSummaries",
          args: [String(batchjobPrototype.getNavOrd())]
        }).then(function (summaries) {
          return Promise.all(summaries.map(function (summary) {
            return baja.bson.decodeAsync(JSON.parse(summary));
          }));
        });
      }

      /**
       * @private
       * @returns {module:nmodule/batchJob/rc/util/JobSummariesTable}
       */
    }, {
      key: "$getJobSummariesWidget",
      value: function $getJobSummariesWidget() {
        return this.queryWidget('**/summariesTable');
      }

      /**
       * @private
       * @return {module:bajaux/commands/Command}
       */
    }, {
      key: "$getSubmitCommand",
      value: function $getSubmitCommand() {
        return this.queryWidget('**/submitCommand');
      }

      /**
       * @private
       * @return {module:nmodule/batchJob/rc/fe/RetentionPolicyEditor}
       */
    }, {
      key: "$getRetentionPolicyEditor",
      value: function $getRetentionPolicyEditor() {
        return this.queryWidget('**/retentionPolicy');
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/RelTimeEditor}
       */
    }, {
      key: "$getRetentionPolicyCheckFrequencyEditor",
      value: function $getRetentionPolicyCheckFrequencyEditor() {
        return this.queryWidget('**/policyCheckFrequency');
      }

      /**
       * @private
       * @param {baja.Component} comp 
       * @returns {baja.Ord} 
       */
    }, {
      key: "$getOrdInSpace",
      value: function $getOrdInSpace(comp) {
        return baja.Ord.make('h:' + comp.getHandle());
      }

      /**
       * @private
       * @returns {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$makeSubmitCommand",
      value: function $makeSubmitCommand() {
        var _this2 = this;
        return new Command({
          module: 'batchJob',
          lex: 'PrototypeJobList.submitCommand',
          func: function func() {
            return _this2.value().invoke({
              slot: 'submitJob'
            }).then(function () {
              return niagara.env.reload();
            });
          }
        });
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/util/DepthSubscriber}
       */
    }, {
      key: "$getJobSubscriber",
      value: function $getJobSubscriber() {
        return this.$jobSubscriber;
      }

      /**
       * Register to handle component events for both JobService and 
       * BatchJobService. This is required to get progress updates for currently
       * running or disposed jobs and update the UI as appropriate.
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$setupSubscriptions",
      value: function $setupSubscriptions() {
        var _this3 = this;
        var jobSubscriber = this.$jobSubscriber = new DepthSubscriber(2);
        var jobService;
        var reloadThrottled = baja.throttle(function () {
          return _this3.$reloadSummariesTable();
        }, {
          drop: true,
          interval: 500
        });
        return baja.Ord.make("service:baja:JobService").get().then(function (jobSvc) {
          jobService = jobSvc;
          return jobSubscriber.subscribe([jobSvc]);
        }).then(function () {
          // Attach a changed listener to this new job to get progress updates
          jobSubscriber.attach('changed', function (prop) {
            var propName = prop.getName();
            if ((propName === 'jobState' || propName === 'progress' || propName === 'endTime') && baja.hasType(prop.$complex, 'batchJob:BatchJob')) {
              return reloadThrottled();
            }
          });
          jobSubscriber.attach('added', function (prop) {
            if (baja.hasType(jobService.get(prop), 'batchJob:BatchJob')) {
              // reload the table to get the new job
              return _this3.$reloadSummariesTable();
            }
          });
        });
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$reloadSummariesTable",
      value: function $reloadSummariesTable() {
        var _this4 = this;
        return this.$getJobSummaries(this.value()).then(function (summaries) {
          return _this4.$getJobSummariesWidget().load(summaries);
        });
      }
    }]);
  }(spandrel(function (value, _ref3) {
    var self = _ref3.self;
    return self.$getJobSummaries(value).then(function (summaries) {
      return [spandrel.jsx("div", {
        className: "-t-PrototypeJobList-rp-container"
      }, spandrel.jsx("div", {
        className: "-t-PrototypeJobList-rp-grid"
      }, spandrel.jsx("div", {
        className: "-t-PrototypeJobList-rp-label"
      }, BATCH_JOB_LEX.get('PrototypeJobList.retentionPolicy')), spandrel.jsx("div", {
        className: "-t-PrototypeJobList-rp"
      }, spandrel.jsx(RetentionPolicyEditor, {
        value: value.get('retentionPolicy'),
        spandrelKey: "retentionPolicy",
        onUxModify: function onUxModify() {
          return self.setModified(true);
        }
      })), spandrel.jsx("div", {
        className: "-t-PrototypeJobList-rp-label"
      }, BATCH_JOB_LEX.get('PrototypeJobList.checkFrequency')), spandrel.jsx("div", {
        className: "-t-PrototypeJobList-rp"
      }, spandrel.jsx("any", {
        value: value.get('retentionPolicyCheckFrequency'),
        spandrelKey: "policyCheckFrequency",
        onUxModify: function onUxModify() {
          return self.setModified(true);
        }
      })))), spandrel.jsx("div", {
        className: "-t-PrototypeJobList-container"
      }, spandrel.jsx(JobSummariesTable, {
        value: summaries,
        spandrelKey: "summariesTable",
        properties: {
          base: value
        },
        onUxLoad: function onUxLoad() {
          return self.$setupSubscriptionsOnce();
        }
      }), spandrel.jsx(CommandButton, {
        className: "ux-btn",
        spandrelKey: "submitCommand",
        value: self.$makeSubmitCommand()
      }))];
    });
  }, {
    strategy: 'niagara'
  }));
});
