function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/batchJob/rc/BatchJobStepLogFileUxView
 */

define(['baja!', 'lex!batchJob', 'Promise', 'bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'bajaux/spandrel', 'bajaux/util/CommandButtonGroup', 'nmodule/batchJob/rc/util/batchJobUtils', 'nmodule/batchJob/rc/util/LogContentWidget', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/servlets/registry', 'css!nmodule/batchJob/rc/batchJob'], function (baja, lexs, Promise, Command, CommandGroup, spandrel, CommandButtonGroup, batchJobUtils, LogContentWidget, asyncUtils, registry) {
  'use strict';

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: '-t-BatchJobStepLogFileUxView'
      }
    };
  };
  var getDisplayTz = batchJobUtils.getDisplayTz,
    hyperlinkToJob = batchJobUtils.hyperlinkToJob;
  var _lexs = _slicedToArray(lexs, 1),
    BATCH_JOB_LEX = _lexs[0];
  var doRequire = asyncUtils.doRequire;
  var getAgentOnInfo = registry.getAgentOnInfo;

  /**
   * @class
   * @inner
   * @extends module:bajaux/Widget
   */
  var StepDetailsWidget = /*#__PURE__*/function (_spandrel) {
    function StepDetailsWidget() {
      _classCallCheck(this, StepDetailsWidget);
      return _callSuper(this, StepDetailsWidget, arguments);
    }
    _inherits(StepDetailsWidget, _spandrel);
    return _createClass(StepDetailsWidget);
  }(spandrel(function (stepDetails, _ref) {
    var properties = _ref.properties;
    var timezone = properties.timezone;
    var renderDeviceName = function renderDeviceName() {
      if (baja.hasType(stepDetails, 'batchJob:DeviceStepDetails')) {
        return [spandrel.jsx("div", {
          className: "-t-StepDetailsWidget-item-label"
        }, BATCH_JOB_LEX.get('DeviceStepDetailsView.device')), spandrel.jsx("div", {
          className: "-t-StepDetailsWidget-item",
          spandrelKey: "deviceName"
        }, stepDetails.get('deviceDisplayName'))];
      }
    };
    return spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-grid",
      spandrelKey: "jobDetails"
    }, renderDeviceName(), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.type')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item",
      spandrelKey: "stepDescription"
    }, stepDetails.get('stepDescription')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.started')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item",
      spandrelKey: "startTime"
    }, stepDetails.get('startTime').toDateTimeStringSync({
      timezone: timezone
    })), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.ended')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item",
      spandrelKey: "endTime"
    }, stepDetails.get('endTime').toDateTimeStringSync({
      timezone: timezone
    })), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item-label"
    }, BATCH_JOB_LEX.get('JobStepDetailsView.state')), spandrel.jsx("div", {
      className: "-t-StepDetailsWidget-item",
      spandrelKey: "state"
    }, String(stepDetails.get('state'))));
  }));
  /**
   * @class
   * @alias module:nmodule/batchJob/rc/BatchJobStepLogFileUxView
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel2) {
    function BatchJobStepLogFileUxView(params) {
      _classCallCheck(this, BatchJobStepLogFileUxView);
      return _callSuper(this, BatchJobStepLogFileUxView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
    }

    /**
     * @private
     * @param {baja.file.File} jobStepLogFile
     * @returns {Promise.<baja.Component>}
     */
    _inherits(BatchJobStepLogFileUxView, _spandrel2);
    return _createClass(BatchJobStepLogFileUxView, [{
      key: "$getJobStepDetails",
      value: function $getJobStepDetails(jobStepLogFile) {
        return baja.rpc({
          typeSpec: "batchJob:BatchJobRpcUtil",
          method: "getJobLogStepDetails",
          args: [String(jobStepLogFile.getNavOrd())]
        }).then(function (result) {
          return baja.bson.decodeAsync(JSON.parse(result));
        });
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getStepDetailsWidget",
      value: function $getStepDetailsWidget() {
        return this.queryWidget('container/stepDetails');
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getLogContentWidget",
      value: function $getLogContentWidget() {
        return this.queryWidget('container/logContent');
      }

      /**
       * @private
       * @return {module:bajaux/commands/CommandGroup}
       */
    }, {
      key: "$getViewCommandGroup",
      value: function $getViewCommandGroup() {
        return this.queryWidget('container/2/commandGroup').value();
      }

      /**
       *
       * @private
       * @param {baja.Component} jobStepDetails everything about the job step
       * @param {baja.Component} stepDetails of type batchJob:JobStepDetails
       * @param {baja.AbsTime} jobStartTime
       * @param {baja.TimeZone} timezone
       * @return {Promise.<module:bajaux/commands/CommandGroup>}
       */
    }, {
      key: "$makeViewCommandGroup",
      value: function $makeViewCommandGroup(jobStepDetails, stepDetails, jobStartTime, timezone) {
        var _this = this;
        var jobStepLogFile = this.value();
        var commandGroup = new CommandGroup({
          commands: [new Command({
            module: 'batchJob',
            lex: 'JobStepDetailsView.goJobCommand',
            func: function func() {
              return baja.rpc({
                typeSpec: "batchJob:BatchJobRpcUtil",
                method: "getJobOrd",
                args: [jobStartTime.encodeToString(), String(jobStepLogFile.getNavOrd())]
              }).then(function (ordStr) {
                return hyperlinkToJob(ordStr, timezone);
              });
            }
          }), new Command({
            module: 'batchJob',
            lex: 'JobStepDetailsView.refreshLogCommand',
            enabled: false,
            func: function func() {
              // TODO
              // `doReadLog` is abstract in BJobStepDetails readLog action slot.
              // `stepDetails` is of type BNetworkStepDetails with `doReadLog` implementation,
              // which the invoke fails to pick.
              return stepDetails.invoke({
                slot: 'readLog'
              }).then(function (result) {
                return _this.$getLogContentWidget().load(result);
              });
            }
          })]
        });
        return this.$addViewCommands(jobStepLogFile, stepDetails, commandGroup);
      }

      /**
       * Adds any additional commands to the command group
       * @private
       * @param {baja.Object} jobStepLogFile the log file for the job
       * @param {baja.Component} stepDetails of type batchJob:JobStepDetails
       * @param {module:bajaux/commands/CommandGroup} commandGroup the current command groups
       * @returns {Promise}
       */
    }, {
      key: "$addViewCommands",
      value: function $addViewCommands(jobStepLogFile, stepDetails, commandGroup) {
        return getAgentOnInfo(stepDetails.getType().getTypeSpec(), {
          is: 'batchJob:IUxJobStepDetails'
        }).then(function (agents) {
          if (agents.length > 0) {
            var agent = agents[0];
            return doRequire(agent.js.id, agent.js.deps);
          }
        }).then(function (UxJobStepDetails) {
          if (UxJobStepDetails) {
            var uxJobStepDetails = new UxJobStepDetails();
            var commands = uxJobStepDetails.makeCommands({
              jobStepLogFile: jobStepLogFile,
              stepDetails: stepDetails,
              viewName: 'BatchJobStepLogFileUxView'
            });
            commandGroup.add.apply(commandGroup, _toConsumableArray(commands));
          }
          return commandGroup;
        });
      }
    }]);
  }(spandrel(function (jobStepLogFile, _ref2) {
    var self = _ref2.self;
    var jobStepDetails;
    var timezone;
    var stepDetails;
    var jobStartTime;
    var logContents;
    return Promise.all([self.$getJobStepDetails(jobStepLogFile), getDisplayTz()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        jobStepDetailsResults = _ref4[0],
        timezoneResults = _ref4[1];
      jobStepDetails = jobStepDetailsResults;
      timezone = timezoneResults;
      stepDetails = jobStepDetails.get('stepDetails');
      jobStartTime = jobStepDetails.get('jobStartTime');
      logContents = jobStepDetails.get('logContents');
      return self.$makeViewCommandGroup(jobStepDetails, stepDetails, jobStartTime, timezone);
    }).then(function (commandGroup) {
      return spandrel.jsx("div", {
        className: "-t-BatchJobStepLogFileUxView-container",
        spandrelKey: "container"
      }, spandrel.jsx(StepDetailsWidget, {
        value: stepDetails,
        spandrelKey: "stepDetails",
        properties: {
          timezone: timezone
        }
      }), spandrel.jsx(LogContentWidget, {
        value: logContents,
        spandrelKey: "logContent",
        properties: {
          showMenu: true
        }
      }), spandrel.jsx("div", {
        className: "-t-BatchJobStepLogFileUxView-commands"
      }, spandrel.jsx(CommandButtonGroup, {
        value: commandGroup,
        spandrelKey: "commandGroup"
      })));
    });
  }));
});
