/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/wb/menu/historyMenuAgent
 */
define(['bajaux/commands/CommandGroup', 'underscore', 'nmodule/history/rc/wb/commands/SetHistoryDisplayNameCommand', 'nmodule/webEditors/rc/transform/ExportCommand', 'nmodule/webEditors/rc/wb/menu/menuUtils', 'nmodule/webEditors/rc/wb/menu/Separator'], function (CommandGroup, _, SetHistoryDisplayNameCommand, ExportCommand, menuUtils, Separator) {
  'use strict';

  var makeViewsGroup = menuUtils.makeViewsGroup;

  /**
   * Menu agent for handling right-click context menus on History nodes.
   *
   * @alias module:nmodule/history/rc/wb/menu/historyMenuAgent
   * @param {module:bajaux/Widget} widget
   * @param {baja.NavNode} history
   * @returns {Promise.<module:bajaux/commands/CommandGroup>}
   * @since Niagara 4.14
   */
  return function historyMenuAgent(widget, history) {
    return menuUtils.ifAllowedByProfile('viewSelection', function () {
      return makeViewsGroup(history.getNavOrd());
    }).then(function (viewsGroup) {
      var commands = [];
      if (viewsGroup) {
        commands.push(viewsGroup, new Separator());
      }
      if (history.getPermissions().hasAdminWrite()) {
        commands.push(new SetHistoryDisplayNameCommand(history), new Separator());
      }
      commands.push(new ExportCommand(history));
      return new CommandGroup({
        commands: commands
      });
    });
  };
});
