function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/TrendRecordEditor
 */
define(['baja!', 'baja!history:TrendFlags', 'lex!history', 'bajaux/events', 'bajaux/mixin/batchSaveMixin', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'css!nmodule/history/rc/history'], function (baja, types, lexs, events, batchSaveMixin, $, Promise, fe, BaseEditor, compUtils) {
  'use strict';

  var historyLex = lexs[0],
    bulkCopy = compUtils.bulkCopy,
    COMMIT_READY = batchSaveMixin.COMMIT_READY,
    HIDDEN_FLAG = 0x04,
    DESTROY_EVENT = events.DESTROY_EVENT,
    DISABLE_EVENT = events.DISABLE_EVENT,
    ENABLE_EVENT = events.ENABLE_EVENT,
    INITIALIZE_EVENT = events.INITIALIZE_EVENT,
    LOAD_EVENT = events.LOAD_EVENT,
    MODIFY_EVENT = events.MODIFY_EVENT,
    READONLY_EVENT = events.READONLY_EVENT,
    WRITABLE_EVENT = events.WRITABLE_EVENT;
  function setHidden(trendFlags, hidden) {
    var flagBits = parseInt(trendFlags.encodeToString(), 16);
    flagBits = hidden ? flagBits | HIDDEN_FLAG : flagBits & ~HIDDEN_FLAG;
    return baja.$('history:TrendFlags', String(flagBits));
  }
  function hasHiddenFlag(trendFlags) {
    var bits = parseInt(trendFlags.encodeToString(), 16);
    return !!(bits & 0x04);
  }
  function sameType(value1, value2) {
    return baja.hasType(value1) && value1.getType().is(value2.getType());
  }

  /**
   * Editor for working with `history:TrendRecord` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @alias module:nmodule/history/rc/fe/TrendRecordEditor
   */
  var TrendRecordEditor = function TrendRecordEditor(params) {
    BaseEditor.apply(this, arguments);
    batchSaveMixin(this);
  };
  TrendRecordEditor.prototype = Object.create(BaseEditor.prototype);
  TrendRecordEditor.prototype.constructor = TrendRecordEditor;

  /**
   * Get the "hidden" boolean editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */
  TrendRecordEditor.prototype.$getHiddenEditor = function () {
    return this.jq().children('.type-baja-Boolean').data('widget');
  };

  /**
   * Get the "timestamp" AbsTime editor.
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */
  TrendRecordEditor.prototype.$getTimestampEditor = function () {
    return this.jq().children('.type-baja-AbsTime').data('widget');
  };

  /**
   * Get the "value" editor (enum/boolean/string/numeric, depending on the
   * trend record type).
   *
   * @private
   * @returns {module:nmodule/webEditors/rc/fe/baja/BaseEditor}
   */
  TrendRecordEditor.prototype.$getValueEditor = function () {
    return this.$getValueElement().data('widget');
  };

  /**
   * Get the DOM element holding the value editor.
   *
   * @private
   * @returns {JQuery}
   */
  TrendRecordEditor.prototype.$getValueElement = function () {
    return this.jq().children('.recordValue');
  };

  /**
   * Load in the new "value" slot for the trend record. If an existing value of
   * the same type has already been loaded, the existing value editor will be
   * reused; otherwise a new editor will be built.
   *
   * @private
   * @param {baja.Value} value enum/string/boolean/numeric value to load
   * @returns {Promise}
   */
  TrendRecordEditor.prototype.$loadRecordValue = function (value) {
    var that = this,
      valueEd = this.$getValueEditor();
    function buildValueEditor() {
      return fe.buildFor({
        dom: that.$getValueElement(),
        value: value,
        formFactor: 'mini'
      });
    }
    if (valueEd) {
      if (sameType(valueEd.value(), value)) {
        return valueEd.load(value);
      } else {
        return valueEd.destroy().then(buildValueEditor);
      }
    } else {
      return buildValueEditor();
    }
  };

  /**
   * Initialize editors for the timestamp and the hidden flag. (The value editor
   * will be built later in `doLoad`, when we know the type of the trend
   * record.)
   *
   * @param {JQuery} dom
   */
  TrendRecordEditor.prototype.doInitialize = function (dom) {
    var that = this,
      hidden = historyLex.get({
        key: 'Hidden',
        def: 'Hidden'
      });
    dom.on([DESTROY_EVENT, DISABLE_EVENT, ENABLE_EVENT, INITIALIZE_EVENT, LOAD_EVENT, READONLY_EVENT, WRITABLE_EVENT].join(' '), '.editor', false);
    dom.on(MODIFY_EVENT, '.editor', function () {
      that.setModified(true);
      return false;
    });
    return Promise.all([fe.buildFor({
      dom: $('<div/>').appendTo(dom),
      value: baja.AbsTime.DEFAULT,
      formFactor: 'mini'
    }), fe.buildFor({
      dom: $('<div/>').appendTo(dom),
      properties: {
        trueText: hidden,
        falseText: hidden
      },
      value: false,
      formFactor: 'mini'
    }), dom.append($('<div class="recordValue"/>'))]);
  };

  /**
   * Load the timestamp, trend flags, and value into the appropriate editors.
   *
   * @param {baja.Complex} trendRecord the `history:TrendRecord` to load
   */
  TrendRecordEditor.prototype.doLoad = function (trendRecord) {
    return Promise.all([this.$getTimestampEditor().load(trendRecord.get('timestamp')), this.$getHiddenEditor().load(hasHiddenFlag(trendRecord.get('trendFlags'))), this.$loadRecordValue(trendRecord.get('value'))]);
  };

  /**
   * Resolve a new `history:TrendRecord` instance of the same type initially
   * loaded, with the timestamp, hidden flag, and value set according to
   * currently entered values.
   *
   * @returns {Promise}
   * @throws {Error} if no `history:TrendRecord` was loaded already
   */
  TrendRecordEditor.prototype.doRead = function () {
    var loadedRecord = this.value();
    if (!baja.hasType(loadedRecord, 'history:TrendRecord')) {
      throw new Error('cannot read value until a TrendRecord has been loaded');
    }
    return this.getChildEditors().readAll().then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
        timestamp = _ref2[0],
        hidden = _ref2[1],
        value = _ref2[2];
      return baja.$(loadedRecord.getType(), {
        timestamp: timestamp,
        trendFlags: setHidden(loadedRecord.get('trendFlags'), hidden),
        value: value
      });
    });
  };

  /**
   * Write the timestamp, hidden flag, and value to the currently loaded
   * `history:TrendRecord`.
   *
   * @param {baja.Struct} validValue the `history:TrendRecord` instance resolved
   * from `read()`
   * @param {Object} [params] optional save parameters (will be respected
   * vis-a-vis `batchSaveMixin`)
   * @returns {Promise}
   */
  TrendRecordEditor.prototype.doSave = function (validValue, params) {
    var batch = params && params.batch,
      progressCallback = params && params.progressCallback,
      propsToCopy = ['timestamp', 'trendFlags', 'value'],
      prom = bulkCopy(validValue, this.value(), propsToCopy, batch);
    if (progressCallback) {
      progressCallback(COMMIT_READY);
    }
    return prom;
  };

  /**
   * Destroy all child editors.
   *
   * @returns {Promise}
   */
  TrendRecordEditor.prototype.doDestroy = function () {
    return this.getChildEditors().destroyAll();
  };

  /**
   * Set all child editors readonly/writable.
   *
   * @param {Boolean} readonly
   * @returns {Promise}
   */
  TrendRecordEditor.prototype.doReadonly = function (readonly) {
    return this.getChildEditors().setAllReadonly(readonly);
  };

  /**
   * Set all child editors enabled/disabled.
   *
   * @param {Boolean} enabled
   * @returns {Promise}
   */
  TrendRecordEditor.prototype.doEnabled = function (enabled) {
    return this.getChildEditors().setAllEnabled(enabled);
  };
  return TrendRecordEditor;
});
