function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/HistoryTableQueryAdapter
 */
define(['baja!', 'Promise', 'underscore', 'nmodule/history/rc/historyUtil', 'nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn', 'nmodule/webEditors/rc/servlets/QueryAdapter'], function (baja, Promise, _, historyUtil, PropertyColumn, QueryAdapter) {
  'use strict';

  /**
   * History Table Query Adapter fits between QueryServlet and a TableModel
   * specifically for history queries.
   *
   * @class
   * @alias module:nmodule/history/rc/fe/HistoryTableQueryAdapter
   * @extends module:nmodule/webEditors/rc/servlets/QueryAdapter
   * @param {module:nmodule/webEditors/rc/wb/table/model/TableModel} model
   * @param {baja.Component} config the `history:HistoryConfig` used for this
   * history
   * @param {object} [context] additional context
   */
  var HistoryTableQueryAdapter = function HistoryTableQueryAdapter(model, config, context) {
    this.$model = model;
    this.$config = config;
    this.$context = context || {};
    QueryAdapter.call(this);
  };
  HistoryTableQueryAdapter.prototype = Object.create(QueryAdapter.prototype);
  HistoryTableQueryAdapter.prototype.constructor = HistoryTableQueryAdapter;

  /**
   * Convert the query into a string, adding whatever additional arguments
   * are necessary to complete the query, and escaping it so that it can
   * be used as part of a URI.
   *
   * @param {Object} query
   * @param {baja.Ord} query.ord
   * @param {boolean} [query.delta=false]
   * @param {boolean} [query.descending=false]
   * @param {string} [query.sortColumn='']
   * @param {string} [query.delimiter='?']
   * @param {baja.Component} [query.filter] `bql:FilterSet` component
   * @param {baja.AbsTime} [query.lastTimestamp]
   * @param {baja.Simple} [query.timeRange] `bql:DynamicTimeRange`
   * @param {number} [query.offset]
   * @param {number} [query.limit]
   * @returns {string}
   */
  HistoryTableQueryAdapter.prototype.getFullOrdString = function (query) {
    var ord = query.ord,
      ordSuffix = '',
      historyOrdSuffix = '',
      delta = query.delta,
      delimiter = query.delimiter || '?',
      filter = query.filter;
    function addParameter(str) {
      if (ordSuffix.length) {
        ordSuffix += '&';
      } else {
        ordSuffix += delimiter;
      }
      ordSuffix += str;
    }
    function addHistoryParameter(str) {
      if (historyOrdSuffix.length) {
        historyOrdSuffix += ';';
      } else {
        historyOrdSuffix += delimiter;
      }
      historyOrdSuffix += str;
    }
    if (filter) {
      var encodedFilter = JSON.stringify(baja.bson.encodeValue(filter));
      addParameter('filter=' + baja.SlotPath.escape(encodedFilter));
    }
    if (typeof query.offset === 'number') {
      addParameter('offset=' + query.offset);
    }
    if (typeof query.limit === 'number') {
      addParameter('limit=' + query.limit);
    }
    if (query.sortColumn !== undefined) {
      addParameter('sortColumn=' + query.sortColumn);
    }
    if (query.descending !== undefined) {
      addParameter('descending=' + (query.descending ? 'true' : 'false'));
    }
    if (delta) {
      addHistoryParameter('delta=true');
    }
    if (query.timeRange && !query.timeRange.equals(baja.$('bql:DynamicTimeRange'))) {
      addHistoryParameter(historyUtil.toHistoryParameter(query.timeRange));
    } else if (query.lastTimestamp) {
      addHistoryParameter('start=' + query.lastTimestamp.encodeToString());
    }
    return baja.SlotPath.escape(ord.toString() + historyOrdSuffix) + ordSuffix;
  };
  HistoryTableQueryAdapter.prototype.resetModel = function () {
    var that = this;
    return that.$model.removeColumns(that.$model.getColumns()).then(function () {
      return that.$model.clearRows();
    });
  };
  HistoryTableQueryAdapter.prototype.addRecords = function (records, index) {
    return this.$model.insertRows(records, index);
  };
  HistoryTableQueryAdapter.prototype.getRecords = function () {
    return this.$model.getRows();
  };

  /**
   * If the first record is available, use that for the default record, if not obtain the default record from the record type.
   * @param {baja.Complex} [record] If there is no first column, then this will be undefined.
   * @returns {baja.Complex}
   */
  HistoryTableQueryAdapter.prototype.getDefaultRecord = function (record) {
    if (record) {
      return record;
    }
    var recordType = this.$config.get('recordType');
    return baja.$(recordType);
  };

  /**
   * @param {Array<baja.Property>} properties
   * @param {baja.Complex} parent `baja.Complex`.
   * @returns {Promise}
   */
  HistoryTableQueryAdapter.prototype.addColumns = function (properties, parent) {
    var that = this;
    return Promise.all(properties.map(function (property) {
      return that.$toColumn(parent, property);
    })).then(function (columns) {
      return that.$model.insertColumns(columns);
    });
  };

  /**
   * Create a column for the given property.
   * @private
   * @param {baja.Complex} parent
   * @param {baja.Property} property
   * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/model/columns/PropertyColumn>} resolves
   * a new property column
   */
  HistoryTableQueryAdapter.prototype.$toColumn = function (parent, property) {
    // the facets logic mirrors that in HistoryColumns.getColumns().
    // the unit display mirrors that CollectionTableModel.updateColumns().
    var config = this.$config,
      facets = config.get(property + 'Facets'),
      timeZone = config.get('timeZone'),
      context = _.defaults(facets ? facets.toObject() : {}, {
        showSeconds: true
      });
    if (this.$context) {
      context = _.extend(context, this.$context);
    }
    return Promise.all([
    // always show units in headers if they are defined
    baja.Unit.toDisplayUnits(_.extend({}, context, {
      showUnits: true
    })),
    //TODO: remove this workaround after fixing NCCB-38012
    timeZone && baja.TimeZoneDatabase.get()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        displayUnits = _ref2[0],
        db = _ref2[1];
      var displayName = parent.getDisplayName(property);
      if (displayUnits) {
        displayName += ' (' + displayUnits.getSymbol() + ')';
      }
      if (timeZone) {
        context.TimeZone = db.getTimeZone(timeZone.getId());
      }
      var column = new PropertyColumn(property, {
        displayName: displayName,
        type: property.getType()
      });
      column.data('context', context);
      return column;
    });
  };
  HistoryTableQueryAdapter.prototype.getColumns = function () {
    return this.$model.getColumns();
  };
  return HistoryTableQueryAdapter;
});
