function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Aaron Laniewicz
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/fe/HistoryIdEditor
 */
define(['bajaux/events', 'nmodule/history/rc/baja/HistoryId', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'css!nmodule/history/rc/history'], function (events, HistoryId, CompositeEditor, CompositeBuilder) {
  'use strict';

  var KEY_DEVICE = 'deviceName',
    KEY_HISTORY = 'historyName',
    CLASS_DEVICE = '.js-deviceName',
    CLASS_HISTORY = '.js-historyName',
    keys = [KEY_DEVICE, KEY_HISTORY],
    VALID_REGEX = /^[^/]*$/,
    SHORTHAND_REGEX = /^[@^]$/,
    MODIFY_EVENT = events.MODIFY_EVENT;

  /**
   * Editor for handling `history:HistoryId` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/history/rc/fe/HistoryIdEditor
   */
  var HistoryIdEditor = function HistoryIdEditor(params) {
    CompositeEditor.apply(this, arguments);
  };
  HistoryIdEditor.prototype = Object.create(CompositeEditor.prototype);
  HistoryIdEditor.prototype.constructor = HistoryIdEditor;

  /**
   * Called whenever deviceName or historyName is changed.
   *
   * @private
   */
  HistoryIdEditor.prototype.$nameChanged = function (node) {
    var that = this,
      ed = that.jq().children(node).data('widget'),
      slashes = that.jq().children('.slash');
    return ed.read().then(function (val) {
      // use shorthand format if deviceName is shorthand notation
      if (node === CLASS_DEVICE) {
        if (SHORTHAND_REGEX.test(val)) {
          slashes.hide();
          ed.jq().addClass('shorthand');
        } else {
          slashes.show();
          ed.jq().removeClass('shorthand');
        }
      }

      // TODO: Move text validation to an ancestor, like StringEditor
      // Create a new property called something like invalidRegEx. If not null, the 'invalid' class
      // gets applied automatically without any coding because it's taken care of in the ancestor.
      // If anyone wants to implement validation, they just have pass a 'invalidRegEx' property.
      if (VALID_REGEX.test(val)) {
        ed.jq().removeClass('invalid');
      } else {
        ed.jq().addClass('invalid');
      }
    });
  };

  /**
   * Initialize editors for deviceName and historyName.
   *
   * @param {JQuery} dom
   * @returns {Promise}
   */
  HistoryIdEditor.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html('<span class="slash">/</span><span class="js-deviceName"/>' + '<span class="slash">/</span><span class="js-historyName"/>');
    dom.on(MODIFY_EVENT, CLASS_DEVICE, function () {
      return that.$nameChanged(CLASS_DEVICE);
    });
    dom.on(MODIFY_EVENT, CLASS_HISTORY, function () {
      return that.$nameChanged(CLASS_HISTORY);
    });
    return CompositeEditor.prototype.doInitialize.apply(that, arguments);
  };

  /**
   * The builder for an `HistoryIdEditor` will create string editors
   * for the deviceName and historyName fields of a `history:HistoryId` value.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  HistoryIdEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getDomFor = function (key) {
      return that.jq().children('.js-' + key);
    };
    builder.getKeys = function () {
      return keys.slice();
    };
    builder.getValueFor = function (key) {
      var historyId = this.getDataSource();
      switch (key) {
        case KEY_DEVICE:
          return historyId.getDeviceName();
        case KEY_HISTORY:
          return historyId.getHistoryName();
      }
    };
    builder.getConfigFor = function () {
      return {
        formFactor: 'mini'
      };
    };
    return builder;
  };

  /**
   * Read all string editors and construct an `history:HistoryId` instance.
   *
   * @returns {Promise}
   */
  HistoryIdEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (args) {
      return HistoryId.make.apply(HistoryId, _toConsumableArray(args));
    });
  };

  /**
   * Load the deviceName and historyName of the `HistoryId` into the appropriate
   * sub-editors.
   *
   * @param {module:nmodule/history/rc/baja/HistoryId} HistoryId a `history:HistoryId`
   * @returns {Promise}
   */
  HistoryIdEditor.prototype.doLoad = function (HistoryId) {
    var that = this;
    return CompositeEditor.prototype.doLoad.apply(that, arguments).then(function () {
      // Show/hide shorthand view
      return that.$nameChanged(CLASS_DEVICE);
    });
  };
  return HistoryIdEditor;
});
