/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/history/rc/HistoryGroupManager
 */
define(['baja!', 'baja!history:HistoryGroupings,history:HistoryGroup', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/mgr/Manager', 'nmodule/webEditors/rc/wb/mgr/model/MgrModel', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/mixin/ContextMenuSupport'], function (baja, types, Promise, _, Manager, MgrModel, MgrTypeInfo, NameMgrColumn, PropertyMgrColumn, Column, DepthSubscriber, addContextMenuSupport) {
  'use strict';

  var HISTORY_GROUP_TYPE = baja.lt('history:HistoryGroup'),
    COLUMNS = getColumns();
  function getColumns() {
    var historyGroupProps = baja.$('history:HistoryGroup').getSlots().properties().toArray(),
      historyGroupColumns = _.map(historyGroupProps, function (prop) {
        return new PropertyMgrColumn(prop, {
          flags: Column.flags.EDITABLE,
          type: HISTORY_GROUP_TYPE
        });
      });
    return [new NameMgrColumn({
      flags: Column.flags.EDITABLE
    })].concat(historyGroupColumns);
  }

  /**
   * @class
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   * @alias module:nmodule/history/rc/HistoryGroupManager
   */
  var HistoryGroupManager = function HistoryGroupManager(params) {
    Manager.call(this, _.extend({
      moduleName: 'history',
      keyName: 'HistoryGroupUxManager'
    }, params));
    this.$sub = new DepthSubscriber(2);
    addContextMenuSupport(this);
  };

  //extend and set up prototype chain
  HistoryGroupManager.prototype = Object.create(Manager.prototype);
  HistoryGroupManager.prototype.constructor = HistoryGroupManager;

  /**
   * Create a MgrModel instance from a history:HistoryGroupings component source
   * @private
   * @param historyGroupings
   */
  HistoryGroupManager.prototype.makeModel = function (historyGroupings) {
    return MgrTypeInfo.make(['history:HistoryGroup']).then(function (newTypes) {
      return new MgrModel({
        componentSource: historyGroupings,
        newTypes: newTypes,
        columns: COLUMNS
      });
    });
  };

  /**
   * Override doLoad() to subscribe to the history groupings component.
   * @param historyGroupings
   * @returns {Promise}
   */
  HistoryGroupManager.prototype.doLoad = function (historyGroupings) {
    var that = this;
    return this.$sub.subscribe(historyGroupings).then(function () {
      return Manager.prototype.doLoad.call(that, historyGroupings);
    });
  };

  /**
   * Destroy the main view table / unsubscribe
   * @returns {Promise}
   */
  HistoryGroupManager.prototype.doDestroy = function () {
    return Promise.all([this.$sub.unsubscribeAll(), Manager.prototype.doDestroy.apply(this, arguments)]);
  };

  ////////////////////////////////////////////////////////////
  //Context Menu Support
  ////////////////////////////////////////////////////////////

  /**
   * Callback from CommandGroupContextMenu. Trigger context menus specifically on table row right clicks
   * @override
   * @returns {string}
   */
  HistoryGroupManager.prototype.getContextMenuSelector = function () {
    return 'tr';
  };

  /**
   * Overrides the default onMainTableDblClicked action and invokes the EditCommand
   * @inheritDoc
   */
  HistoryGroupManager.prototype.onMainTableDblClicked = function (event, subjects) {
    return this.$getEditCommand().invoke();
  };

  /**
   * Overrides the default onMainTableDblClicked action and enables/disables the EditCommand
   * @inheritDoc
   */
  HistoryGroupManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var mainTableSelection = selectedSubjects.mainTableSelection;
    var editCmd = this.$getEditCommand();
    editCmd.setEnabled(!(mainTableSelection.length === 0));
  };

  /////////////////////////////////////////////////////////////////

  return HistoryGroupManager;
});
