function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

define(['log!bajaux/spandrel', 'bajaux/spandrel/buildConfig', 'bajaux/spandrel/RequestLayoutMixin', 'bajaux/spandrel/logging', 'bajaux/spandrel/symbols', 'bajaux/spandrel/util', 'bajaux/events', 'bajaux/Widget', 'jquery', 'Promise', 'underscore'], function (log, buildConfig, RequestLayoutMixin, logging, symbols, util, events, Widget, $, Promise, _) {
  'use strict';

  var logSevere = log.severe.bind(log);
  var areTimingDetailsLoggable = logging.areTimingDetailsLoggable,
    logTimingDetails = logging.logTimingDetails;
  var MODIFY_EVENT = events.MODIFY_EVENT;
  var any = _.any,
    extend = _.extend,
    isArray = _.isArray,
    once = _.once;
  var DEPTH_SYMBOL = symbols.DEPTH_SYMBOL,
    IS_ELEMENT_SYMBOL = symbols.IS_ELEMENT_SYMBOL,
    LAX_SYMBOL = symbols.LAX_SYMBOL,
    OWNER_SYMBOL = symbols.OWNER_SYMBOL,
    RENDER_TICKS_SYMBOL = symbols.RENDER_TICKS_SYMBOL,
    ROOT_SYMBOL = symbols.ROOT_SYMBOL,
    SPANDREL_HANDLER_PRIORITY = symbols.SPANDREL_HANDLER_PRIORITY,
    STATE_BINDING_SYMBOL = symbols.STATE_BINDING_SYMBOL;
  var cloneNode = util.cloneNode,
    getContainingSpandrelWidget = util.getContainingSpandrelWidget,
    getPathToKid = util.getPathToKid,
    pathMatches = util.pathMatches,
    setValidationOfDescendent = util.setValidationOfDescendent;
  var ElementWidget = /*#__PURE__*/function (_Widget) {
    function ElementWidget() {
      _classCallCheck(this, ElementWidget);
      return _callSuper(this, ElementWidget, arguments);
    }
    _inherits(ElementWidget, _Widget);
    return _createClass(ElementWidget, [{
      key: IS_ELEMENT_SYMBOL,
      get: function get() {
        return true;
      }
    }]);
  }(Widget); // avoid circular dependency
  var spandrel = once(function () {
    return require('bajaux/spandrel');
  });
  var ticks = 0;

  /**
   * This module contains utility methods for managing the construction, rebuilding, and destruction
   * of trees of child widgets.
   *
   * API Status: **Private**
   * @exports module:bajaux/spandrel/workflow
   */
  var workflow = {};

  /**
   * @param {module:bajaux/spandrel/SpandrelWidget} widget
   * @param {JQuery} dom
   * @param {Array} on
   */
  workflow.armHandlers = function (widget, dom, on) {
    var prev = widget.$spandrelHandlers;
    if (prev) {
      prev.forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 3),
          event = _ref2[0],
          handler = _ref2[2];
        return dom.off(event, handler);
      });
    }

    //allow 1-dimensional array handler
    if (on.length && !isArray(on[0])) {
      on = [on];
    }
    var spandrelHandlers = widget.$spandrelHandlers = [];
    on.forEach(function (arr) {
      var _arr = _slicedToArray(arr, 3),
        event = _arr[0],
        selectorString = _arr[1],
        handler = _arr[2];
      if (arr.length === 2) {
        handler = selectorString;
        selectorString = null;
      }
      var selectors = selectorString ? selectorString.split(',').map(function (s) {
        return s.trim();
      }) : null;
      var eventHandler = function eventHandler(e) {
        var target = e.target;
        var spandrelWidget = getContainingSpandrelWidget(target);
        var args = Array.prototype.slice.call(arguments, 1);
        if (spandrelWidget) {
          //Widget#trigger already passes itself as first argument - don't double up
          if (spandrelWidget === args[0]) {
            args = args.slice(1);
          }
          var path = getPathToKid(widget, spandrelWidget);
          if (!selectors || anyPathMatches(selectors, path.join('/'))) {
            // let spandrel log errors for convenience, but don't let it
            // interfere with actual throw/reject behavior.
            try {
              var result = handler.apply(target, [e, spandrelWidget].concat(args));
              if (result === false) {
                return false;
              }
              return Promise.resolve(result)["catch"](logAndRethrow);
            } catch (err) {
              logAndRethrow(err);
            }
          }
        }
      };
      eventHandler[SPANDREL_HANDLER_PRIORITY] = 1;
      spandrelHandlers.push([event, selectorString, eventHandler]);
      dom.on(event, eventHandler);
    });
    workflow.$moveSpandrelModifyHandlersToFront(dom[0]);
  };

  /**
   * What needs to happen: the user-configured spandrel event handlers (e.g. onUxModify) need to run
   * first, then the core spandrel event handlers (modify event capturing and state value
   * propagation) need to run before any other jQuery event handlers (e.g. dom.on(MODIFY_EVENT)
   * armed outside of spandrel).
   *
   * Otherwise, the jQuery event handlers run before spandrel gets a chance to sanitize their
   * behavior (again, mostly modify events - see NCCB-64643).
   *
   * Right now, the only way to do this is to use private jQuery API. jQuery's official behavior is
   * that whatever gets armed first, runs first - so the inline jQuery handlers would always run
   * before the handlers that spandrel arms in doInitialize.
   *
   * @private
   * @param {HTMLElement} el
   */
  workflow.$moveSpandrelModifyHandlersToFront = function (el) {
    var events = $._data(el).events;
    var modifyHandlers = events && events[MODIFY_EVENT];
    if (!modifyHandlers) {
      return;
    }

    // first, pull the delegates out because it's jQuery behavior that they come first:
    var delegates = modifyHandlers.splice(0, modifyHandlers.delegateCount);

    // then the spandrel handlers:
    var spandrelHandlers = [];
    for (var i = 0, len = modifyHandlers.length; i < len;) {
      var modifyHandler = modifyHandlers[i];
      if (modifyHandler.handler[SPANDREL_HANDLER_PRIORITY]) {
        spandrelHandlers.push.apply(spandrelHandlers, _toConsumableArray(modifyHandlers.splice(i, 1)));
        len--;
      } else {
        i++;
      }
    }

    /*
    then sort them so handlers from spandrel data go first, then the core handlers from
    SpandrelWidget#doInitialize.
     as part of this commit, you might notice that the statePropagator handler had to change from
    delegated (dom.on(MODIFY_EVENT, '*', statePropagator)) to direct
    (dom.on(MODIFY_EVENT, statePropagator)). this is because jQuery event handling always runs
    delegated handlers first. with statePropagator delegated, sorting it after the direct
    modifyBubbler broke jQuery.
     */
    spandrelHandlers.sort(function (_ref3, _ref4) {
      var handler1 = _ref3.handler;
      var handler2 = _ref4.handler;
      return handler1[SPANDREL_HANDLER_PRIORITY] - handler2[SPANDREL_HANDLER_PRIORITY];
    });

    // and put them all back together.
    modifyHandlers.unshift.apply(modifyHandlers, _toConsumableArray(delegates).concat(spandrelHandlers));
  };

  /**
   * Builds out the child widgets of a parent spandrel widget.
   *
   * @param {module:bajaux/Widget} widget the widget whose children we're building out
   * @param {module:bajaux/spandrel~BuildContext} buildContext
   * @param {JQuery} dom
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @returns {Promise}
   */
  workflow.buildChildWidgetsFromSpandrelData = function (widget, buildContext, dom, manager) {
    var members = buildContext.members,
      on = buildContext.on;
    workflow.armHandlers(widget, dom, on);
    var root = widget[ROOT_SYMBOL];
    var kidDepth = widget[DEPTH_SYMBOL] + 1;
    var owner = widget[IS_ELEMENT_SYMBOL] ? widget[OWNER_SYMBOL] : widget;
    return Promise.all(members.map(function (member) {
      var config = member.config;
      var kidDom = cloneNode(config.dom).appendTo(dom);
      return workflow.doFeBuild(member, kidDom, manager, root, owner, kidDepth);
    }));
  };

  /**
   * Build a widget in this element, as configured.
   *
   * @param {module:bajaux/spandrel~Member} member
   * @param {JQuery} dom
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @param {module:bajaux/spandrel/SpandrelWidget} root the root spandrel widget
   * @param {module:bajaux/spandrel/SpandrelWidget} owner the widget who will own the new widget
   * being created (see {@link module:bajaux/spandrel/symbols.OWNER_SYMBOL})
   * @param {number} depth the depth we're building at in the spandrel widget tree
   * @returns {Promise.<module:bajaux/Widget>} the built widget
   */
  workflow.doFeBuild = function (_ref5, dom, manager, root, owner, depth) {
    var key = _ref5.key,
      stateBinding = _ref5.stateBinding,
      lax = _ref5.lax,
      config = _ref5.config;
    return tryToDetermineType(config, manager, owner).then(function (type) {
      dom[0].spandrelKey = key;
      if (stateBinding) {
        dom[0][STATE_BINDING_SYMBOL] = stateBinding;
      }
      if (lax) {
        dom[0][LAX_SYMBOL] = true;
      }
      var data = extend({
        manager: manager
      }, config.data);
      // if we're bound to state, we want LOAD_EVENTs to fire when a new
      // widget appears so the bound state picks up the brand-new value
      var $quiet = !(config.properties && config.properties.$quiet === false);
      var params = extend({
        $constructorParams: {
          $quiet: $quiet
        },
        layoutParams: {
          quick: true
        }
      }, config, {
        data: data,
        dom: dom,
        type: type
      });
      return manager.makeFor(params).then(function (ed) {
        workflow.trackRenders(ed);
        ed[OWNER_SYMBOL] = owner;
        RequestLayoutMixin(ed, root || ed, depth, function (err, widget) {
          return manager.error(err, widget);
        });
        return manager.buildFor(params, ed);
      }).then(function (newKid) {
        setValidationOfDescendent(owner, newKid, config.validate);
        return newKid;
      });
    });
  };

  /**
   * @returns {number} incremented tick number
   */
  workflow.nextTicks = function () {
    // if somebody performs 9 quadrillion renders without having to reload
    // the page... good for us!
    if (ticks === Number.MAX_SAFE_INTEGER) {
      ticks = Number.MIN_SAFE_INTEGER;
    }
    return ticks++;
  };

  /**
   * Call this on a widget being constructed into a `spandrel` widget's widget tree.
   *
   * Every time a widget has a value loaded in, it will simply increment the render ticks. This
   * allows `spandrel` to make decisions regarding who loaded a value in before who.
   *
   * @param {module:bajaux/Widget} widget
   */
  workflow.trackRenders = function (widget) {
    if (!widget[RENDER_TICKS_SYMBOL]) {
      widget[RENDER_TICKS_SYMBOL] = -1;
      var load = widget.load;
      widget.load = function (value, loadParams) {
        var timingDetailsLoggable = areTimingDetailsLoggable();
        var ticks = loadParams && loadParams[RENDER_TICKS_SYMBOL];
        if (ticks) {
          if (timingDetailsLoggable) {
            logTimingDetails(this, 'trackRenders: #load called and setting instance ticks {} enforced by loadParams', ticks);
          }
        } else {
          ticks = workflow.nextTicks();
          if (timingDetailsLoggable) {
            logTimingDetails(this, 'trackRenders: #load called with no enforced ticks - setting incremented instance ticks {}', ticks);
          }
        }
        this[RENDER_TICKS_SYMBOL] = ticks;
        return load.call(this, value, loadParams);
      };
    }
  };
  return workflow;
  function spandrelWidget(arg, params) {
    return spandrel()(arg, params);
  }

  /**
   * @param {string[]} selectors array of widget selectors
   * @param {string} path actual path to a queried widget
   * @returns {boolean}
   */
  function anyPathMatches(selectors, path) {
    return any(selectors, function (selector) {
      return pathMatches(path, selector);
    });
  }
  function logAndRethrow(err) {
    logSevere(err);
    throw err;
  }

  /**
   * Given a config from a Spandrel member, determine what kind of widget
   * Spandrel should show for it.
   * @param {module:bajaux/lifecycle/WidgetManager~BuildParams} config the
   * `config` property from a Spandrel member
   * @param {module:bajaux/lifecycle/WidgetManager} manager
   * @param {module:bajaux/spandrel/SpandrelWidget} owner the widget who will own the new widget
   * being created (see {@link module:bajaux/spandrel/symbols.OWNER_SYMBOL})
   * @returns {Promise.<Function>} promise to be resolved with the kind of
   * widget to show. If none is specified or it can't figure it out, default to
   * Widget which will do nothing but show some raw HTML.
   */
  function tryToDetermineType(config, manager, owner) {
    var kids = config.kids;
    if (kids) {
      var members = kids.members,
        on = kids.on;
      return Promise.resolve(spandrelWidget({
        kids: members,
        on: on
      }, _defineProperty(_defineProperty({}, IS_ELEMENT_SYMBOL, true), "manager", manager)));
    }
    return manager.buildContext(extend({
      formFactor: 'mini'
    }, config)).then(function (buildContext) {
      return buildContext.widgetConstructor || ElementWidget;
    });
  }
});
