function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/httpClient/rc/MultiAddOptionsEditor
 */
define(['baja!', 'bajaux/commands/Command', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/CommandButton', 'bajaux/spandrel', 'jquery', 'lex!httpClient,baja', 'nmodule/httpClient/rc/column/PropertyPathEditorMgrColumn', 'nmodule/httpClient/rc/MultiAddSlotPicker', 'nmodule/webEditors/rc/fe/baja/IntegerEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/table/model/TableModel', 'nmodule/webEditors/rc/wb/table/Table', 'Promise', 'underscore'], function (baja, Command, subscriberMixIn, CommandButton, spandrel, $, lexs, PropertyPathEditorMgrColumn, MultiAddSlotPicker, IntegerEditor, DepthSubscriber, TableModel, Table, Promise, _) {
  'use strict';

  var MAX_COLS = 4,
    MAX_ROWS = 50,
    MAX_PROPERTY_DEPTH = 4,
    _lexs = _slicedToArray(lexs, 2),
    httpClientLex = _lexs[0],
    bajaLex = _lexs[1];
  var widgetDefaults = function widgetDefaults() {
    return {
      keyName: 'MultiAddOptionsEditor',
      moduleName: 'httpClient',
      properties: {
        rootCssClass: '-t-MultiAddOptionsEditor'
      }
    };
  };

  /**
   * A field editor for editing httpClient:MultiAddOptions instances.
   *
   * @class
   * @extends module:bajaux/spandrel/SpandrelWidget
   * @alias module:nmodule/httpClient/rc/MultiAddOptionsEditor
   * @since Niagara 4.14
   */
  return /*#__PURE__*/function (_spandrel) {
    function MultiAddOptionsEditor(params) {
      var _this;
      _classCallCheck(this, MultiAddOptionsEditor);
      _this = _callSuper(this, MultiAddOptionsEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      subscriberMixIn(_this);
      _this.$subscriber = new DepthSubscriber(MAX_PROPERTY_DEPTH);
      _this.$tableModel = new TableModel();
      _this.$addPropertyCmd = new Command({
        icon: httpClientLex.get('multiAddOptionsEditor.add.property.cmd.icon'),
        func: function func() {
          return _this.$changeRows().then(function () {
            return _this.$addColumns();
          });
        }
      });
      return _this;
    }

    /**
     * Saves a json string to the toCreateJson property
     * @returns {Promise}
     */
    _inherits(MultiAddOptionsEditor, _spandrel);
    return _createClass(MultiAddOptionsEditor, [{
      key: "doSave",
      value: function doSave() {
        var _this2 = this;
        var options = this.value();
        return this.$makeToCreateJson().then(function (jsonStr) {
          options.setToCreate(jsonStr);
          return _superPropGet(MultiAddOptionsEditor, "doSave", _this2, 3)([]);
        });
      }

      /**
       * Returns a list of strings to use the select option for the dropdown.
       *
       * @private
       * @returns {Promise.<Array.<String>>} Promise that resolves to a list of strings
       */
    }, {
      key: "$buildPropertiesList",
      value: function $buildPropertiesList() {
        var _this3 = this;
        var targetToDuplicate = this.$getTargetToDuplicate(this.value());
        var propertiesList = [];
        return this.getSubscriber().subscribe(targetToDuplicate).then(function () {
          var hasReadonlyFlag = function hasReadonlyFlag(slot, target) {
            return !!(target.getFlags(slot) & baja.Flags.READONLY);
          };
          var hasHiddenFlag = function hasHiddenFlag(slot, target) {
            return !!(target.getFlags(slot) & baja.Flags.HIDDEN);
          };
          var _addToList = function addToList(list, target, prefix, depth) {
            depth++;
            var arr = target.getSlots().properties().toArray();
            _.each(arr, function (prop) {
              if (prop.getName() !== 'enabled' &&
              // leave enabled off the list, it gets overridden to false anyway, see MultiAddUtil#disable
              !hasReadonlyFlag(prop, target) && !hasHiddenFlag(prop, target)) {
                if (prop.getType().isSimple()) {
                  list.push(prefix + prop.getName());
                } else if (prop.getType().isComplex() && depth <= MAX_PROPERTY_DEPTH) {
                  _addToList(list, target.get(prop), prefix + prop.getName() + '.', depth);
                }
              }
            });
          };
          _addToList(propertiesList, targetToDuplicate, '', 1);
          return _this3.getSubscriber().unsubscribe(targetToDuplicate);
        }).then(function () {
          return propertiesList;
        });
      }

      /**
       * Create json for the toCreate property.
       * It expects a JSON string populated by the client in the following form:
       * {
       *   "newInstanceName" : {
       *     "propertyName" : "encodedValue",
       *     "nested.propertyName" : "encodedValue"
       *   },
       *   "newInstanceName2" : ......
       *  }
       * @see BMultiAddOptions#toCreate
       *
       * @private
       * @returns {Promise.<String>} Promise that resolves to a JSON string
       */
    }, {
      key: "$makeToCreateJson",
      value: function $makeToCreateJson() {
        var columns = this.$getTableModel().getColumns(),
          numberOfColumns = columns.length,
          numberOfRows = this.$getTableModel().getRowCount();
        if (numberOfColumns === 0 || numberOfRows === 0) {
          // default to empty json in case user simply presses ok
          return Promise.resolve('{}');
        }
        var toCreateStr = '';
        var makeRowStr = function makeRowStr(row, cols) {
          var nameCol = cols[0],
            nameColEditor = nameCol.getEditorFor(row);
          var returnStr = '';
          return nameColEditor.read().then(function (readVal) {
            // for the name col, make it a valid slot name
            returnStr += '"' + baja.SlotPath.escape(readVal) + '":' + '{';
            var columnPromises = [];
            for (var i = 1; i < cols.length; i++) {
              columnPromises.push(makeColumnStr(cols[i], cols[i].getEditorFor(row)));
            }
            return Promise.all(columnPromises);
          }).then(function (columnStrings) {
            returnStr += columnStrings.join(',') + '}';
            return returnStr;
          });
        };
        var getValueForJson = function getValueForJson(val) {
          return baja.hasType(val, 'baja:String') ? JSON.stringify(val).slice(1, -1) :
          // remove leading and trailing quotes
          val.encodeToString();
        };
        var makeColumnStr = function makeColumnStr(col, editor) {
          return editor.read().then(function (readVal) {
            return '"' + col.getEditorColumnPropertyName() + '":"' + getValueForJson(readVal) + '"';
          });
        };
        var rowPromises = [];
        for (var i = 0; i < numberOfRows; i++) {
          rowPromises.push(makeRowStr(this.$getTableModel().getRow(i), columns));
        }
        return Promise.all(rowPromises).then(function (rowStrings) {
          toCreateStr += '{';
          _.each(rowStrings, function (rowString, index) {
            toCreateStr += rowString;
            if (index < rowStrings.length - 1) {
              toCreateStr += ',';
            }
          });
          toCreateStr += '}';
          return toCreateStr;
        });
      }

      /**
       * Change the number of rows in the model
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$changeRows",
      value: function $changeRows() {
        var _this4 = this;
        var currentNumberOfRows = this.$getTableModel().getRowCount(),
          totalPicker = this.$getTotalPicker(),
          tableModel = this.$getTableModel();
        return totalPicker.validate().then(function () {
          return totalPicker.read();
        }).then(function (number) {
          var numberOfRows = number.valueOf();
          if (numberOfRows === currentNumberOfRows) {
            return;
          }
          if (numberOfRows === 0) {
            return tableModel.clearRows();
          }

          // adding rows
          if (numberOfRows > currentNumberOfRows) {
            var subject = _this4.$getTargetToDuplicate(_this4.value()),
              numberOfRowsToAdd = Math.min(numberOfRows - currentNumberOfRows, MAX_ROWS),
              rowsToAdd = [];
            for (var i = 0; i < numberOfRowsToAdd; i++) {
              var subjectClone = subject.newCopy(true);
              subjectClone.add({
                slot: 'newName',
                value: ''
              });
              rowsToAdd.push(_this4.$getTableModel().makeRow(subjectClone));
            }
            return _this4.$getTableModel().insertRows(rowsToAdd);
          }

          // if we are here it must be: (numberOfRows < currentNumberOfRows), so we are removing rows
          return _this4.$getTableModel().removeRows(numberOfRows - 1, currentNumberOfRows - 1);
        });
      }

      /**
       * Add columns to the model
       *
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$addColumns",
      value: function $addColumns() {
        var _this5 = this;
        var currentNumberOfColumns = this.$getTableModel().getColumns().length;
        if (currentNumberOfColumns === 0) {
          this.$getTableModel().insertColumns([new PropertyPathEditorMgrColumn('newName', {
            displayName: bajaLex.get('name')
          })]);
        }
        if (currentNumberOfColumns >= MAX_COLS) {
          return Promise.resolve();
        }
        var slotToAdd;
        return this.$getSlotPicker().read().then(function (chosen) {
          slotToAdd = chosen;
          return _this5.$getTableModel().insertColumns([new PropertyPathEditorMgrColumn(slotToAdd)]);
        }).then(function () {
          var updatedNumberOfColumns = _this5.$getTableModel().getColumns().length;
          if (updatedNumberOfColumns === MAX_COLS) {
            // disable the add button
            _this5.$addPropertyCmd.setEnabled(false);
          }

          // Remove the added slot from the dropdown
          _this5.$getSlotPicker().removeFromList(slotToAdd);
          // Reset the selected option in the dropdown
          return _this5.$getSlotPicker().load(_this5.$getSlotPicker().getPossibleSlotsList()[0]);
        });
      }

      /**
       * Return the HttpClientProxyExt that is populated on the MultiAddOptions instance
       * @see {@link module:nmodule/httpClient/rc/baja/HttpClientProxyExt}
       *
       * @private
       * @param options
       * @returns {baja.Component} an instance of httpClient:HttpClientProxyExt
       */
    }, {
      key: "$getTargetToDuplicate",
      value: function $getTargetToDuplicate(options) {
        return options.$targetToDuplicate;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/wb/table/model/TableModel}
       */
    }, {
      key: "$getTableModel",
      value: function $getTableModel() {
        return this.$tableModel;
      }

      /**
       * @private
       * @returns {module:nmodule/webEditors/rc/fe/baja/IntegerEditor}
       */
    }, {
      key: "$getTotalPicker",
      value: function $getTotalPicker() {
        return this.queryWidget('totalEditor');
      }

      /**
       * @private
       * @returns {module:nmodule/httpClient/rc/MultiAddSlotPicker}
       */
    }, {
      key: "$getSlotPicker",
      value: function $getSlotPicker() {
        return this.queryWidget('**/slotPicker');
      }
    }]);
  }(spandrel(function (multiAddOptions, _ref) {
    var self = _ref.self;
    return self.$buildPropertiesList().then(function (choices) {
      return [spandrel.jsx(IntegerEditor, {
        className: "-t-TotalEditor editor",
        spandrelKey: "totalEditor",
        value: baja.Integer.make(1),
        properties: {
          min: 0,
          max: MAX_ROWS,
          precision: 0,
          prelabel: httpClientLex.get('totalLabel')
        }
      }), spandrel.jsx("div", {
        className: "-t-slot-selection"
      }, spandrel.jsx("div", null, httpClientLex.get('slotsLabel')), spandrel.jsx(MultiAddSlotPicker, {
        spandrelKey: "slotPicker",
        value: choices[0],
        properties: {
          choices: choices
        }
      }), spandrel.jsx(CommandButton, {
        tagName: "button",
        className: "ux-btn",
        type: "button",
        value: self.$addPropertyCmd,
        spandrelKey: "addPropertyButton"
      })), {
        dom: $('<table class="ux-table"/>'),
        type: Table,
        value: self.$getTableModel()
      }];
    });
  }, {
    strategy: 'niagara'
  }));
});
