function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'baja!lonworks:RouterEntry', 'lex!lonworks', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/webEditors/rc/wb/table/model/Column', 'nmodule/webEditors/rc/wb/table/tree/TreeTableModel'], function (baja, types, lexs, PropertyMgrColumn, Column, TreeTableModel) {
  'use strict';

  var LON_ROUTER_ENTRY_TYPE = baja.lt('lonworks:RouterEntry');
  var _lexs = _slicedToArray(lexs, 1),
    LEX_LON = _lexs[0];
  var _Column$flags = Column.flags,
    EDITABLE = _Column$flags.EDITABLE,
    READONLY = _Column$flags.READONLY,
    UNSEEN = _Column$flags.UNSEEN;
  var makePropertyMgrColumn = function makePropertyMgrColumn(colName, flags, displayName) {
    return new PropertyMgrColumn(colName, {
      type: LON_ROUTER_ENTRY_TYPE,
      flags: flags,
      displayName: displayName
    });
  };

  /**
   * A bajaux Lon Router Learn Model
   *
   * API Status: **Private**
   * @since Niagara 4.14
   * @exports nmodule/lonworks/rc/wb/mgr/model/LonRouterLearnModel
   */

  var exports = {};

  /**
  * @returns {Promise.<module:nmodule/webEditors/rc/wb/table/tree/TreeTableModel>}
  */
  exports.make = function () {
    return TreeTableModel.make({
      columns: [makePropertyMgrColumn('routerType', EDITABLE, LEX_LON.get('router.columnTitle.rtrType')), makePropertyMgrColumn('mode', EDITABLE, LEX_LON.get('router.columnTitle.rtrMode')), makePropertyMgrColumn('state', EDITABLE, LEX_LON.get('router.columnTitle.state')), makePropertyMgrColumn('nearChannel', EDITABLE, LEX_LON.get('router.columnTitle.nearChannelId')), makePropertyMgrColumn('nearAddress', EDITABLE, LEX_LON.get('router.columnTitle.nearAdr')), makePropertyMgrColumn('farChannel', EDITABLE, LEX_LON.get('router.columnTitle.farChannelId')), makePropertyMgrColumn('farAddress', EDITABLE, LEX_LON.get('router.columnTitle.farAdr')), makePropertyMgrColumn('neuronId', EDITABLE, LEX_LON.get('router.columnTitle.neuronId')), makePropertyMgrColumn('farNeuronId', EDITABLE | READONLY | UNSEEN, LEX_LON.get('router.columnTitle.farNeuronId'))]
    });
  };
  return exports;
});
