function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/lonworks/rc/wb/UxLonUtilitiesManager
 */

define(["baja!", 'baja!lonworks:UtilitiesCommand', 'lex!lonworks', "jquery", "Promise", 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'bajaux/spandrel', 'bajaux/mixin/subscriberMixIn', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/job/JobBar'], function (baja, types, lexs, $, Promise, Command, CommandButton, spandrel, subscriberMixIn, asyncUtils, OrderedMapEditor, DepthSubscriber, JobBar) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    LON_WORK_LEX = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: "-t-UxLonUtilitiesManager"
      }
    };
  };

  /**
   * Adds the entry identified by the key from the supplied enum value to the ordinal and tag lists
   * @private
   * @param {baja.Enum} enumValue the enum value to get the entry from
   * @param {String} enumKey the key to lookup for the enum entry
   * @param {Object} ordinalList contains the selected enums using their display name as their key
   */
  function addMapEntry(enumValue, enumKey, ordinalList) {
    var enumEntry = enumValue.get(enumKey);
    if (enumEntry) {
      ordinalList[enumEntry.getDisplayTag()] = enumEntry;
    }
  }

  /**
   * Ux LonUtilitiesManager view
   *
   * @class
   * @alias module:nmodule/lonworks/rc/wb/UxLonUtilitiesManager
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
  */
  var UxLonUtilitiesManager = /*#__PURE__*/function (_spandrel) {
    function UxLonUtilitiesManager(params) {
      var _this;
      _classCallCheck(this, UxLonUtilitiesManager);
      _this = _callSuper(this, UxLonUtilitiesManager, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      _this.$subscriber = new DepthSubscriber(5);
      subscriberMixIn(_this);
      _this.$executeCmd = new Command({
        displayName: LON_WORK_LEX.get('lonUtilitiesManager.execute.command.label'),
        func: function func() {
          return _this.$execute();
        }
      });
      return _this;
    }

    /**
     * TODO: NCCB-62120
     * the right/expected thing would be onUxModify={() => false}
     */
    _inherits(UxLonUtilitiesManager, _spandrel);
    return _createClass(UxLonUtilitiesManager, [{
      key: "setModified",
      value: function setModified() {}
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        this.$loadDevicesMap(value);
        return _superPropGet(UxLonUtilitiesManager, "doLoad", this, 3)(arguments);
      }
    }, {
      key: "$buildEditor",
      value: function $buildEditor() {
        var _this2 = this;
        return [spandrel.jsx("div", null, spandrel.jsx(JobBar, {
          spandrelKey: "jobBar"
        }), spandrel.jsx("textarea", {
          className: "-t-responseConsole",
          spandrelKey: "responseConsole",
          rows: "24",
          cols: "80",
          readOnly: true
        }), spandrel.jsx("div", null, spandrel.jsx("table", null, spandrel.jsx("tr", null, spandrel.jsx("td", null, LON_WORK_LEX.get('lonUtilitiesManager.device.label')), spandrel.jsx("td", {
          colSpan: "3"
        }, spandrel.jsx(OrderedMapEditor, {
          value: this.$devicesMap,
          className: "-t-deviceSelection",
          spandrelKey: "deviceSelection",
          onUxModifiedValue: function onUxModifiedValue(newDevice) {
            return _this2.$deviceSelected(newDevice);
          }
        })), spandrel.jsx("td", {
          className: "-t-commandButtonCell",
          rowSpan: "2"
        }, spandrel.jsx(CommandButton, {
          tagName: "button",
          type: "button",
          spandrelKey: "executeCommand",
          value: this.$executeCmd
        }))), spandrel.jsx("tr", null, spandrel.jsx("td", null, LON_WORK_LEX.get('lonUtilitiesManager.command.label')), spandrel.jsx("td", null, spandrel.jsx(OrderedMapEditor, {
          spandrelKey: "commandEnum",
          value: this.$commandMap,
          lax: true,
          onUxModifiedValue: function onUxModifiedValue(newCommand) {
            return _this2.$commandSelected(newCommand);
          }
        })), spandrel.jsx("td", {
          className: "-t-subCommandCell"
        }, spandrel.jsx("div", {
          className: "-t-subCommand-section",
          style: {
            display: !this.$visibleMemPane || 'none'
          }
        }, spandrel.jsx("span", {
          className: "-t-subCommand-entry"
        }, LON_WORK_LEX.get('lonUtilitiesManager.subCommand.label')), spandrel.jsx(OrderedMapEditor, {
          value: this.$subCommandMap,
          lax: true,
          spandrelKey: "subCommandEnum",
          className: "-t-subCommand-input",
          onUxModifiedValue: function onUxModifiedValue(newCommand) {
            return _this2.$subCommandSelected(newCommand);
          }
        })), spandrel.jsx("div", {
          className: "-t-subCommand-section -t-subCommand-other",
          style: {
            display: this.$showOther && !this.$visibleMemPane || 'none'
          }
        }, spandrel.jsx("span", {
          className: "-t-subCommand-entry"
        }, LON_WORK_LEX.get('lonUtilitiesManager.otherFile.label')), spandrel.jsx("any", {
          value: "",
          spandrelKey: "otherFile",
          className: "-t-subCommand-input"
        }))), spandrel.jsx("td", null, spandrel.jsx("div", {
          className: "-t-subCommand-memory",
          style: {
            display: this.$visibleMemPane || 'none'
          }
        }, spandrel.jsx("span", {
          className: "-t-subCommand-entry"
        }, LON_WORK_LEX.get('lonUtilitiesManager.readMem.address')), spandrel.jsx("any", {
          value: "",
          spandrelKey: "memAddress",
          className: "-t-subCommand-input"
        }), spandrel.jsx("span", {
          className: "-t-subCommand-entry"
        }, LON_WORK_LEX.get('lonUtilitiesManager.readMem.len')), spandrel.jsx("any", {
          value: "",
          spandrelKey: "memLength",
          className: "-t-subCommand-input"
        })))))))];
      }

      /**
       * Retrieves the values from the view and then starts the process to execute the command.
       * @private
       * @returns {Promise<*>}
       */
    }, {
      key: "$execute",
      value: function $execute() {
        var _this3 = this;
        var lonNetwork = this.value();
        var action = lonNetwork.getSlot("executeCommand");
        var responseConsole = this.$getResponseConsole();
        if (action) {
          return this.$getExecuteCommand().setEnabled(false).then(function () {
            return Promise.all([_this3.$getDeviceSelection().read(), _this3.$getCommandSelection().read(), _this3.$getSubCommandSelection().read(), _this3.$getMemAddress().read(), _this3.$getMemLength().read(), _this3.$getOtherFile().read(), baja.AbsTime.now().toString({
              showSeconds: true
            })]);
          }).then(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 7),
              device = _ref2[0],
              command = _ref2[1],
              subCommand = _ref2[2],
              memAddress = _ref2[3],
              memLength = _ref2[4],
              otherFile = _ref2[5],
              executeDate = _ref2[6];
            responseConsole.text(executeDate + "\n\n");
            return _this3.$buildCommand(device, command, subCommand, memAddress, memLength, otherFile);
          }).then(function (jobCommand) {
            return _this3.$executeCommand(lonNetwork, action, jobCommand);
          })["finally"](function () {
            _this3.$getExecuteCommand().setEnabled(true);
          });
        }
      }

      /**
       * Builds the command to be executed based on the supplied parameters
       * @private
       * @param {baja.Complex} device the device the command is to be run on
       * @param {baja.DynamicEnum} command the command selected by the user to run
       * @param {baja.DynamicEnum} subCommand the sub command selected by the user to run
       * @param {String} memAddress the memory address, in base 16, to be used to run the command
       * @param {String} memLength the length, in base 16, of the memory segement to be read
       * @param {String} otherFile the file number, in base 16, that is to be used
       * @returns {baja.Component} the utilties command that is to be run
       */
    }, {
      key: "$buildCommand",
      value: function $buildCommand(device, command, subCommand, memAddress, memLength, otherFile) {
        var deviceType = device.getType();
        var utilCmd = baja.$('lonworks:UtilitiesCommand');
        if (subCommand) {
          command = subCommand;
        }
        utilCmd.setCommand(command);
        if (deviceType.is('lonworks:DeviceEntry')) {
          utilCmd.setIsDevice(true);
          utilCmd.setSubnetNodeId(baja.$('lonworks:SubnetNode').make({
            subnetId: device.getSubnet(),
            nodeId: device.getNode()
          }));
          utilCmd.setNeuronId(device.getNeuronId());
          //TODO replace this with device.getUtilName() if a type extension is created for DeviceEntry
          utilCmd.setDisplayName1(this.$getDeviceUtilName(device));
        } else if (deviceType.is('lonworks:RouterEntry')) {
          utilCmd.setIsDevice(false);
          utilCmd.setSubnetNodeId(device.getNearAddress());
          utilCmd.setNeuronId(device.getNeuronId());
          //TODO replace this with device.getUtilName() if a type extension is created for RouterEntry
          utilCmd.setDisplayName1(this.$getRouterUtilName(device));
        } else {
          var isLonDevice = deviceType.is('lonworks:LonDevice');
          var deviceData;
          if (isLonDevice) {
            deviceData = device.getDeviceData();
          } else {
            deviceData = device.getNearDeviceData();
          }
          utilCmd.setIsDevice(isLonDevice);
          utilCmd.setSubnetNodeId(deviceData.getSubnetNodeId());
          utilCmd.setNeuronId(deviceData.getNeuronId());
          utilCmd.setDisplayName1(device.getName());
          utilCmd.setMemAddr(parseInt(memAddress, 16) || -1);
          utilCmd.setCount(parseInt(memLength, 16) || -1);
          utilCmd.setFileNum(parseInt(otherFile, 16) || -1);
        }
        return utilCmd;
      }

      /**
       * Executes the command that has been created
       * @private
       * @param {baja.Component} lonNetwork the network the command is to be run on
       * @param {baja.Slot} action the slot of the 'executeCommand'
       * @param {baja.Component} command the command to be executed
       * @returns {Promise<*>}
       */
    }, {
      key: "$executeCommand",
      value: function $executeCommand(lonNetwork, action, command) {
        var _this4 = this;
        var jobBar = this.$getJobBar();
        var base = this.value();
        return base.getComponentSpace().sync().then(function () {
          return lonNetwork.invoke({
            slot: action,
            value: command
          });
        }).then(function (ord) {
          return ord.resolve({
            base: base
          });
        }).then(function (jobOrd) {
          return jobOrd.getComponent();
        }).then(function (job) {
          var textArea = _this4.$getResponseConsole();
          jobBar.load(job);
          return _this4.$getTextChunk(job, textArea);
        });
      }

      /**
       * Returns the next chunk of text from the job
       * @private
       * @param {baja.Component} job the component for the job
       * @param {JQuery} textArea the text area to display the resulting text in
       * @returns {Promise<*>}
       */
    }, {
      key: "$getTextChunk",
      value: function $getTextChunk(job, textArea) {
        var _this5 = this;
        return asyncUtils.waitInterval(100).then(function () {
          return job.getText().then(function (text) {
            if (text !== null) {
              var newText = textArea.text() + text;
              textArea.text(newText);
              return _this5.$getTextChunk(job, textArea);
            }
          });
        });
      }

      /**
       * This is here to supply an utilName for a BDeviceEntry, until a TypeExtn is made for it, if that is the decision
       * @private
       * @param {baja.Component} device the LonWorks BDeviceEntry to be used to create the util name
       * @returns {string} the generated util name
       */
    }, {
      key: "$getDeviceUtilName",
      value: function $getDeviceUtilName(device) {
        //TODO: This should be switched from getDisplayTag() to getConvertedName() once NCCB-62618 is done
        return device.getSubnet() + "/" + device.getNode() + "," + device.getMfgId().getDisplayTag() + "," + device.getProgramId();
      }

      /**
       * This is here to supply an utilName for a BRouterEntry, until a TypeExtn is made for it, if that is the decision
       * @private
       * @param {baja.Component} router the LonWorks BRouterEntry to be used to create the util name
       * @returns {string} the generated util name
       */
    }, {
      key: "$getRouterUtilName",
      value: function $getRouterUtilName(router) {
        return router.getNearChannel() + ":" + router.getNearAddress() + "," + router.getFarChannel() + ":" + router.getFarAddress();
      }

      /**
       * Loads the command enum selector based on the device selected
       * @private
       * @param {baja.Component} newDevice the device that was just selected
       */
    }, {
      key: "$deviceSelected",
      value: function $deviceSelected(newDevice) {
        var commandEnum = baja.$('lonworks:UtilCommandEnum');
        var commandMap = this.$commandMap = {};
        this.$setDeviceFlags(newDevice);
        addMapEntry(commandEnum, "status", commandMap);
        addMapEntry(commandEnum, "dataStructs", commandMap);
        if (!this.$isRouterSelected && !this.$isDiscoveredSelected) {
          addMapEntry(commandEnum, "file", commandMap);
        }
        addMapEntry(commandEnum, "identify", commandMap);
        addMapEntry(commandEnum, "reports", commandMap);
        addMapEntry(commandEnum, "readMem", commandMap);
        addMapEntry(commandEnum, "find", commandMap);
        var commandEditor = this.$getCommandSelection();
        if (commandEditor) {
          return commandEditor.loadAndModify(commandMap);
        }
        var Status = commandMap.Status;
        return this.$commandSelected(Status);
      }

      /**
       * Actions to be taken when a command is selected, mainly building the list of sub commands
       * @private
       * @param {baja.Enum} newCommand the enum entry that was selected
       */
    }, {
      key: "$commandSelected",
      value: function $commandSelected(newCommand) {
        if (newCommand.getType().is('baja:Enum')) {
          var commandEnum = baja.$('lonworks:UtilCommandEnum');
          var subCommandMap = this.$subCommandMap = {};
          this.$visibleMemPane = false;
          switch (newCommand.getTag()) {
            case "find":
            case "disableAuthentication":
            case "test":
              break;
            case "status":
              addMapEntry(commandEnum, "display", subCommandMap);
              addMapEntry(commandEnum, "clear", subCommandMap);
              addMapEntry(commandEnum, "setUnconfigured", subCommandMap);
              addMapEntry(commandEnum, "setOnline", subCommandMap);
              addMapEntry(commandEnum, "reset", subCommandMap);
              if (this.$allowCalcChecksum() && !this.$isLocalSelected) {
                addMapEntry(commandEnum, "recalcChecksum", subCommandMap);
              }
              break;
            case "file":
              addMapEntry(commandEnum, "fileDirectory", subCommandMap);
              addMapEntry(commandEnum, "configTemplateFile", subCommandMap);
              addMapEntry(commandEnum, "configValueFile", subCommandMap);
              addMapEntry(commandEnum, "other", subCommandMap);
              break;
            case "identify":
              addMapEntry(commandEnum, "wink", subCommandMap);
              addMapEntry(commandEnum, "servicePin", subCommandMap);
              addMapEntry(commandEnum, "clearServicePin", subCommandMap);
              break;
            case "dataStructs":
              addMapEntry(commandEnum, "addressTable", subCommandMap);
              addMapEntry(commandEnum, "domainTable", subCommandMap);
              addMapEntry(commandEnum, "readOnlyStructure", subCommandMap);
              addMapEntry(commandEnum, "configStructure", subCommandMap);
              if (!this.$isLocalSelected && !this.$isRouterSelected) {
                addMapEntry(commandEnum, "nvAliasTable", subCommandMap);
                addMapEntry(commandEnum, "nvConfig", subCommandMap);
                addMapEntry(commandEnum, "nvValue", subCommandMap);
              }
              if (!this.$isLocalSelected) {
                addMapEntry(commandEnum, "selfDocumentation", subCommandMap);
              }
              if (this.$isRouterSelected) {
                addMapEntry(commandEnum, "routeTables", subCommandMap);
              }
              break;
            case "reports":
              addMapEntry(commandEnum, "netmgmtSummary", subCommandMap);
              addMapEntry(commandEnum, "programIds", subCommandMap);
              addMapEntry(commandEnum, "transmitErrors", subCommandMap);
              addMapEntry(commandEnum, "transmitErrorsNoClear", subCommandMap);
              addMapEntry(commandEnum, "verifyChannels", subCommandMap);
              addMapEntry(commandEnum, "networkSummary", subCommandMap);
              if (!this.$isDiscoveredSelected) {
                addMapEntry(commandEnum, "verify", subCommandMap);
              }
              break;
            case "readMem":
              this.$visibleMemPane = true;
              break;
          }
          this.$showOther = false;
          var subCommandEditor = this.$getSubCommandSelection();
          if (subCommandEditor) {
            return subCommandEditor.loadAndModify(subCommandMap);
          }
        }
      }

      /**
       * Set the flags about the selected device in the editor that are used by other functions
       * @param newDevice
       */
    }, {
      key: "$setDeviceFlags",
      value: function $setDeviceFlags(newDevice) {
        var deviceType = newDevice.getType();
        this.$isRouterSelected = deviceType.is('lonworks:LonRouter') || deviceType.is('lonworks:RouterEntry');
        this.$isDiscoveredSelected = deviceType.is('lonworks:DeviceEntry') || deviceType.is('lonworks:RouterEntry');
        this.$isLocalSelected = deviceType.is("lonworks:LocalLonDevice");
      }

      /**
       *
       * @private
       * @param {baja.Enum} newCommand the new sub command selected, if it is other under file, then
       * the this.$showOther = true.  It then rerenders the view
       * @returns {*}
       */
    }, {
      key: "$subCommandSelected",
      value: function $subCommandSelected(newCommand) {
        if (newCommand && newCommand.getType().is('baja:Enum')) {
          this.$showOther = newCommand.getOrdinal() === 17;
        }
        return this.rerender();
      }

      /**
       * Determines if the facet AllowCalcChecksum has been set to true
       * @private
       * @return {Boolean}
       */
    }, {
      key: "$allowCalcChecksum",
      value: function $allowCalcChecksum() {
        return this.value().getParent().getFacets().get("AllowCalcCheckSum", false);
      }

      /**
       * Creates the OrderedMap that is used for selecting the devices
       * @private
       * @param {baja.Component} parent the parent component
       */
    }, {
      key: "$loadDevicesMap",
      value: function $loadDevicesMap(parent) {
        var devicesMap = new baja.OrderedMap();
        this.$getDevices(parent, devicesMap, true);
        this.$deviceSelected(devicesMap.getFromIndex(0));
        this.$devicesMap = devicesMap;
      }

      /**
       * Gets the devices for the specified parent
       * @private
       * @param {baja.Component} parent the parent component
       * @param {baja.OrderedMap} devicesMap an ordered map of all the devices that have been found
       * @param {Boolean} top are we at the top (the network level) or in a folder
       */
    }, {
      key: "$getDevices",
      value: function $getDevices(parent, devicesMap, top) {
        this.$addChildren(parent, 'lonworks:LonDevice', devicesMap);
        this.$addChildren(parent, 'lonworks:LonRouter', devicesMap);
        var fds = this.$getChildren(parent, 'lonworks:LonDeviceFolder');
        for (var i = 0; i < fds.length; i++) {
          this.$getDevices(fds[i], devicesMap, false);
        }
        if (top) {
          var deviceTable = parent.getLonNetmgmt().getDeviceDiscoverTable();
          var routerTable = parent.getLonNetmgmt().getRouterDiscoverTable();
          this.$addChildren(deviceTable, 'lonworks:LonDevice', devicesMap);
          this.$addChildren(routerTable, 'lonworks:LonRouter', devicesMap);
        }
      }

      /**
       * Adds the children of the specified type to the devices array and their name to the
       * devicesNames array
       * @private
       * @param {baja.Component} parent the parent component
       * @param {String} typeSpec the type spec to be added
       * @param {baja.OrderedMap} devicesMap an ordered map of all the devices that have been found
       */
    }, {
      key: "$addChildren",
      value: function $addChildren(parent, typeSpec, devicesMap) {
        var _this6 = this;
        var children = this.$getChildren(parent, typeSpec);
        children.forEach(function (child) {
          var name = _this6.$getChildName(child);
          devicesMap.put(name, child);
        });
      }

      /**
       * Determines the name to be used for the child in the devices selection
       * @param {baja.Complex} child the child we want the name for
       * @returns {String}
       */
    }, {
      key: "$getChildName",
      value: function $getChildName(child) {
        var displayName;
        var type = child.getType();
        if (type.is("lonworks:DeviceEntry")) {
          //TODO replace this with device.getUtilName() if a type extension is created for DeviceEntry
          displayName = this.$getDeviceUtilName(child) + ", " + child.getNeuronId();
        } else if (type.is("lonworks:RouterEntry")) {
          //TODO replace this with device.getUtilName() if a type extension is created for RouterEntry
          displayName = this.$getRouterUtilName(child) + ", " + child.getNeuronId();
        } else if (type.is("lonworks:LonDevice")) {
          displayName = child.getDisplayName();
          if (!type.is("lonworks:LocalLonDevice")) {
            displayName = displayName + ", " + child.getDeviceData().getSubnetNodeId();
          }
        } else {
          displayName = child.getDisplayName();
        }
        return baja.SlotPath.unescape(displayName);
      }

      /**
       * Returns an array of complexes that represent the children that match the type spec supplied
       * @private
       * @param {baja.Component} parent the parent that we are going to be getting the children of
       * @param {String} typeSpec the type spec that we are looking for
       */
    }, {
      key: "$getChildren",
      value: function $getChildren(parent, typeSpec) {
        return parent.getSlots().is(typeSpec).toValueArray();
      }

      /**
       * Returns the text area for the responses from executed commands
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getResponseConsole",
      value: function $getResponseConsole() {
        return this.jq().find(".-t-responseConsole");
      }

      /**
       * Returns the JobBar used to show the status of a job
       * @private
       * @returns {JobBar}
       */
    }, {
      key: "$getJobBar",
      value: function $getJobBar() {
        return this.queryWidget("**/jobBar");
      }

      /**
       * Returns the OrderMapEditor for the device selection
       * @private
       * @returns {OrderedMapEditor}
       */
    }, {
      key: "$getDeviceSelection",
      value: function $getDeviceSelection() {
        return this.queryWidget("**/deviceSelection");
      }

      /**
       * Returns the ExecuteCommand
       * @private
       * @returns {CommandButton}
       */
    }, {
      key: "$getExecuteCommand",
      value: function $getExecuteCommand() {
        return this.queryWidget("**/executeCommand");
      }

      /**
       * Returns the EnumEditor for commands
       * @private
       * @returns {DynamicEnumEditor}
       */
    }, {
      key: "$getCommandSelection",
      value: function $getCommandSelection() {
        return this.queryWidget("**/commandEnum");
      }

      /**
       * Returns the Enum Editor for commands
       * @private
       * @returns {DynamicEnumEditor}
       */
    }, {
      key: "$getSubCommandSelection",
      value: function $getSubCommandSelection() {
        return this.queryWidget("**/subCommandEnum");
      }

      /**
       * Returns the String Editor for memory address
       * @private
       * @returns {RelevantStringEditor}
       */
    }, {
      key: "$getMemAddress",
      value: function $getMemAddress() {
        return this.queryWidget("**/memAddress");
      }

      /**
       * Returns the String Editor for memory length
       * @private
       * @returns {RelevantStringEditor}
       */
    }, {
      key: "$getMemLength",
      value: function $getMemLength() {
        return this.queryWidget("**/memLength");
      }

      /**
       * Returns the String Editor for other file
       * @private
       * @returns {RelevantStringEditor}
       */
    }, {
      key: "$getOtherFile",
      value: function $getOtherFile() {
        return this.queryWidget("**/otherFile");
      }
    }]);
  }(spandrel(function (value, state) {
    var self = state.self;
    return self.$buildEditor();
  }, {
    strategy: 'niagara'
  }));
  return UxLonUtilitiesManager;
});
