function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

define(['baja!', 'lex!lonworks', 'Promise', 'bajaux/spandrel', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/baja/IconEditor'], function (baja, lexs, Promise, spandrel, feDialogs, IconEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lonLex = _lexs[0];

  /**
   * API Status: **Private**
   * @class nmodule/lonworks/rc/util/ServicePinMonitor
   * @since Niagara 4.14
   */

  /**
   * Monitors the changes to the service pin job
   */
  return /*#__PURE__*/function () {
    /**
     * @param {module:nmodule/driver/rc/wb/mgr/DeviceMgr} mgr the current manager for the job
     */
    function ServicePinMonitor(mgr) {
      _classCallCheck(this, ServicePinMonitor);
      this.$mgr = mgr;
    }

    /**
     * Attaches the manager to the change event from service pin job
     */
    return _createClass(ServicePinMonitor, [{
      key: "attachToServicePinJob",
      value: function attachToServicePinJob() {
        var _this = this;
        this.$job = this.$mgr.getJob();
        this.$jobChangeHandler = function (prop) {
          _this.$servicePinJobStateChanged(prop);
        };
        this.$job.attach("changed", this.$jobChangeHandler);
        //call the handler to check the initial state
        this.$servicePinJobStateChanged();
      }

      /**
       * Handles the change events triggered from the service pin job
       * @private
       */
    }, {
      key: "$servicePinJobStateChanged",
      value: function $servicePinJobStateChanged() {
        var job = this.$job;
        var type = job.getType();
        if (type.is('lonworks:LonServicePinJob')) {
          var jobState = job.getJobState().getOrdinal();
          var srvPinState = job.getServicePinState().getOrdinal();
          if (jobState !== 1 || srvPinState === 2 || srvPinState === 3) {
            this.$detachFromServicePinJob();
          } else if (srvPinState === 1 && !this.$srvPinDialog) {
            this.$showServicePinJobDialog();
          }
        }
      }

      /**
       * Detaches the manger from the service pin job
       * @private
       */
    }, {
      key: "$detachFromServicePinJob",
      value: function $detachFromServicePinJob() {
        var job = this.$job;
        if (this.$srvPinDialog) {
          this.$closeServicePinJobDialog();
        }
        if (this.$jobChangeHandler) {
          job.detach("changed", this.$jobChangeHandler);
          this.$jobChangeHandler = undefined;
        }
      }

      /**
       * Shows a dialog for the job, that allows for canceling of the job
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showServicePinJobDialog",
      value: function $showServicePinJobDialog() {
        var _this2 = this;
        var job = this.$job;
        var title = lonLex.get('servicePinDialog.title');
        var text = lonLex.get('servicePinDialog.text');
        var icon = baja.Icon.make(lonLex.get('servicePinDialog.icon'));
        return feDialogs.showFor({
          type: spandrel(spandrel.jsx("span", null, spandrel.jsx(IconEditor, {
            value: icon,
            tagName: "span"
          }), spandrel.jsx("span", null, text))),
          value: null,
          title: title,
          buttons: {
            cancel: function cancel() {
              if (job && job.getJobState().getOrdinal() === 1) {
                return job.cancel();
              }
            }
          },
          progressCallback: function progressCallback(msg, editor) {
            switch (msg) {
              case 'initialized':
                {
                  _this2.$srvPinDialog = editor.$dlg;
                }
            }
          }
        });
      }

      /**
       * Closes the dialog when no longer needed
       * @private
       */
    }, {
      key: "$closeServicePinJobDialog",
      value: function $closeServicePinJobDialog() {
        if (this.$srvPinDialog) {
          this.$srvPinDialog.close();
          this.$srvPinDialog = undefined;
        }
      }
    }]);
  }();
});
