function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * Type extension for lonworks:SubNetNode.
 *
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/lonworks/rc/baja/SubnetNode
 */
define(['baja!', 'lex!lonworks', 'underscore'], function (baja, lexs, _) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lonLex = _lexs[0];

  /**
   * @param {number} subnetId
   * @param {number} nodeId
   */
  var validateInput = function validateInput(_ref) {
    var subnetId = _ref.subnetId,
      nodeId = _ref.nodeId;
    var subId = parseInt(subnetId),
      nId = parseInt(nodeId);
    if (isNaN(subId) || !_.isNumber(subId) || subId < 0 || subId > 255 || isNaN(nId) || !_.isNumber(nId) || nId < 0 || nId > 127) {
      throw new Error(lonLex.get({
        key: 'SubnetNode.invalidInput.message',
        args: [subnetId, nodeId]
      }));
    }
  };

  /**
   * @param {String} input
   * @throws {Error} throws Error when input string is not a valid SubnetNode.
   */
  var validateStringToDecode = function validateStringToDecode(input) {
    if (!input || input.split('/').length !== 2) {
      throw new Error(lonLex.get('SubnetNode.invalidInputToDecode.message'));
    }
  };

  /**
   * Type extension for lonworks:SubnetNode.
   *
   * @class
   * @alias module:nmodule/lonworks/rc/baja/SubnetNode
   * @extends baja.Simple
   * @since Niagara 4.14
   */
  var SubnetNode = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Constructor is deemed to be private, use make() to create a SubnetNode.
     *
     * @param {number} subnetId
     * @param {number} nodeId
     */
    function SubnetNode(_ref2) {
      var _this;
      var subnetId = _ref2.subnetId,
        nodeId = _ref2.nodeId;
      _classCallCheck(this, SubnetNode);
      _this = _callSuper(this, SubnetNode);
      validateInput({
        subnetId: subnetId,
        nodeId: nodeId
      });
      _this.$subnetId = parseInt(subnetId);
      _this.$nodeId = parseInt(nodeId);
      return _this;
    }

    /**
     * @returns {number}
     */
    _inherits(SubnetNode, _baja$Simple);
    return _createClass(SubnetNode, [{
      key: "getNodeId",
      value: function getNodeId() {
        return this.$nodeId;
      }

      /**
       * @returns {number}
       */
    }, {
      key: "getSubnetId",
      value: function getSubnetId() {
        return this.$subnetId;
      }

      /**
       * @returns {module:nmodule/lonworks/rc/baja/SubnetNode}
       */
    }, {
      key: "make",
      value:
      /**
       * Makes a `SubnetNode`.
       *
       * @param {number} subnetId
       * @param {number} nodeId
       * @returns {module:nmodule/lonworks/rc/baja/SubnetNode}
       * @throws {Error} If input is invalid to make a SubnetNode.
       */
      function make(_ref3) {
        var subnetId = _ref3.subnetId,
          nodeId = _ref3.nodeId;
        return SubnetNode.make({
          subnetId: subnetId,
          nodeId: nodeId
        });
      }

      /**
       * @returns {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return "".concat(this.$subnetId, "/").concat(this.$nodeId);
      }

      /**
       * @param {String} input
       * @returns {module:nmodule/lonworks/rc/baja/SubnetNode}
       * @throws {Error} If input is invalid to make a SubnetNode.
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(input) {
        validateStringToDecode(input);
        var _input$split = input.split('/'),
          _input$split2 = _slicedToArray(_input$split, 2),
          subnetId = _input$split2[0],
          nodeId = _input$split2[1];
        return SubnetNode.make({
          subnetId: subnetId,
          nodeId: nodeId
        });
      }
    }], [{
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }

      /**
       * @param {number} subnetId
       * @param {number} nodeId
       * @returns {module:nmodule/lonworks/rc/baja/SubnetNode}
       * @throws {Error} If input is invalid to make a SubnetNode.
       */
    }, {
      key: "make",
      value: function make(_ref4) {
        var subnetId = _ref4.subnetId,
          nodeId = _ref4.nodeId;
        return new SubnetNode({
          subnetId: subnetId,
          nodeId: nodeId
        });
      }
    }]);
  }(baja.Simple);
  var DEFAULT = SubnetNode.make({
    subnetId: 0,
    nodeId: 0
  });
  return SubnetNode;
});
