function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * Type extension for lonworks:ProgramId.
 *
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/lonworks/rc/baja/ProgramId
 */
define(['baja!', 'lex!lonworks', 'Promise', 'underscore', 'nmodule/webEditors/rc/util/byteUtils', 'nmodule/lonworks/rc/util/lonUtils'], function (baja, lexs, Promise, _, byteUtils, lonUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    lonLex = _lexs[0],
    getLonManufacturerMap = _.once(function () {
      return lonUtils.getLonManufacturerMap();
    }),
    PROGRAM_ID_LENGTH = 8,
    DELIMITER = ' ',
    RADIX = 16;

  /**
   * @param {Object} input Input byte Object will use the object properties like format, mfrId, deviceClass, deviceSubclass and modelNumber to make the ProgramId.
   * @param {number} input.format
   * @param {number} input.mfrId
   * @param {number} input.deviceClass
   * @param {number} input.deviceSubclass
   * @param {number} input.modelNumber
   * @returns {module:nmodule/lonworks/rc/baja/ProgramId}
   */
  var makeProgramIdFromObject = function makeProgramIdFromObject(input) {
    var format = input.format,
      mfrId = input.mfrId,
      deviceClass = input.deviceClass,
      deviceSubclass = input.deviceSubclass,
      modelNumber = input.modelNumber;
    if (isNaN(format) || isNaN(mfrId) || isNaN(deviceClass) || isNaN(deviceSubclass) || isNaN(modelNumber)) {
      throwInvalidInputError();
    }
    return new ProgramId(new Uint8Array([(format << 4 & 0xf0) + (mfrId >> 16 & 0x0f), mfrId >> 8 & 0xff, mfrId & 0xff, deviceClass >> 8 & 0xff, deviceClass & 0xff, deviceSubclass >> 8 & 0xff, deviceSubclass & 0xff, modelNumber & 0xff]));
  };

  /**
   * @throws {Error} If input is invalid to make a ProgramId.
   */
  var throwInvalidInputError = function throwInvalidInputError() {
    throw new Error(lonLex.get('ProgramId.invalidInput.message'));
  };

  /**
   * Type extension for lonworks:ProgramId.
   *
   * @class
   * @alias module:nmodule/lonworks/rc/baja/ProgramId
   * @extends baja.Simple
   * @since Niagara 4.14
   */
  var ProgramId = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Constructor is deemed to be private, use make() to create ProgramId.
     *
     * @param {Uint8Array} byteArr array of bytes.
     */
    function ProgramId() {
      var _this;
      var byteArr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Uint8Array();
      _classCallCheck(this, ProgramId);
      _this = _callSuper(this, ProgramId);
      if (!(byteArr && byteArr instanceof Uint8Array) || byteArr.length !== PROGRAM_ID_LENGTH) {
        throwInvalidInputError();
      }
      _this.$byteArr = byteArr;
      return _this;
    }

    /**
     * Returns the lookup id for the manufacture from the program id.
     * @returns {number} the lookup id
     */
    _inherits(ProgramId, _baja$Simple);
    return _createClass(ProgramId, [{
      key: "getMfgLookupId",
      value: function getMfgLookupId() {
        var byteArr = this.$byteArr;
        var mfgId = byteArr[0] & 0x0f;
        mfgId = (mfgId << 8) + (byteArr[1] & 0xff);
        mfgId = (mfgId << 8) + (byteArr[2] & 0xff);
        return mfgId;
      }

      /**
       * Returns the converted name for the lon manufacturer id
       *
       * @returns {Promise.<String>}
       */
    }, {
      key: "getMfgId",
      value: function getMfgId() {
        var mfgId = this.getMfgLookupId();
        return getLonManufacturerMap().then(function (lonManufacturerMap) {
          return lonManufacturerMap[mfgId];
        });
      }

      /**
       * @returns {Uint8Array} array of the ProgramId bytes
       */
    }, {
      key: "getByteArray",
      value: function getByteArray() {
        //Return a copy of the byte array to avoid instance modification.
        return this.$byteArr.slice();
      }

      /**
       * @returns {string}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return byteUtils.byteArrayToString(this.$byteArr, DELIMITER, PROGRAM_ID_LENGTH, RADIX);
      }

      /**
       * @param {String} input
       * @returns {module:nmodule/lonworks/rc/baja/ProgramId}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(input) {
        return ProgramId.make(new Uint8Array(byteUtils.stringToByteArray(input, PROGRAM_ID_LENGTH, {
          delimiter: DELIMITER
        }, RADIX)));
      }

      /**
       * @param {Uint8Array|Object} input
       * @returns {module:nmodule/lonworks/rc/baja/ProgramId}
       * @throws {Error} If input is invalid to make a ProgramId.
       */
    }, {
      key: "make",
      value:
      /**
       * Makes a `ProgramId`.
       *
       * @param {Uint8Array|Object} input
       * @param {Uint8Array} input Input type Uint8Array will be used to make the ProgramId.
       * @param {Object} input Input byte Object will use the object properties like format, mfrId, deviceClass, deviceSubclass and modelNumber to make the ProgramId.
       * @param {number} input.format
       * @param {number} input.mfrId
       * @param {number} input.deviceClass
       * @param {number} input.deviceSubclass
       * @param {number} input.modelNumber
       * @returns {module:nmodule/lonworks/rc/baja/ProgramId}
       * @throws {Error} If input is invalid to make a ProgramId.
       */
      function make(input) {
        return ProgramId.make(input);
      }

      /**
       * Returns true if all bytes in ProgramId are Zero.
       *
       * @returns {boolean}
       */
    }, {
      key: "isZero",
      value: function isZero() {
        if (this.$byteArr && this.$byteArr.length) {
          return !this.$byteArr.find(function (_byte) {
            return _byte !== 0;
          });
        }
        return true;
      }
    }], [{
      key: "make",
      value: function make(input) {
        if (input instanceof Uint8Array) {
          return new ProgramId(input);
        }
        if (input instanceof Object) {
          return makeProgramIdFromObject(input);
        }
        throwInvalidInputError();
      }

      /**
       * @returns {module:nmodule/lonworks/rc/baja/ProgramId}
       */
    }, {
      key: "DEFAULT",
      get: function get() {
        return DEFAULT;
      }
    }]);
  }(baja.Simple);
  var DEFAULT = ProgramId.make(new Uint8Array([0, 0, 0, 0, 0, 0, 0, 0]));
  return ProgramId;
});
