/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/ace/rc/AcePointManager
 */
define(['underscore', 'nmodule/ndriver/rc/NPointManager', 'nmodule/webEditors/rc/wb/mgr/commands/NewCommand'], function (_, NPointManager, NewCommand) {
  'use strict';

  /**
   * A bajaux Point Manager View for the AceIpDriver
   *
   * This view extends the ux point automanager, omitting the New command.
   *
   * @class
   * @extends module:nmodule/ndriver/rc/NPointManager
   * @alias module:nmodule/ace/rc/AcePointManager
   *
   */
  var AcePointManager = function AcePointManager(params) {
    NPointManager.call(this, params);
  };
  AcePointManager.prototype = Object.create(NPointManager.prototype);
  AcePointManager.prototype.constructor = AcePointManager;

  /**
   * Returns the default set of Commands for a point manager, removing the NewCommand.
   *
   * @returns {Array.<module:bajaux/commands/Command>}
   */
  AcePointManager.prototype.makeCommands = function () {
    return NPointManager.prototype.makeCommands.apply(this, arguments).then(function (commands) {
      return _.filter(commands, function (cmd) {
        return !(cmd instanceof NewCommand);
      });
    });
  };
  return AcePointManager;
});
