function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @since Niagara 4.14
 * @module nmodule/nrio/rc/wb/mgr/NrioDeviceUxManager
 */

define(['baja!', 'lex!nrio', 'baja!nrio:NrioNetwork,nrio:NrioDeviceTypeEnum,nrio:Nrio34Module,nrio:Nrio16Module,nrio:NrioDeviceFolder', 'Promise', 'underscore', 'nmodule/driver/rc/wb/mgr/DeviceMgr', 'nmodule/nrio/rc/wb/mgr/commands/UpgradeFirmwareCommand', 'nmodule/nrio/rc/wb/mgr/commands/WinkDeviceCommand', 'nmodule/nrio/rc/wb/mgr/model/NrioDeviceLearnModel', 'nmodule/nrio/rc/wb/mgr/model/NrioDeviceManagerModel', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/mgr/commands/MgrCommand', 'nmodule/webEditors/rc/wb/mgr/MgrLearn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'nmodule/webEditors/rc/wb/tree/TreeNode'], function (baja, lexs, types, Promise, _, DeviceMgr, UpgradeFirmwareCommand, WinkDeviceCommand, NrioDeviceLearnModel, NrioDeviceManagerModel, compUtils, MgrCommand, MgrLearn, MgrTypeInfo, mgrUtils, TreeNode) {
  'use strict';

  var getLearnTableSelectedSubjects = mgrUtils.getLearnTableSelectedSubjects;
  var _lexs = _slicedToArray(lexs, 1),
    NRIO_LEX = _lexs[0];
  var NRIO_DEVICE_TYPE = baja.lt('nrio:NrioDevice');
  var DISCOVERY_NODE_ICON = baja.Icon.make(['module://icons/x16/device.png']);
  var NRIO_DEVICE_TYPES = baja.lt('nrio:NrioDeviceTypeEnum');
  var REMOTE_INPUT_OUTPUT = NRIO_DEVICE_TYPES.tagToOrdinal("remoteInputOutput");
  var IO_16 = NRIO_DEVICE_TYPES.tagToOrdinal('io16');
  var IO_16_V1 = NRIO_DEVICE_TYPES.tagToOrdinal('io16V1');
  var IO_34 = NRIO_DEVICE_TYPES.tagToOrdinal('io34');
  var IO_34_SEC = NRIO_DEVICE_TYPES.tagToOrdinal('io34sec');
  var REMOTE_READER = NRIO_DEVICE_TYPES.tagToOrdinal('remoteReader');
  var _MgrCommand$flags = MgrCommand.flags,
    LEARN_CONTEXT_MENU = _MgrCommand$flags.LEARN_CONTEXT_MENU,
    NONE = _MgrCommand$flags.NONE;
  var WINKING = NRIO_LEX.get("winking");

  /**
   * Reloads the contents of the discovery table following the completion
   * of the discovery job.
   *
   * @param mgr - the manager instance.
   * @returns {Promise}
   */
  function reloadLearnModel(mgr) {
    var model = mgr.getLearnModel(),
      currentCount = model.getRows().length,
      nodes,
      promise;
    nodes = _.map(mgr.$discoveries || [], makeDiscoveryTableNode);
    promise = currentCount ? model.removeRows(0, currentCount) : Promise.resolve();
    return promise.then(function () {
      return model.insertRows(nodes, 0);
    });
  }

  /**
   * Make a tree node for an item in the discovery table. Device discovery
   * nodes never have any children.
   *
   * @param  {Object} discovery - a discovered object.
   * @returns {module:nmodule/webEditors/rc/wb/tree/TreeNode}
   */
  function makeDiscoveryTableNode(discovery) {
    var name = String(discovery.deviceName),
      node = new TreeNode(name, name);
    node.getIcon = _.constant(DISCOVERY_NODE_ICON);
    node.mayHaveKids = _.constant(false);
    node.value = _.constant(discovery);
    return node;
  }

  /**
   * Device manager for the Nrio devices
   * @class
   * @alias module:nmodule/nrio/rc/wb/mgr/NrioDeviceUxManager
   * @extends module:nmodule/driver/rc/wb/mgr/DeviceMgr
   */
  var NrioDeviceUxManager = /*#__PURE__*/function (_DeviceMgr) {
    function NrioDeviceUxManager() {
      var _this;
      _classCallCheck(this, NrioDeviceUxManager);
      _this = _callSuper(this, NrioDeviceUxManager, [{
        moduleName: 'nrio',
        keyName: 'NrioDeviceUxManager',
        editableTypes: [NRIO_DEVICE_TYPE],
        subscriptionDepth: 3,
        folderType: baja.lt('nrio:NrioDeviceFolder')
      }]);
      MgrLearn(_this);
      return _this;
    }

    /**
     * Intitalizes the class
     * @param {JQuery} dom the dom for the device manager
     * @returns {*}
     */
    _inherits(NrioDeviceUxManager, _DeviceMgr);
    return _createClass(NrioDeviceUxManager, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        this.on('jobcomplete', function (job) {
          if (job.getType().is('nrio:NrioLearnDevicesJob')) {
            this.$discoveryJobComplete(job);
          }
        });
        this.$upgradeFirmwareCommand = new UpgradeFirmwareCommand(this);
        this.$winkDeviceCommand = new WinkDeviceCommand(this);
        return _superPropGet(NrioDeviceUxManager, "doInitialize", this, 3)(arguments);
      }

      /**
       * Called when the discovery job is complete and processes the results
       * @private
       * @param {baja.Component} job the Nrio network Discovery Job
       */
    }, {
      key: "$discoveryJobComplete",
      value: function $discoveryJobComplete(job) {
        var that = this;
        var props = job.getLearnedDevices().getSlots().properties();
        that.$discoveries = props.is('nrio:NrioLearnDeviceEntry').toValueArray();
        this.$jobSubscriber.attach('changed', function () {
          var comp = this;
          var row = that.getLearnModel().getRows().find(function (row) {
            return row.getSubject() === comp;
          });
          var winkCommand = that.$getWinkDeviceCommand();
          var selectedSubjects = getLearnTableSelectedSubjects(that);
          winkCommand.setEnabled(selectedSubjects.length === 1 && winkCommand.canBeInvokedOn(that.getNetwork(), selectedSubjects[0]));
          if (row) {
            that.getLearnModel().emit('rowsChanged', [row]);
          }
        });
        return reloadLearnModel(that)["catch"](baja.error);
      }

      /**
       * Adds the UpgradeFirmwareCommand and WinkDeviceCommand to the standard commands
       * @returns {Promise<Array<module:bajaux/commands/Command>>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        var _this2 = this;
        return _superPropGet(NrioDeviceUxManager, "makeCommands", this, 3)([this, arguments]).then(function (commands) {
          commands.push(_this2.$upgradeFirmwareCommand);
          commands.push(_this2.$winkDeviceCommand);
          return commands;
        });
      }

      /**
       * Makes the main model
       * @param {baja.Component} component
       * @returns {Promise<module:nmodule/nrio/rc/wb/mgr/model/NrioDeviceManagerModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(component) {
        return NrioDeviceManagerModel.make(component);
      }

      /**
       * Makes the learn model
       * @returns {Promise<module:nmodule/nrio/rc/wb/mgr/model/NrioDeviceLearnModel|NrioDeviceLearnModel>}
       */
    }, {
      key: "makeLearnModel",
      value: function makeLearnModel() {
        return Promise.resolve(NrioDeviceLearnModel.make());
      }

      /**
       * Returns the types that can be selected based on the discovery subject
       * @param {baja.Struct} subject nrio learn device
       * @returns {Promise<Array<module:nmodule/webEditors/rc/wb/mgr/MgrTypeInfo>>}
       */
    }, {
      key: "getTypesForDiscoverySubject",
      value: function getTypesForDiscoverySubject(subject) {
        var ordinal = subject.getDeviceType().getOrdinal();
        if (ordinal === REMOTE_INPUT_OUTPUT) {
          return MgrTypeInfo.make({
            from: 'nrio:NrioInputOutputModule'
          });
        } else if (ordinal === IO_16 || ordinal === IO_16_V1) {
          return MgrTypeInfo.make({
            from: 'nrio:Nrio16Module'
          });
        } else if (ordinal === IO_34 || ordinal === IO_34_SEC) {
          return MgrTypeInfo.make({
            from: 'nrio:Nrio34Module'
          });
        } else if (ordinal === REMOTE_READER) {
          return MgrTypeInfo.make({
            from: 'nrio:NrioDevice'
          });
        }
        return Promise.resolve();
      }

      /**
       * Resolve the discovery job's ord, and set it on the manager. This is used
       * when clicking on the discover command button, and also when restoring the
       * manager state from a prior discovery.
       *
       * @private
       * @param {baja.Ord} ord - the ord of a submitted discovery job
       */
    }, {
      key: "$setDiscoveryJobFromOrd",
      value: function $setDiscoveryJobFromOrd(ord) {
        var job = ord;
        return this.setJob({
          jobOrOrd: ord,
          depth: 3
        }).then(function () {
          return job;
        });
      }

      /**
       * Returns the proposed values based on the learnDevice and dbDevice
       * @param {baja.Struct} learnDevice nrio learn device
       * @param {baja.Component} dbDevice the device in the database that we are comparing against
       * returns {Object}
       */
    }, {
      key: "getProposedValuesFromDiscovery",
      value: function getProposedValuesFromDiscovery(learnDevice, dbDevice) {
        var deviceType = learnDevice.getDeviceType();
        var address = learnDevice.getAddress();
        var secAddr = learnDevice.getSecAddr();
        var secAddrInt = this.getLearnModel().getSecAddrInt(secAddr);
        var typeOrdinal = deviceType.getOrdinal();
        var name = deviceType.getTag() + "_" + address;
        if (typeOrdinal === 6) {
          name = name + "_" + secAddr;
        }
        return {
          name: dbDevice && dbDevice.getName() ? dbDevice.getName() : name,
          values: {
            deviceType: deviceType,
            secAddr: secAddrInt > 0 ? secAddrInt : "",
            address: learnDevice.getAddress(),
            uid: learnDevice.getUid()
          }
        };
      }

      /**
       * Returns the network that the manager is attached to
       * @returns {baja.Complex}
       */
    }, {
      key: "getNetwork",
      value: function getNetwork() {
        return compUtils.closest(this.value(), baja.lt('nrio:NrioNetwork'));
      }

      /**
       * Starts the discovery job
       * returns {Promise}
       */
    }, {
      key: "doDiscover",
      value: function doDiscover() {
        var _this3 = this;
        var network = this.getNetwork();
        var status = network.getStatus();
        if (status.isDisabled() || status.isFault()) {
          throw new Error(NRIO_LEX.get('deviceManager.status.disabled'));
        }
        return network.submitDeviceDiscoveryJob().then(function (ord) {
          var childOrd = baja.Ord.make({
            base: baja.Ord.make("station:"),
            child: ord.relativizeToSession()
          });
          return _this3.$setDiscoveryJobFromOrd(childOrd);
        });
      }

      /**
       * Test whether the given object matches the component in the station.  The comparison is
       * based on the UID, but a true will also be returned if the learnDevice wink is active
       * @param {baja.Struct} learnDevice nrio learn device
       * @param {baja.Component} dbDevice the device in the database that we are comparing against
       * @returns {boolean}
       */
    }, {
      key: "isExisting",
      value: function isExisting(learnDevice, dbDevice) {
        if (learnDevice.getUsedBy() === WINKING) {
          return true;
        }
        var typeOrdinal = learnDevice.getDeviceType().getOrdinal();
        if (typeOrdinal === 0 || typeOrdinal === 1) {
          return true;
        }
        if (baja.hasType(dbDevice, 'nrio:NrioDevice')) {
          return learnDevice.getUid().toString() === dbDevice.getUid().toString();
        }
        return false;
      }

      /**
       * Will perform extra checks to set the enabling of the add, match and winking commands
       * @inheritDoc
       */
    }, {
      key: "onTableSelectionChanged",
      value: function onTableSelectionChanged(selectedSubjects) {
        var _this4 = this;
        return _superPropGet(NrioDeviceUxManager, "onTableSelectionChanged", this, 3)(arguments).then(function () {
          var learnTableSelection = selectedSubjects.learnTableSelection;
          var addCommand = _this4.$getAddCommand();
          var winkCommand = _this4.$getWinkDeviceCommand();
          var network = _this4.getNetwork();
          var learnSel;
          var winkEnabled = false;
          var winkFlags = NONE;
          if (learnTableSelection.length === 1) {
            learnSel = learnTableSelection[0];
            //one learn entry is selected so we want to show the wink command
            winkFlags = LEARN_CONTEXT_MENU;
            return _this4.getExisting(learnSel).then(function (existing) {
              if (existing) {
                addCommand.setEnabled(false);
              } else if (winkCommand.canBeInvokedOn(network, learnSel)) {
                winkEnabled = true;
              }
              winkCommand.setEnabled(winkEnabled);
              winkCommand.setFlags(winkFlags);
            });
          }
          winkCommand.setEnabled(winkEnabled);
          winkCommand.setFlags(winkFlags);
        });
      }

      /**
       * @since Niagara 4.14
       * @param {*} learnSubject the item selected in the learn table
       * @param {baja.Component} mainSubject the subject from the main table that the learn table
       * subject is being matched to
       * @returns {boolean}
       */
    }, {
      key: "isMatchable",
      value: function isMatchable(learnSubject, mainSubject) {
        var databaseTypeOrdinal = mainSubject.getDeviceType().getOrdinal();
        var discoveryTypeOrdinal = learnSubject.getDeviceType().getOrdinal();
        var io16 = NRIO_DEVICE_TYPES.tagToOrdinal('io16');
        var io16V1 = NRIO_DEVICE_TYPES.tagToOrdinal('io16V1');
        if (databaseTypeOrdinal === discoveryTypeOrdinal || databaseTypeOrdinal === io16 && discoveryTypeOrdinal === io16V1 || databaseTypeOrdinal === io16V1 && discoveryTypeOrdinal === io16) {
          return mainSubject.getStatus().isDown() || mainSubject.getAddress() === 0;
        }
        return false;
      }

      /**
       * Returns the UpgradeFirmwareCommand
       * @private
       * @returns {module:nmodule/nrio/rc/wb/mgr/commands/UpgradeFirmwareCommand}
       */
    }, {
      key: "$getUpgradeFirmwareCommand",
      value: function $getUpgradeFirmwareCommand() {
        return this.$upgradeFirmwareCommand;
      }

      /**
       * Returns the WinkDeviceCommand
       * @private
       * @returns {module:nmodule/nrio/rc/wb/mgr/commands/WinkDeviceCommand}
       */
    }, {
      key: "$getWinkDeviceCommand",
      value: function $getWinkDeviceCommand() {
        return this.$winkDeviceCommand;
      }

      /**
       * Save the state we require for restoring after a hyperlink or page reload.
       * In addition to the visible columns saved by the base type, this will save
       * the ord of any job we may be displaying in the job bar and the ord of the
       * point ext.
       *
       * @returns {Object} an object with the state to be persisted
       */
    }, {
      key: "saveStateForOrd",
      value: function saveStateForOrd() {
        var job = this.getJob();
        var jobOrd = job && job.getNavOrd();
        var network = this.getNetwork();
        var networkOrd = network && network.getNavOrd();
        var obj = {};
        if (networkOrd) {
          obj.$networkOrd = networkOrd.encodeToString();
        }
        if (jobOrd) {
          obj.$jobOrd = jobOrd.encodeToString();
        }
        return obj;
      }

      /**
       * Restore the state we saved in the call to saveStateForOrd(). This
       * will reinstate the learn job from the ord we peristed when the state
       * was saved.
       *
       * @param {Object} obj - an object with data retrieved from the browser storage.
       * @returns {Promise.<*>}
       */
    }, {
      key: "restoreStateForOrd",
      value: function restoreStateForOrd(obj) {
        var _this5 = this;
        var currNetwork = this.getNetwork();
        var currNetworkOrd = currNetwork && currNetwork.getNavOrd();
        var jobOrd = obj.$jobOrd;
        var prevNetworkOrd = obj.$networkOrd;
        if (currNetworkOrd && jobOrd && prevNetworkOrd) {
          if (currNetworkOrd.encodeToString() === prevNetworkOrd) {
            // Try to resolve the ord and set the job on the manager. If it
            // can't be resolved (e.g. the job has been cleaned up in the station)
            // then it's not a big deal, just catch the error and carry on. A new
            // discovery job will need to be started again, if required.

            return baja.Ord.make(jobOrd).get().then(function (jobOrd) {
              return _this5.$setDiscoveryJobFromOrd(jobOrd);
            })["catch"](function (ignore) {});
          }
        }
        return Promise.resolve();
      }
    }]);
  }(DeviceMgr);
  return NrioDeviceUxManager;
});
