function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * A module defining `NrioTabularThermistorConversionEditor`.
 * API Status: **Private**
 * @module nmodule/nrio/rc/fe/NrioTabularThermistorConversionEditor
 */
define(['nmodule/driver/rc/fe/BaseTabularConversionEditor', 'Promise', 'lex!nrio', 'nmodule/nrio/rc/baja/NrioTabularThermistorConversion'], function (BaseTabularConversionEditor, Promise, lexs, NrioTabularThermistorConversion) {
  'use strict';

  var nrioLex = lexs[0];

  /**
   * Bajaux for Tabular conversion
   *
   * @class
   * @extends module:bajaux/Widget
   * @alias module:nmodule/nrio/rc/fe/NrioTabularThermistorConversionEditor
   */
  var NrioTabularThermistorConversionEditor = function NrioTabularThermistorConversionEditor() {
    var that = this;
    BaseTabularConversionEditor.apply(that, arguments);
  };

  //extend and set up prototype chain
  NrioTabularThermistorConversionEditor.prototype = Object.create(BaseTabularConversionEditor.prototype);
  NrioTabularThermistorConversionEditor.prototype.constructor = NrioTabularThermistorConversionEditor;

  /**
   * @see BaseTabularConversionEditor.getInitDomProps
   */
  NrioTabularThermistorConversionEditor.prototype.getInitDomProps = function () {
    return {
      labels: {
        desc: nrioLex.get("tabularDialog.descriptionLabel"),
        source: nrioLex.get("tabularDialog.ohmsColumnLabel"),
        result: nrioLex.get("tabularDialog.celsiusColumnLabel")
      }
    };
  };

  /**
   * Reads the editor data into a NrioTabularThermistorConversion object
   * @returns {Promise} promise to be resolved with the current value
   */
  NrioTabularThermistorConversionEditor.prototype.doRead = function () {
    return Promise.all([this.$getDescEditor().read(), this.getBuilder().readAll()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        desc = _ref2[0],
        points = _ref2[1];
      return NrioTabularThermistorConversion.make(desc, points);
    });
  };
  return NrioTabularThermistorConversionEditor;
});
