/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/nrio/rc/baja/NrioShunt500OhmConversion
 */
define(['baja!'], function (baja) {
  'use strict';

  var objUtil = require('bajaScript/baja/obj/objUtil');
  var Simple = baja.Simple,
    cacheDecode = objUtil.cacheDecode,
    cacheEncode = objUtil.cacheEncode;

  /**
   * BajaScript representation of a `nrio:NrioShunt500OhmConversion` value.
   *
   * @class
   * @extends {baja.Simple}
   * @alias {module:nmodule/nrio/rc/baja/NrioShunt500OhmConversion}
   */
  var NrioShunt500OhmConversion = function NrioShunt500OhmConversion() {
    Simple.apply(this, arguments);
  };
  NrioShunt500OhmConversion.prototype = Object.create(Simple.prototype);
  NrioShunt500OhmConversion.prototype.constructor = NrioShunt500OhmConversion;

  /**
   * Create a new `nrio:NrioShunt500OhmConversion` instance from the arguments.
   * @returns {module:nmodule/nrio/rc/baja/NrioShunt500OhmConversion}
   */
  NrioShunt500OhmConversion.make = function (proxyConvTypeSpec, encVal) {
    if (!proxyConvTypeSpec || !baja.hasType(proxyConvTypeSpec)) {
      throw new Error("Not a valid type spec");
    }
    var sc = new NrioShunt500OhmConversion();
    sc.$subConvTypeSpec = proxyConvTypeSpec;
    sc.$encValueStr = encVal || "";
    return sc;
  };

  /**
   * @see .make
   * @returns {module:nmodule/nrio/rc/baja/NrioShunt500OhmConversion}
   */
  NrioShunt500OhmConversion.prototype.make = function () {
    return NrioShunt500OhmConversion.make.apply(NrioShunt500OhmConversion, arguments);
  };

  /**
   * Decode an `NrioShunt500OhmConversion` from a string.
   *
   * @function
   * @param {String} str
   * @returns {module:nmodule/nrio/rc/baja/NrioShunt500OhmConversion}
   */
  NrioShunt500OhmConversion.prototype.decodeFromString = cacheDecode(function (str) {
    if (!str || str.split(";").length < 2) {
      return NrioShunt500OhmConversion.DEFAULT;
    }
    var semi = str.indexOf(';');
    var typSpec = str.substr(0, semi);
    var encVal = str.substr(semi + 1);
    return NrioShunt500OhmConversion.make(typSpec, encVal);
  });

  /**
   * Encode this `NrioShunt500OhmConversion` to a string.
   *
   * @function
   * @returns {String}
   */
  NrioShunt500OhmConversion.prototype.encodeToString = cacheEncode(function () {
    return this.$subConvTypeSpec + ";" + this.$encValueStr;
  });
  NrioShunt500OhmConversion.prototype.getSubConvTypeSpec = function () {
    return this.$subConvTypeSpec;
  };
  NrioShunt500OhmConversion.prototype.getSubConvValStr = function () {
    return this.$encValueStr;
  };
  NrioShunt500OhmConversion.DEFAULT = NrioShunt500OhmConversion.make("driver:DefaultProxyConversion", "");
  baja.registerType('nrio:NrioShunt500OhmConversion', function () {
    return NrioShunt500OhmConversion;
  });
  return NrioShunt500OhmConversion;
});
