/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/bacnetOws/rc/wb/mgr/BacnetOwsDeviceUxManager
 */
define(['baja!', 'underscore', 'nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager', 'nmodule/bacnetOws/rc/wb/mgr/commands/GetEnrollmentSummaryCommand', 'nmodule/bacnetOws/rc/wb/mgr/commands/GetEventInformationCommand', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'baja!bacnetOws:BacnetOwsNetwork,bacnetOws:BacnetOwsDeviceFolder'], function (baja, _, BacnetDeviceUxManager, GetEnrollmentSummaryCommand, GetEventInformationCommand, mgrUtils) {
  'use strict';

  var BACNET_OWS_FOLDER_TYPE = baja.lt('bacnetOws:BacnetOwsDeviceFolder');

  ////////////////////////////////////////////////////////////////
  // BacnetOwsDeviceUxManager
  ////////////////////////////////////////////////////////////////

  /**
   * BacnetOwsDeviceUxManager constructor.
   *
   * @class
   * @alias module:nmodule/bacnetOws/rc/wb/mgr/BacnetOwsDeviceUxManager
   * @extends module:nmodule/bacnet/rc/wb/mgr/BacnetDeviceUxManager
   * @param {Object} params
   */
  var BacnetOwsDeviceUxManager = function BacnetOwsDeviceUxManager(params) {
    BacnetDeviceUxManager.call(this, _.extend({
      moduleName: 'bacnetOws',
      keyName: 'BacnetOwsDeviceUxManager',
      folderType: BACNET_OWS_FOLDER_TYPE
    }, params));
  };
  BacnetOwsDeviceUxManager.prototype = Object.create(BacnetDeviceUxManager.prototype);
  BacnetOwsDeviceUxManager.prototype.constructor = BacnetOwsDeviceUxManager;

  /**
   * Return the commands for the manager. The OWS manager adds the enrollment summary
   * and event information commands to those of the base BACnet device manager.
   *
   * @returns {Promise.<Array.<module:bajaux/commands/Command>>}
   */
  BacnetOwsDeviceUxManager.prototype.makeCommands = function () {
    var _this = this;
    return BacnetDeviceUxManager.prototype.makeCommands.apply(this, arguments).then(function (cmds) {
      return cmds.concat([new GetEventInformationCommand(_this), new GetEnrollmentSummaryCommand(_this)]);
    });
  };

  /**
   * In addtion to the default behavior metioned below, this will enable/disable the
   * GetEnrollmentSummary and GetEventInformation commands.
   * @inheritDoc
   */
  BacnetOwsDeviceUxManager.prototype.onTableSelectionChanged = function (selectedSubjects) {
    var _this2 = this;
    return BacnetDeviceUxManager.prototype.onTableSelectionChanged.call(this, selectedSubjects).then(function () {
      var mainTableSelection = selectedSubjects.mainTableSelection;
      var enSummaryCmd = mgrUtils.findCommand(_this2, GetEnrollmentSummaryCommand),
        evInfoCmnd = mgrUtils.findCommand(_this2, GetEventInformationCommand),
        enable = _this2.isSingleDeviceSelected(mainTableSelection);
      evInfoCmnd.setEnabled(enable);
      enSummaryCmd.setEnabled(enable);
    });
  };
  return BacnetOwsDeviceUxManager;
});
