function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * @module nmodule/export/rc/TransformOperationOptionsProvider
 */
define([], function () {
  'use strict';

  /**
   * API Status: **Development**
   *
   * A Provider for TransformOperations options, so that a Widget has the opportunity to adjust the Transform Options
   * just before they are presented to the user.
   *
   * One example where a Widget implements this interface is for the `history:WebHistoryTable`. The
   * WebHistoryTable has its own configurable timeRange, so if a user picks a TransformOperation
   * like `history:HistoryToCsv` which includes its own `timeRange` option, it's good to practice to
   * default the timeRange in the options to the current value of the WebHistoryTable's timeRange.
   *
   * @interface
   * @alias module:nmodule/export/rc/TransformOperationOptionsProvider
   * @since Niagara 4.14
   * @see {@link module:nmodule/export/rc/Transformer#getDefaultConfig}
   */
  var TransformOperationOptionsProvider = /*#__PURE__*/function () {
    function TransformOperationOptionsProvider() {
      _classCallCheck(this, TransformOperationOptionsProvider);
    }
    return _createClass(TransformOperationOptionsProvider, [{
      key: "updateTransformOptions",
      value:
      /**
       * Note that this function will only be called on the subject to the Export command.
       * The only time the subject is a Widget is when using the Export button in the toolbar.
       * These options will be the default for the options in the Export Command and the chosen options
       * are normally persisted to the `userData`. This is done so that these options can be reused as the
       * defaults on next Export Command that has the same `TransformOperation`. If there are any options
       * in which you want to avoid persisting for the next Export Command, you can also change the
       * slots flags to include transient, and they will not be persisted.
       *
       * @abstract
       * @param {baja.Component} config the current options for transform operation.
       * @returns {Promise.<baja.Component>|baja.Component}
       * @see {@link module:nmodule/export/rc/TransformOperationProvider#getTransformOperations}
       */
      function updateTransformOptions(config) {
        throw new Error('not implemented');
      }
    }]);
  }();
  return TransformOperationOptionsProvider;
});
