define(['baja!', 'baja!baja:JobState', 'lex!micros,webEditors', 'nmodule/webEditors/rc/wb/table/model/Column'], function (baja, bajaTypes, lexs, Column) {
  'use strict';

  var mLex = lexs[0],
    wLex = lexs[1];
  var microsLex = function microsLex(lexiconKey, defaultText, args) {
    return mLex.getSafe({
      key: lexiconKey,
      def: defaultText || '',
      args: args
    });
  };
  var webEditorsLex = function webEditorsLex(lexiconKey, defaultText, args) {
    return wLex.getSafe({
      key: lexiconKey,
      def: defaultText || '',
      args: args
    });
  };
  var typeSpec = {
    BOOLEAN_POINT: 'control:BooleanPoint',
    DEVICE: 'driver:Device',
    JOB_STATE: 'baja:JobState',
    MICROS_DB_SYNC_JOB: 'micros:MicrosDatabaseSyncJob',
    MICROS_DEVICE: 'micros:MicrosDevice',
    MICROS_NETWORK: 'micros:MicrosNetwork',
    MICROS_POINT_FOLDER: 'micros:MicrosPointFolder',
    MICROS_PROXY_EXT: 'micros:MicrosProxyExt',
    MICROS_POINT_DEVICE_EXT: 'micros:MicrosPointDeviceExt'
  };
  var flags = {
    UNSEEN: Column.flags.UNSEEN,
    EDITABLE: Column.flags.EDITABLE,
    READONLY: Column.flags.READONLY
  };
  var JOB_STATE_ENUM = baja.$('baja:JobState');
  var JobState = {
    ENUM: JOB_STATE_ENUM,
    FAILED: JOB_STATE_ENUM.get('failed'),
    SUCCESS: JOB_STATE_ENUM.get('success'),
    // stick with the typo below as it's copied from elsewhere
    CANCELED: JOB_STATE_ENUM.get('canceled')
  };
  var JOB_ICONS = {
    message: '/module/icons/x16/info.png',
    icondefault: '/module/icons/x16/info.png',
    unknown: '/module/icons/x16/job/unknown.png',
    running: '/module/icons/x16/job/running.png',
    failed: '/module/icons/x16/job/failed.png',
    canceled: '/module/icons/x16/job/failed.png',
    canceling: '/module/icons/x16/job/failed.png',
    success: '/module/icons/x16/job/success.png'
  };
  var getJobIcon = function getJobIcon(id) {
    var icon = JOB_ICONS[id.toLowerCase()];
    if (!icon) {
      icon = JOB_ICONS.icondefault;
    }
    return icon;
  };
  return {
    microsLex: microsLex,
    webEditorsLex: webEditorsLex,
    typeSpec: typeSpec,
    flags: flags,
    JobState: JobState,
    getJobIcon: getJobIcon
  };
});
